
#ifndef  __JBXL_GRAPHIC_DATA_H_
#define  __JBXL_GRAPHIC_DATA_H_


/**
グラフィックデータ定義用ヘッダ   gdata.h   v3.0   '02/8/27
                               			(C) Fumi.Iseki

  依存関係
      #include "gheader.h"
      #include "matrix.h"

*/



#include "gheader.h"
#include "matrix.h"




////////////////////////////////////////////////////////////////////////////////////////////////
// グラフィックデータの構造 (C)

/**
BSGRraph :Memory type (メモリ内で使用する型）
    int xs   : xサイズ. 4Byte.  
    int ys   : yサイズ. 4Byte.
    int zs   : zサイズ. 4Byte. 2Dの場合は 1.
	int state: 状態
    Byte* gp : グラフィックデータへのポインタ. xs*ys*zs*1Byte.

    符号有りバイト型(1Byte)シンプルグラフィックデータ． 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    sByte* gp;
} BSGraph;



/**
WSGRraph :Memory type (メモリ内で使用する型）
    int xs   : xサイズ. 4Byte.  
    int ys   : yサイズ. 4Byte.
    int zs   : zサイズ. 4Byte. 2Dの場合は 1.
	int state: 状態
    sWord* gp: グラフィックデータへのポインタ. xs*ys*zs*2Byte.

    符号有りワード型(2Byte)シンプルグラフィックデータ． 
    プログラム中での画像データのデフォルト．
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    sWord* gp;
} WSGraph;




/**
ISGRraph :Memory type (メモリ内で使用する型）
    int xs   : xサイズ. 4Byte.  
    int ys   : yサイズ. 4Byte.
    int zs   : zサイズ. 4Byte. 2Dの場合は 1.
	int state: 状態
    integer* gp : グラフィックデータへのポインタ. xs*ys*zs*4Byte.

    整数型シンプルグラフィックデータ． 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    int*   gp;
} ISGraph;




/**
FSGRraph :Memory type (メモリ内で使用する型）
    int xs   : xサイズ. 4Byte.  
    int ys   : yサイズ. 4Byte.
    int zs   : zサイズ. 4Byte. 2Dの場合は 1.
	int state: 状態
    foat* gp : グラフィックデータへのポインタ. xs*ys*zs*sizeof(float)

    実数型シンプルグラフィックデータ． 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    float* gp;
} FSGraph;





/**
VSGRraph :Memory type (メモリ内で使用する型）
    int xs    : xサイズ. 4Byte.  
    int ys    : yサイズ. 4Byte.
    int zs    : zサイズ. 4Byte. 2Dの場合は 1.
	int state : 状態
    vector* gp: グラフィックデータへのポインタ. xs*ys*zs*sizeof(vector).

    ベクトル型シンプルグラフィックデータ． 
*/
typedef struct {
    int    xs;
    int    ys;
    int    zs;
	int    state;
    vector *gp;
} VSGraph;




/**
MSGRraph :Memory type (メモリ内で使用する型）
    int xs   : xサイズ. 4Byte.  
    int ys   : yサイズ. 4Byte.
    int zs   : zサイズ. 4Byte. 2Dの場合は 1.
    int depth: Color Depth
	int state: 状態
    void* gp : グラフィックデータへのポインタ. xs*ys*zs*depth.

    汎用型シンプルグラフィックデータ． 
*/
typedef struct {
    int  xs;
    int  ys;
    int  zs;
    int  depth;
	int  state;
    unsigned char *gp;
} MSGraph;





/**
境界構造体  RBound 
    int xmin: x軸境界の最小値．
    int xmax: x軸境界の最大値．
    int ymin: y軸境界の最小値．
    int ymax: y軸境界の最大値．
    int zmin: z軸境界の最小値．
    int zmax: z軸境界の最大値．
    int misc: 多目的用．

    グラフィックデータの様々な境界情報を保存する型． 
*/
typedef struct {
    int xmin;
    int xmax;
    int ymin;
    int ymax;
    int zmin;
    int zmax;
    int misc;
} RBound;



typedef struct {
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    double zmin;
    double zmax;
    int	   misc;
} DRBound;





extern  int 	ZeroBase;
extern  float   RZxy;
extern  int     ChkRZxy;



/**/

WSGraph B2WSGraph(BSGraph vp);
WSGraph I2WSGraph(ISGraph vp);
WSGraph F2WSGraph(FSGraph vp);
ISGraph W2ISGraph(WSGraph vp);
FSGraph W2FSGraph(WSGraph vp);
WSGraph V2WSGraph(VSGraph vp);
FSGraph V2FSGraph(VSGraph vp);

BSGraph make_BSGraph(int xs, int ys, int zs);
WSGraph make_WSGraph(int xs, int ys, int zs);
FSGraph make_FSGraph(int xs, int ys, int zs);
ISGraph make_ISGraph(int xs, int ys, int zs);
VSGraph make_VSGraph(int xs, int ys, int zs);
MSGraph make_MSGraph(int xs, int ys, int zs, int depth);


WSGraph zoom_WSGraph(WSGraph vp, int zm, int mode);
WSGraph grab_WSGraph(WSGraph vp, int x1, int y1, int x2, int y2);
void    copy_WSGraph(WSGraph src, WSGraph dst);

int     chk_RZxy(void);
void    set_RZxy(float rzm);
void    init_RBound (RBound* rb);
void    init_DRBound(DRBound* rb);
#define unset_RZxy()    {ChkRZxy=OFF;}

void	free_CmnHead(CmnHead* hd);      // 共通ヘッダのメモリ領域を開放する
void	init_CmnHead(CmnHead* hd);

/**/



/**
マクロ関数

    free_Graph(WSGrapg* vp)              グラフィックデータ vpのバッファ部を解放する． 
    Lx(WSGRaph vp, int i)                １次元画像データ vpの (i) のデータを参照する．
    Px(WSGRaph vp, int i, int j)         ２次元画像データ vpの (i, j) のデータを参照する．
    Vx(WSGRaph vp, int i, int j, int k)  ３次元画像データ vpの (i, j, k) のデータを参照する．
*/
#define  free_Graph(vp)    {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_WSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_BSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_FSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_ISGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_VSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=0;}
#define  free_MSGraph(vp)  {if((vp)->gp)free((vp)->gp); (vp)->gp=NULL; (vp)->xs=(vp)->ys=(vp)->zs=(vp)->state=(vp)->depth=0;}

#define  Lx(vp, i)        ((vp).gp[(i)])
#define  Px(vp, i, j)     ((vp).gp[(i)+(vp).xs*(j)])
#define  Vx(vp, i, j, k)  ((vp).gp[(i)+(vp).xs*(j)+(vp).xs*(vp).ys*(k)])

#define  Lxt(vp, i)       ((vp).gp[((i)-1)])
#define  Pxt(vp, i, j)    ((vp).gp[((i)-1)+(vp).xs*((j)-1)])
#define  Vxt(vp, i, j, k) ((vp).gp[((i)-1)+(vp).xs*((j)-1)+(vp).xs*(vp).ys*((k)-1)])



#endif

