
#ifndef  __JBXL_WINDOW_H_
#define  __JBXL_WINDOW_H_


/**
グラフィック用ワールド座標系サポートヘッダ  window.h  v2.1

  依存関係
      #include "graph.h"

*/

#include "graph.h"



/**
大域変数．

    X_Dx: ワールド座標系の x成分1ドットに対するスクリーン座標系のドット数．
    X_Dy: ワールド座標系の y成分1ドットに対するスクリーン座標系のドット数．
    X_Wx: スクリーン座標系の原点に対するワールド座標系の x成分．
    X_Wy: スクリーン座標系の原点に対するワールド座標系の y成分．

    X_Now: ペンの現地点の x成分(ワールド座標系)
    Y_Now: ペンの現地点の y成分(ワールド座標系)

*/
extern double  X_Dx, X_Dy, X_Wx, X_Wy;
extern double  X_Now, Y_Now;


/**/
void  setWindow(WSGraph vp, double x1, double y1, double x2, double y2);
void  wSetPixel(WSGraph vp, double x1, double y1, int cc);
int   wGetPixel(WSGraph vp, double x1, double y1);
void  wLine(WSGraph vp, double x1, double y1, double x2, double y2, int cc);

void  wMove(double x1, double y1);
void  wDraw(WSGraph vp, double x1, double y1, int cc);
void  wMove_Rel(double x1, double y1);
void  wDraw_Rel(WSGraph vp, double x1, double y1, int cc);

/**/


#endif

