/* vi: set tabstop=4 noautoindent: */

#ifndef  DISABLE_LDAP

#ifndef  __JBXL_LDAP_TOOL_H_
#define  __JBXL_LDAP_TOOL_H_


/**
LDAP用ライブラリヘッダ

	by Fumi.Iseki (C) 2011 14 Aug.


  	コンパイルオプション
		-I/usr/include -L/usr/lib -lldap

---------------------------------------------------------------
このプログラムは OpenLDAP を使用しています．
This work is part of OpenLDAP Software <http://www.openldap.org/>.

*/ 



#include "common.h"

#ifndef HAVE_LDAP_H
	#ifdef ENABLE_LDAP
   		#error ldap_tool.h needs openladp !!
	#endif
#endif


#include "tlist.h"
#include "buffer.h"
#include "xtools.h"
//#include "ssl_tool.h"


#ifndef LDAP_DEPRECATED
	#define LDAP_DEPRECATED 1
#endif
#include <ldap.h>



struct  _jbl_ldap_host {
	Buffer  hostname;
	unsigned short port;
	int		useSSL;
	int		reqCert;
};


struct  _jbl_ldap_dn {
	Buffer  base;
	Buffer  dnbind;
	Buffer  passwd;
};


typedef  struct _jbl_ldap_host  JBL_LDAP_Host;
typedef  struct _jbl_ldap_dn   	JBL_LDAP_Dn;


extern JBL_LDAP_Host* JBLdapHost;
extern JBL_LDAP_Dn*   JBLdapDnBind;




void  	read_ldap_config_file(char* fn);
LDAP*  	open_ldap_connection(char* fn);
int  	simple_check_ldap_passwd(LDAP* ld, char* userid, char* passwd);
int  	check_ldap_passwd(LDAP* ld, JBL_LDAP_Dn user);
void  	close_ldap_connection(LDAP* ld, int clear);


void  	init_LDAP_Host(JBL_LDAP_Host* host);
void  	init_LDAP_Dn(JBL_LDAP_Dn* dn);

void  	free_LDAP_Host(JBL_LDAP_Host* host);
void  	free_LDAP_Dn(JBL_LDAP_Dn* dn);

JBL_LDAP_Host* new_LDAP_Host(void);
JBL_LDAP_Dn*   new_LDAP_Dn(void);

void  del_LDAP_Host(JBL_LDAP_Host** host);
void  del_LDAP_Dn(JBL_LDAP_Dn** dn);






#endif		// _LDAP_TOOL_H

#endif		// DISABLE_LDAP

