/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBXL_PROTOCOL_H_
#define  __JBXL_PROTOCOL_H_


#ifdef WIN32
	#include "tools++.h"
#endif

#include "tools.h"
#include "network.h"
#include "buffer.h"
#include "tlist.h"
#include "xtools.h"



/**/

// Header tList のキー
#define HDLIST_FIRST_LINE_KEY  		"FIRST_LINE"
#define HDLIST_CONTENTS_KEY			"CONTENTS_DATA"
#define HDLIST_CONTINUE  			"HEADER_CONTINUE"
#define HDLIST_END_KEY				"HEADER_END"




/**
Example)

	tList* lp  = get_protocol_header_list(buf, ':', TRUE, TRUE);
	Buffer cnt = restore_protocol_contents(lp);
	.........
	.........
	.........
	set_protocol_contents(lp, cnt);
	Buffer snd = restore_protocol_header(lp, ": ", ON, NULL);

	free_Buffer(&cnt);
	del_tList(&lp);

*/





//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Protocol Header
//

tList*  get_protocol_header_list(Buffer buf, char deli, int fstline, int rcntnt);
Buffer  restore_protocol_header (tList* pp, char* deli, int mode, int* hdsz);

Buffer  restore_protocol_contents(tList* pp);
void	set_protocol_contents(tList* pp, Buffer cnt);

tList*  get_protocol_header_list_seq(tList* list, Buffer buf, char deli, int fstline, int rcntnt);
tList*  get_protocol_header_list_file(char* fname, char deli, int fstline, int rcntnt);

// ヘッダデータの作成
#define create_protocol_header(p, k, v)           			add_tList_node_bystr((p), 0, 0, (char*)(k), (char*)(v), NULL, 0)
#define create_protocol_header_Buffer(p, k, v)    			add_tList_node_byBuffer((p), 0, 0, (k), (v), NULL, 0)
#define delete_protocol_header(p, k, n)    					del_tList_key((p), (k), (n))



// 検索    ldat.valのコピーを返す
Buffer  search_protocol_header(tList* list, char* key, int no);
Buffer  search_protocol_header_item (tList* list, char* key, int no, char deli, int nm);
Buffer  search_protocol_header_value(tList* list, char* key, char* data, int no);
Buffer  search_protocol_header_partvalue(tList* list, char* key, char* data, int no);

#define get_protocol_header(l, k, n) 						search_protocol_header((l), (k), (n))
#define get_protocol_header_item (l, k, n, d, n) 			search_protocol_header_item ((l), (k), (n), (d), (n))
#define get_protocol_header_value(l, k, d, n) 				search_protocol_header_value((l), (k), (d), (n)) 
#define get_protocol_header_partvalue(l, k, d, n) 			search_protocol_header_partvalue((l), (k), (d), (n))


// 設定，置き換え
int 	set_protocol_header(tList* list, char* key, int no, char* value, int mode);
#define	replace_protocol_header(l, k, n, s, v)				replace_value_tList((l), (k), (n), (s), (v))
#define	set_protocol_header_item(l, k, n, d, m, v)			set_item_tList((l), (k), (n), (d), (m), (v))
#define replace_protocol_header_item(l, k, n, d, m, s, v)	replace_item_tList((l), (k), (n), (d), (m), (s), (v))

#define	set_protocol_record_item(l, d, m, v)				set_item_tList_node((l), (d), (m), (v))
#define replace_protocol_record_item(l, d, m, s, v)			replace_item_tList_node((l), (d), (m), (s), (v))


//
int  	search_crlfcrlf(char* mesg);
int  	is_header_continue(tList* pp);



/**/



#endif



