/* vi: set tabstop=4 nocindent noautoindent: */

#ifndef  __JBXL_MATH_LIBRARY_H_
#define  __JBXL_MATH_LIBRARY_H_


/**
@brief 数学関数ヘッダ     mt.h
@file    mt.h
@author  Fumi.Iseki (C)
*/ 





#include "common.h"
#include <math.h>



extern double EPS;



float    comb(int n, int i);
float    perm(int n, int i);
float    fact(int n); 
double   power(float x, float y);


typedef   double (*PTR_DFFUNC)(double);										///< ニュートン法で解を求める場合の関数の型

int    newton_method(PTR_DFFUNC fn, PTR_DFFUNC df, double* t, double e); 	///< ニュートン法で解を求める







#endif
