/* vi: set tabstop=4 noautoindent: */


#ifndef  __JBXL_LDAP_TOOL_H_
#define  __JBXL_LDAP_TOOL_H_


/**
@brief   LDAP用ライブラリ ヘッダ
@file    ldap_tool.h
@author  Fumi.Iseki (C)
@date    2011 8/14

@par コンパイルオプション
--I/usr/include -L/usr/lib -lldap

@par ライブラリ
--L/usr/lib -lldap 

@attention
このプログラムは OpenLDAP を使用しています．@n
This work is part of OpenLDAP Software <http://www.openldap.org/>.
*/

#include "xtools.h"


#ifndef HAVE_LDAP_H
#ifndef DISABLE_LDAP
#define DISABLE_LDAP
#endif
#endif

#ifdef DISABLE_LDAP
#undef ENABLE_LDAP
#endif



#ifdef ENABLE_LDAP



#ifndef LDAP_DEPRECATED
	#define LDAP_DEPRECATED 1
#endif

#include <ldap.h>



struct  _jbl_ldap_host {
	Buffer  hostname;
	unsigned short port;
	int		useSSL;
	int		reqCert;
};


struct  _jbl_ldap_dn {
	Buffer  base;
	Buffer  dnbind;
	Buffer  passwd;
};


typedef  struct _jbl_ldap_host  JBXL_LDAP_Host;
typedef  struct _jbl_ldap_dn   	JBXL_LDAP_Dn;


extern JBXL_LDAP_Host* JBXLdapHost;
extern JBXL_LDAP_Dn*   JBXLdapDnBind;




void  	read_ldap_config_file(char* fn);
LDAP*  	open_ldap_connection(char* fn);
int  	simple_check_ldap_passwd(LDAP* ld, char* userid, char* passwd);
int  	check_ldap_passwd(LDAP* ld, JBXL_LDAP_Dn user);
void  	close_ldap_connection(LDAP* ld, int clear);


void  	init_LDAP_Host(JBXL_LDAP_Host* host);
void  	init_LDAP_Dn(JBXL_LDAP_Dn* dn);

void  	free_LDAP_Host(JBXL_LDAP_Host* host);
void  	free_LDAP_Dn(JBXL_LDAP_Dn* dn);

JBXL_LDAP_Host* new_LDAP_Host(void);
JBXL_LDAP_Dn*   new_LDAP_Dn(void);

void  del_LDAP_Host(JBXL_LDAP_Host** host);
void  del_LDAP_Dn(JBXL_LDAP_Dn** dn);







#endif		// ENABLE_LDAP

#endif		// __JBXL_LDAP_TOOL_H_

