/**  
	RTP/RTCP Forwarder Program:

				rtp_forwarder.c v1,0  by Fumi.Iseki (C)2009-2010
*/


#include "sip_tool.h"

#include "sip_fwdtools.h"
#include "sip_fwdmain.h"
#include "sip_forwarder.h"
#include "rtp_forwarder.h"


/**
	SIP: UA (u) <---> (s) Controll (i) <---> (t) Proxy (v) <---> (x) SIP Server

	RTP: UA (u) <---> (t) Proxy (v) <---> (x) SIP Server


	Process_List
		id		t_port
		lv		プロセス番号
		key		Call-ID


	Trans_Table
		id		t_port
		lv		v_port
		key		Call-ID
		val		Contact ヘッダ
		ptr		RTP_NetInfo へのポインタ．
		sz     	RTP_NetInfo のサイズ．
*/




/**
void   rtp_forwarder_quartet(RTP_NetInfo rtp_info, int tmout)

	RTP/RTCPの中継プログラム本体．4つのソケットを持つ．
*/
void   rtp_forwarder_quartet(RTP_NetInfo* rtp_info, int tmout)
{
	int    nd, cc, num;
	struct sockaddr_in  waddr;
	Buffer buf;

	time_t ntm;
	fd_set mask;
	struct timeval timeout;

	DEBUG_MODE print_message("[%d] RTP_FORWARDER_QUARTET: started.\n", CrntPID);
	DEBUG_MODE {
		print_message("[%d] RTP_FORWARDER_QUARTET: vd_sock = %d\n", CrntPID, rtp_info->vd_sock);
		print_message("[%d] RTP_FORWARDER_QUARTET: vc_sock = %d\n", CrntPID, rtp_info->vc_sock);
		print_message("[%d] RTP_FORWARDER_QUARTET: td_sock = %d\n", CrntPID, rtp_info->td_sock);
		print_message("[%d] RTP_FORWARDER_QUARTET: tc_sock = %d\n", CrntPID, rtp_info->tc_sock);
		print_message("[%d] RTP_FORWARDER_QUARTET: x_port  = %d\n", CrntPID, rtp_info->x_port);
		print_message("[%d] RTP_FORWARDER_QUARTET: v_port  = %d\n", CrntPID, rtp_info->v_port);
		print_message("[%d] RTP_FORWARDER_QUARTET: t_port  = %d\n", CrntPID, rtp_info->t_port);
		print_message("[%d] RTP_FORWARDER_QUARTET: u_port  = %d\n", CrntPID, rtp_info->u_port);
		print_message("[%d] RTP_FORWARDER_QUARTET: xd_addr = %d\n", CrntPID, ntohs(rtp_info->xd_addr.sin_port));
		print_message("[%d] RTP_FORWARDER_QUARTET: xc_addr = %d\n", CrntPID, ntohs(rtp_info->xc_addr.sin_port));
		print_message("[%d] RTP_FORWARDER_QUARTET: ud_addr = %d\n", CrntPID, ntohs(rtp_info->ud_addr.sin_port));
		print_message("[%d] RTP_FORWARDER_QUARTET: uc_addr = %d\n", CrntPID, ntohs(rtp_info->uc_addr.sin_port));
	}

	if (CryptMode==ON && CRYPT_SharedKey!=NULL) init_EVPAPI_Buffer(SSL_3DES3CBC);
	//if (CryptMode==ON && CRYPT_SharedKey!=NULL) init_EVPAPI_Buffer(SSL_AES128CBC);

	//////////////////////////////////////////////////////////////////////////
	//buf = make_Buffer(RECVBUFSZ);
	buf = make_Buffer(MAXBUFSZ);
	num = Max((rtp_info->vd_sock), (rtp_info->vc_sock));
	num = Max((rtp_info->td_sock), num);
	num = Max((rtp_info->tc_sock), num);
	ntm = time(NULL);

	Loop {
		do {
			timeout.tv_sec  = TIME_OUT;
			timeout.tv_usec = 0;
			FD_ZERO(&mask);
			FD_SET(rtp_info->vd_sock, &mask);
			FD_SET(rtp_info->vc_sock, &mask);
			FD_SET(rtp_info->td_sock, &mask);
			FD_SET(rtp_info->tc_sock, &mask);
			nd = select(num+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);

		/////////////////////////////////////////////////////////////////////////////
		// RTP from OutSide 
		if (FD_ISSET(rtp_info->vd_sock, &mask)) {
			//cc = udp_recv_Buffer(rtp_info->vd_sock, &buf, &waddr);
			cc = udp_recv_crypt_Buffer(rtp_info->vd_sock, &buf, &waddr, NULL);
			//fdump(stderr, buf.buf, buf.vldsz);
			if (cc>0) {
				if (!is_same_sockaddr(rtp_info->xd_addr, waddr)) {
					DEBUG_MODE print_message("[%d] RTP_FORWARDER_QUARTET: Warinig: IPPort mismatch at RTP from OutSide.\n", CrntPID);
				}
				ntm = time(NULL);
				//print_message("=== RTP to InSide 1 ============\n");
				cc = udp_send_Buffer(rtp_info->td_sock, &buf, &rtp_info->ud_addr);
				//print_message("=== RTP to InSide 2 ============ cc = %d\n", cc);
			}
			if (cc<=0) break;
		}

		/////////////////////////////////////////////////////////////////////////////
		// RTP from InSide
		if (FD_ISSET(rtp_info->td_sock, &mask)) {
			//print_message("=== RTP from InSide 1 =============\n");
			cc = udp_recv_Buffer(rtp_info->td_sock, &buf, &waddr);
			//print_message("=== RTP from InSide 2 ============= cc = %d\n", cc);
			//fdump(stderr, buf.buf, buf.vldsz);
			if (cc>0) {
				if (!is_same_sockaddr(rtp_info->ud_addr, waddr)) {
					DEBUG_MODE print_message("[%d] RTP_FORWARDER_QUARTET: Warinig: IPPort mismatch at RTP from InSide.\n", CrntPID);
				}
				ntm = time(NULL);
				//print_message("=== RTP to OutSide 1 ============\n");
				//cc  = udp_send_Buffer(rtp_info->vd_sock, &buf, &rtp_info->xd_addr);
				cc  = udp_send_crypt_Buffer(rtp_info->vd_sock, &buf, &rtp_info->xd_addr, NULL);
				//print_message("=== RTP to OutSide 2 ============ cc = %d\n", cc);
			}
			if (cc<=0) break;
		}

		/////////////////////////////////////////////////////////////////////////////
		// RTCP from OutSide 
		if (FD_ISSET(rtp_info->vc_sock, &mask)) {
			//cc = udp_recv_Buffer(rtp_info->vc_sock, &buf, &waddr);
			cc = udp_recv_crypt_Buffer(rtp_info->vc_sock, &buf, &waddr, NULL);
			//print_message("=== RTCP from OutSide =========== cc = %d\n", cc);
			//fdump(stderr, buf.buf, buf.vldsz);
			if (cc>0) {
				if (!is_same_sockaddr(rtp_info->xc_addr, waddr)) {
					DEBUG_MODE print_message("[%d] RTP_FORWARDER_QUARTET: Warinig: IPPort mismatch at RTCP from OutSide.\n", CrntPID);
				}
				ntm = time(NULL);
				cc  = udp_send_Buffer(rtp_info->tc_sock, &buf, &rtp_info->uc_addr);
			}
			if (cc<=0) break;
		}

		/////////////////////////////////////////////////////////////////////////////
		// RTCP from InSide
		if (FD_ISSET(rtp_info->tc_sock, &mask)) {
			cc = udp_recv_Buffer(rtp_info->tc_sock, &buf, &waddr);
			//print_message("=== RTCP from InSide ============ cc = %d\n", cc);
			//fdump(stderr, buf.buf, buf.vldsz);
			if (cc>0) {
				if (!is_same_sockaddr(rtp_info->uc_addr, waddr)) {
					DEBUG_MODE print_message("[%d] RTP_FORWARDER_QUARTET: Warinig: IPPort mismatch at RTCP from InSide.\n", CrntPID);
				}
				ntm = time(NULL);
				//cc  = udp_send_Buffer(rtp_info->vc_sock, &buf, &rtp_info->xc_addr);
				cc  = udp_send_crypt_Buffer(rtp_info->vc_sock, &buf, &rtp_info->xc_addr, NULL);
			}
			if (cc<=0) break;
		}

		if ((int)(time(NULL)-ntm)>tmout) break;
	}

	if (CryptMode==ON) free_EVPAPI_Buffer();

	DEBUG_MODE print_message("[%d] RTP_FORWARDER_QUARTET: exit. idling = %d < %d\n", CrntPID, (int)(time(NULL)-ntm), tmout);

	free_Buffer(&buf);
	return;
}



/**
void   exec_rtp_forwarder(char* call_id, int tmout)

	RTP Forwarder の起動
*/
void   exec_rtp_forwarder(char* call_id, int tmout)
{
	DEBUG_MODE {
		print_message("****************************************************************\n");
		print_message("[%d] EXEC_RTP_FORWARERD: RTP forwarding process is executed.\n", CrntPID);
		print_message("****************************************************************\n\n");
	}

	tList* lp = strncmp_tList(Process_List, call_id, 0, 1);
	if (lp!=NULL) {
		DEBUG_MODE print_message("[%d] EXEC_RTP_FORWARERD: RTP forwarding process is already executed.\n", CrntPID);
		return;
	}

	lp = strncmp_tList(Trans_Table, call_id, 0, 1);
	if (lp==NULL) {
		DEBUG_MODE print_message("[%d] EXEC_RTP_FORWARERD: WARNING: Trans_Table entry is not exist!!\n", CrntPID);
		return;
	}

	RTP_NetInfo* rtp_info = (RTP_NetInfo*)lp->ldat.ptr;
	if (rtp_info==NULL) {
		DEBUG_MODE print_message("[%d] EXEC_RTP_FORWARERD: WARNING: RTP_NetInfo data is not exist in Trans_Table!!\n", CrntPID);
		return;
	}

	if (rtp_info->vd_sock>0 && rtp_info->td_sock>0) {
		pid_t pid = fork();
		if (pid==0) {
			CrntPID = getpid();
			/////////////////////////////////////////////////////////////////////
			rtp_forwarder_quartet(rtp_info, tmout);
			/////////////////////////////////////////////////////////////////////
			del_all_tList(&Process_List);
			del_all_tList(&Trans_Table);
			sip_fdmain_term(0);
		}
		add_list_or_table(Process_List, (int)rtp_info->t_port, (int)pid, call_id, NULL);
		close_rtp_sockets(rtp_info);
	}
	else {
		DEBUG_MODE print_message("[%d] EXEC_RTP_FORWARDER: WARNING: Logical Error??  vd_sock = %d, td_sock = %d\n", CrntPID, rtp_info->vd_sock, rtp_info->td_sock);
		//close_rtp_sockets(rtp_info);
	}

	return;
}



/**
RTP_NetInfo*  open_rtp_sockets_by_sdp(tList* lp, tList* ls, char* call_id, int frm_inside)

	機能：SDPに記述に従って RTP/RTCPソケットを生成．
*/
RTP_NetInfo*  open_rtp_sockets_by_sdp(tList* lp, tList* ls, char* call_id, int frm_inside)
{
	unsigned short port;
	char* ipaddr = NULL;
	RTP_NetInfo* rtp_info = NULL;
	tList* lsdp = NULL;

	if (ls==NULL) lsdp = get_sdp_body_list(lp);
	else 		  lsdp = ls;

	if (lsdp!=NULL) {
		// c=.....
		Buffer buf = search_protocol_header_item(lsdp, "c", 1, ' ', 3);
		ipaddr = (char*)buf.buf;
		// m=.....
		buf = search_protocol_header_item(lsdp, "m", 1, ' ', 2);
		port = atoi((char*)buf.buf);

		free_Buffer(&buf);
		if (ls==NULL) del_tList(&lsdp);
	}
	else return rtp_info;

	//
	tList* lt = strncmp_tList(Trans_Table, call_id, 0, 1);
	if (lt==NULL) {
		print_message("[%d] OPEN_RTP_SOCKET_BY_SDP: WARNING: Trans_Table entry is not exist!!\n", CrntPID);
		freeNull(ipaddr);
		return rtp_info;
	}
	
	if (lt->ldat.ptr==NULL) {
		lt->ldat.sz  = sizeof(RTP_NetInfo);
		lt->ldat.ptr = (void*)malloc(lt->ldat.sz);
		memset(lt->ldat.ptr, 0, lt->ldat.sz);
	}
	rtp_info = (RTP_NetInfo*)lt->ldat.ptr;

	// from InSide
	if (frm_inside) {
		if (lt->ldat.lv==0) {
			int ret = open_rtp_pair_sockets(ipaddr, port, rtp_info, TRUE);
			if (ret) {
				lt->ldat.lv = (int)rtp_info->v_port;
				DEBUG_MODE print_message("[%d] OPEN_RTP_SOCKET_BY_SDP: V socket is opened. (%d, %d)\n", CrntPID, rtp_info->vd_sock, rtp_info->v_port);
			}
			else print_message("[%d] OPEN_RTP_SOCKET_BY_SDP: WARNING: V socket open error!!\n", CrntPID);
		}
		else {
			DEBUG_MODE print_message("[%d] OPEN_RTP_SOCKET_BY_SDP: V socket is already opened. (%d, %d)\n", CrntPID, rtp_info->vd_sock, rtp_info->v_port);
		}
	}

	// from OutSide
	else {
		if (lt->ldat.id==0) {
			int ret = open_rtp_pair_sockets(ipaddr, port, rtp_info, FALSE);
			if (ret) {
				lt->ldat.id = (int)rtp_info->t_port;
				DEBUG_MODE print_message("[%d] OPEN_RTP_SOCKET_BY_SDP: T socket is opened. (%d, %d)\n", CrntPID, rtp_info->td_sock, rtp_info->t_port);
			}
			else print_message("[%d] OPEN_RTP_SOCKET_BY_SDP: WARNING: T socket open error!!\n", CrntPID);
		}
		else {
			DEBUG_MODE print_message("[%d] OPEN_RTP_SOCKET_BY_SDP: T socket is already opened. (%d, %d)\n", CrntPID, rtp_info->td_sock, rtp_info->t_port);
		}
	}

	freeNull(ipaddr);
	return rtp_info;
}



/**
int  open_rtp_pair_sockets(char* ipaddr, unsigned short port, RTP_NetInfo* rtp_info, int frm_inside)

	RTP/RTCP のペアのソケットを生成する．
*/
int  open_rtp_pair_sockets(char* ipaddr, unsigned short port, RTP_NetInfo* rtp_info, int frm_inside)
{
	int  ret = FALSE;
	int  rtp, rtcp;

	if (frm_inside) {	// from InSide  (V socket)
		unsigned short vport = get_valid_rtp_pair_sockets(MinUdpExPort, MaxUdpExPort, &rtp, &rtcp);
		if (rtp>0 && vport>=MinUdpExPort) {
			rtp_info->vd_sock = rtp;
			rtp_info->vc_sock = rtcp;
			rtp_info->v_port  = vport;
			rtp_info->u_port  = port;
			rtp_info->ud_addr = get_sockaddr(ipaddr, port);
			rtp_info->uc_addr = get_sockaddr(ipaddr, port+1);
			ret = TRUE;
		}
	}

	else {				// from OutSide (T socket)
		unsigned short tport = get_valid_rtp_pair_sockets(MinUdpInPort, MaxUdpInPort, &rtp, &rtcp);
		if (rtp>0 && tport>=MinUdpInPort) {
			rtp_info->td_sock = rtp;
			rtp_info->tc_sock = rtcp;
			rtp_info->t_port  = tport;
			rtp_info->x_port  = port;
			rtp_info->xd_addr = get_sockaddr(ipaddr, port);
			rtp_info->xc_addr = get_sockaddr(ipaddr, port+1);
			ret = TRUE;
		}
	}

	return ret;
}



/**

*/
RTP_NetInfo*  get_rtp_netinfo(char* call_id)
{
	tList* lp = strncmp_tList(Trans_Table, call_id, 0, 1);
	if (lp==NULL) return NULL;

	RTP_NetInfo* rtp_info = (RTP_NetInfo*)lp->ldat.ptr;

	return rtp_info;
}



/**
void  close_rtp_sockets(RTP_NetInfo* rtp_info)

*/
void  close_rtp_sockets(RTP_NetInfo* rtp_info)
{
	if (rtp_info->vd_sock>0) close(rtp_info->vd_sock);
	if (rtp_info->vc_sock>0) close(rtp_info->vc_sock);
	if (rtp_info->td_sock>0) close(rtp_info->td_sock);
	if (rtp_info->tc_sock>0) close(rtp_info->tc_sock);
	
	rtp_info->vd_sock = 0;
	rtp_info->vc_sock = 0;
	rtp_info->td_sock = 0;
	rtp_info->tc_sock = 0;

	return;
}



