/**
	RTP Forwarder Program: Header File

				rtp_forwarder.h v1.0  by Fumi.Iseki (C)2009-2010
*/


#ifndef  __RTP_FORWARDER_H_
#define  __RTP_FORWARDER_H_



#include "network.h"




/**
	RTP: UA (u) <-------> (t) Proxy (v) <-------> (x) SIP Server
*/

struct  _rtp_net_info 
{
	int  	vd_sock;
	int  	vc_sock;
	int  	td_sock;
	int  	tc_sock;

	unsigned short x_port;
	unsigned short v_port;
	unsigned short t_port;
	unsigned short u_port;
	
	struct  sockaddr_in  xd_addr;
	struct  sockaddr_in  xc_addr;
	struct  sockaddr_in  ud_addr;
	struct  sockaddr_in  uc_addr;
};

typedef  struct _rtp_net_info	RTP_NetInfo;




//////////////////////////////////////////////////////////////////////////
// Functions

void   			rtp_forwarder_quartet(RTP_NetInfo* rtp_info, int tmout);
void   			exec_rtp_forwarder(char* call_id, int tmout);

RTP_NetInfo*  	open_rtp_sockets_by_sdp(tList* lp, tList* ls, char* call_id, int frm_inside);
int 			open_rtp_pair_sockets(char* ipaddr, unsigned short port, RTP_NetInfo* rtp_info, int frm_inside);

void    		close_rtp_sockets(RTP_NetInfo* rtp_info);
RTP_NetInfo*  	get_rtp_netinfo(char* call_id);



#endif
