/**  
	SIP Forwarder:

				sip_forwarder.c v1.0  by Fumi.Iseki (C) 2009-2010
*/



#include "sip_tool.h"

#include "sip_fwdtools.h"
#include "sip_forwarder.h"
#include "rtp_forwarder.h"



///////////////////////////////////////////////////////////////////////////////////////////////////////
//
/**
	SIP: UA (u) <---> (s) Controll (i) <---> (t) Proxy (v) <---> (x) SIP Server

	RTP: UA (u) <---> (t) Proxy (v) <---> (x) SIP Server

*/



///////////////////////////////////////////////////////////////////////////////////////////////////////
//
/**
	Process_List for RTP
		id	  	t_port
		lv	 	プロセス番号
		key	 	Call-ID


	Trans_Table
		id	 	t_port
		lv	  	v_port
		key	 	Call-ID
		val	 	Contact ヘッダ
		ptr	 	RTP_NetInfo へのポインタ．
		sz	  	RTP_NetInfo のサイズ．
*/



int     CryptMode = OFF;				// 暗号化モード

char*   SIPserverName        = NULL;  	// SIPサーバ FQDN or IP Adderess
unsigned short SIPserverPort = 0;     	// SIPサーバポート番号
char*   SIPdomainName        = NULL;  	// SIPドメイン名

char*   UAgentName			 = NULL; 	// User Agent の作動しているマシン

Buffer  SendPacket_Address;
Buffer  UA_Register_URI;
Buffer  MY_DHspki;



/////////////////////////////////////////////////////////////////////////////////////////////////
/**

*/
Buffer  sip_from_inside(Buffer buf, SIP_PortInfo sip_port, int vsock)
{
	Buffer  snd;
	Buffer* hd;
	Buffer  contact_domain;

	tList*  lp;
	tList*  lh;
	
	RTP_NetInfo* rtp_info = NULL;
	Buffer 	call_id;

	snd = init_Buffer();
	if (buf.buf==NULL) return snd;

	contact_domain = init_Buffer();
	free_Buffer(&SendPacket_Address);

	lp = get_sip_header_list(buf);
	lh = strncmp_tList(lp, HDLIST_FIRST_LINE_KEY, 0, 1);	// Method Line
	if (lh==NULL || lh->ldat.val.buf==NULL) {
		DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: missing sip method line!!\n", CrntPID);
		UDP_DUMP_MODE fdump(stderr, buf.buf, buf.vldsz);
		del_all_tList(&lp);
		snd = dup_Buffer(buf);
		return snd;
	}

	hd = cawk_Buffer_dim(lh->ldat.val, ' ');
	if (hd==NULL || hd->state<2) {
		DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: Fail to decompose the SIP method line.\n", CrntPID);
		UDP_DUMP_MODE fdump(stderr, buf.buf, buf.vldsz);
		if (hd!=NULL) del_Buffer_dim(&hd);
		del_all_tList(&lp);
		snd = dup_Buffer(buf);
		return snd;
	}

	// Max-Forwards
	int max_fds = get_max_forwards(lp);
	set_max_forwards(lp, --max_fds);
	if (max_fds<=0) {
		DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: Max-Forwards is %d\n", CrntPID, max_fds);
		del_Buffer_dim(&hd);
		del_all_tList(&lp);
		snd = dup_Buffer(buf);
		return snd;
	}

	DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: %s  (Max-Forwards = %d)\n", CrntPID, lh->ldat.val.buf, max_fds);

	////////////////////////////////////////////////////////////////////////
	// SIP Packet
	int	   seqno = 0;
	Buffer cseq, methd;

	methd = init_Buffer();
	cseq  = search_protocol_header(lp, "CSeq", 1);
	methd = cawk_Buffer(cseq, ' ', 1);
	seqno = atoi((char*)methd.buf);
	free_Buffer(&methd);
	methd = cawk_Buffer(cseq, ' ', 2);
	free_Buffer(&cseq);

	UDP_DUMP_MODE print_message("[%d] SIP_FROM_INSIDE: Original is here.\n", CrntPID);
	UDP_DUMP_MODE print_message("\n%s\n", buf.buf);

	call_id = search_protocol_header(lp, "Call-ID", 1);
	tList* lt = strncmp_tList(Trans_Table, (char*)call_id.buf, 0, 1);

	// SIP Response from InSide
	if (!strncasecmp((char*)hd[0].buf, "SIP/", 4)) {

		if (lt!=NULL && lt->ldat.val.buf!=NULL) {
			contact_domain = get_sip_domain(lt->ldat.val);
		}
		del_sip_via(lp, MyIntIPaddr, 0);
		del_sip_via(lp, MyExtIPaddr, 0);
		SendPacket_Address = get_sip_via_address(lp, 1);

		// INVITE Response from InSide
		if (!strcasecmp((char*)methd.buf, "INVITE")) {
			if (hd[1].buf[0]=='2') {

				// for CRYPT
				if (CryptMode==ON && MY_DHspki.buf!=NULL) {
					// SDP に Base64_DHspki を挿入
					tList* ls = get_sdp_body_list(lp);
				
					Buffer pki = make_Buffer(MY_DHspki.vldsz + 20);
					copy_s2Buffer(SPKI_MEDIA_KEY, &pki);
					cat_Buffer(&MY_DHspki, &pki);

					tList* pp = find_tList_end(ls);
					pp = add_tTree_node_bystr(pp, 0, 0, "m", (char*)SPKI_MEDIA_TYPE, NULL, 0);
					if (ls==NULL) ls = pp;
					pp = add_tTree_node_bystr(pp, 0, 0, "a", (char*)pki.buf,  NULL, 0);

					DEBUG_MODE {
						print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
						print_tList(stderr, ls);
						print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
					}

    				Buffer sdp = restore_sdp_body(ls);
    				set_sip_contents(lp, sdp);

					free_Buffer(&MY_DHspki);
					free_Buffer(&pki);
					free_Buffer(&sdp);
					del_tList(&ls);
				}

				rtp_info = open_rtp_sockets_by_sdp(lp, NULL, (char*)call_id.buf, TRUE);
				replace_sdp_invite_addr(lp, NULL, MyExtIPaddr, rtp_info->v_port, TRUE);
				exec_rtp_forwarder((char*)call_id.buf, MaxIdleTime);
				DEBUG_MODE print_message("[%d] SIP_FROM_INTSIDE: INVITE Success Response (%s)\n", CrntPID, hd[1].buf);

				struct sockaddr_in addr = get_sockaddr_Buffer(contact_domain);
				if (addr.sin_port==0) addr.sin_port = htons(SIP_DEFAULT_PORT);
				udp_hole_punching(vsock, addr, 4);			// for ACK from OutSide
			}

			else if (hd[1].buf[0]=='1') {
				DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: INVITE Temporarily Response (%s)\n", CrntPID, hd[1].buf);
			}

			else if (hd[1].buf[0]=='3') {
				DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: INVITE Redirect Response (%s)\n", CrntPID, hd[1].buf);
			}

			else {
				DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: INVITE Error Response = %s\n", CrntPID, lh->ldat.val.buf);
				sip_cancel_or_bye((char*)call_id.buf);
			}
		}

		// BYE Response from InSide
		else if (!strcasecmp((char*)methd.buf, "BYE")) {
			sip_cancel_or_bye((char*)call_id.buf);
			free_Buffer(&SendPacket_Address);
			SendPacket_Address = dup_Buffer(contact_domain);

			if (CryptMode==ON) {
				clear_CRYPT_parameter();
			}
		}

		// CACEL Response from InSide
		else if (!strcasecmp((char*)methd.buf, "CACEL")) {
			sip_cancel_or_bye((char*)call_id.buf);
		}

		// other method Response from InSide
		else {
			DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: other response = %s:%d\n", CrntPID, methd.buf, seqno);
		}

		replace_sip_contact(lp, MyExtIPaddr, sip_port.v_port);
	}

	// SIP Request from InSide
	else {
		if (lt!=NULL && lt->ldat.val.buf!=NULL) {
			contact_domain = get_sip_domain(lt->ldat.val);
		}
		else {
			Buffer cntct = get_sip_contact_uri(lp);
			if (cntct.buf!=NULL) {
				contact_domain = get_sip_domain(cntct);
				free_Buffer(&cntct);
			}
		}
		insert_sip_via(lp, MyExtIPaddr, sip_port.v_port, NULL, TRUE);

		// REGISTER Request from InSide
		if (!strcasecmp((char*)hd[0].buf, "REGISTER")) {
			char address[LNAME];
			snprintf(address, LNAME, "sip:%s:%d", SIPserverName, sip_port.x_port);
			set_protocol_record_item(lh, ' ', 2, address);

			if (contact_domain.buf!=NULL) {
				UA_Register_URI = dup_Buffer(contact_domain);
			}
			DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: Requested Register URI = %s\n", CrntPID, UA_Register_URI.buf);
		}

		// INVITE Request from InSide
		else if (!strcasecmp((char*)hd[0].buf, "INVITE")) {
			if (lt==NULL) lt = add_list_or_table(Trans_Table, 0, 0, (char*)call_id.buf, NULL);
			rtp_info = open_rtp_sockets_by_sdp(lp, NULL, (char*)call_id.buf, TRUE);
			replace_sdp_invite_addr(lp, NULL, MyExtIPaddr, rtp_info->v_port, TRUE);

			// for CRYPT
			if (CryptMode==ON && Base64_DHspki!=NULL) {
				// SDP に Base64_DHspki を挿入
				tList* ls = get_sdp_body_list(lp);
				
				Buffer pki = make_Buffer(Base64_DHspki->vldsz + 20);
				copy_s2Buffer(SPKI_MEDIA_KEY, &pki);
				cat_Buffer(Base64_DHspki, &pki);

				tList* pp = find_tList_end(ls);
				pp = add_tTree_node_bystr(pp, 0, 0, "m", SPKI_MEDIA_TYPE, NULL, 0);
				if (ls==NULL) ls = pp;
				pp = add_tTree_node_bystr(pp, 0, 0, "a", (char*)pki.buf,  NULL, 0);

				DEBUG_MODE {
					print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
					print_tList(stderr, ls);
					print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
				}

    			Buffer sdp = restore_sdp_body(ls);
    			set_sip_contents(lp, sdp);

				free_Buffer(&pki);
				free_Buffer(&sdp);
				del_tList(&ls);
			}
		}

		// ACK Request from Inside (Responseなし)
		else if (!strcasecmp((char*)hd[0].buf, "ACK")) {
			char address[LNAME];
			snprintf(address, LNAME, "%s:%d", MyIntIPaddr, sip_port.s_port);
			replace_protocol_record_item(lh, ' ', 2, address, (char*)contact_domain.buf);

			free_Buffer(&SendPacket_Address);
			SendPacket_Address = dup_Buffer(contact_domain);
		}

		// BYE Request from InSide
		else if (!strcasecmp((char*)hd[0].buf, "BYE")) {
			char address[LNAME];
			snprintf(address, LNAME, "%s:%d", MyIntIPaddr, sip_port.s_port);
			replace_protocol_record_item(lh, ' ', 2, address, (char*)contact_domain.buf);

			if (CryptMode==ON) {
				clear_CRYPT_parameter();
			}
		}

		// CANCEL Request from InSide
		else if (!strcasecmp((char*)hd[0].buf, "CANCEL")) {
			char address[LNAME];
			snprintf(address, LNAME, "%s:%d", MyIntIPaddr, sip_port.s_port);
			replace_protocol_record_item(lh, ' ', 2, address, (char*)contact_domain.buf);
		}

		// other method from InSide
		else {
			DEBUG_MODE print_message("[%d] SIP_FROM_INSIDE: other request = %s:%d\n", CrntPID, methd.buf, seqno);
		}

		// Contact Record
		replace_sip_contact(lp, MyExtIPaddr, sip_port.v_port);
	}

	del_sip_record_route_all(lp);
	snd = restore_sip_header(lp);

	UDP_DUMP_MODE print_message("[%d] SIP_FROM_INSIDE: Transfer is here.\n", CrntPID);
	UDP_DUMP_MODE print_message("\n%s\n", snd.buf);

	DEBUG_MODE {
		rtp_info = get_rtp_netinfo((char*)call_id.buf);
		print_message("=== Trans_Table ========== SIP_FROM_INSIDE ==============\n");
		print_tList(stderr, Trans_Table);
		print_message("=========================================================\n");
		if (rtp_info!=NULL) {
			print_message("Socket vd_sock = %d, td_sock = %d\n",rtp_info->vd_sock, rtp_info->td_sock);
			print_message("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
		}
	}

	free_Buffer(&methd);
	free_Buffer(&contact_domain);
	free_Buffer(&call_id);
	del_Buffer_dim(&hd);
	del_all_tList(&lp);

	return snd;
}



/**

*/
Buffer  sip_from_outside(Buffer buf, SIP_PortInfo sip_port, int tsock)
{
	Buffer  snd;
	Buffer* hd;
	Buffer	contact_domain;

	tList*  lp;
	tList*  lh;

	RTP_NetInfo* rtp_info = NULL;
	Buffer	call_id;

	snd = init_Buffer();
	if (buf.buf==NULL) return snd;

	contact_domain = init_Buffer();
	free_Buffer(&SendPacket_Address);

	lp = get_sip_header_list(buf);
	lh = strncmp_tList(lp, HDLIST_FIRST_LINE_KEY, 0, 1);
	if (lh==NULL || lh->ldat.val.buf==NULL) {
		DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: missing sip method line!!\n", CrntPID);
		UDP_DUMP_MODE fdump(stderr, buf.buf, buf.vldsz);
		del_all_tList(&lp);
		snd = dup_Buffer(buf);
		return snd;
	}

	hd = cawk_Buffer_dim(lh->ldat.val, ' ');
	if (hd==NULL || hd->state<2) {
		DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: Fail to decompose the SIP method line.\n", CrntPID);
		UDP_DUMP_MODE fdump(stderr, buf.buf, buf.vldsz);
		if (hd!=NULL) del_Buffer_dim(&hd);
		del_all_tList(&lp);
		snd = dup_Buffer(buf);
		return snd;
	}

	// Max-Forwards
	int max_fds = get_max_forwards(lp);
	set_max_forwards(lp, --max_fds);
	if (max_fds<=0) {
		DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: Max-Forwards is %d\n", CrntPID, max_fds);
		del_Buffer_dim(&hd);
		del_all_tList(&lp);
		snd = dup_Buffer(buf);
		return snd;
	}

	DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: %s  (Max-Forwards = %d)\n", CrntPID, lh->ldat.val.buf, max_fds);

	////////////////////////////////////////////////////////////////////////
	// SIP Packet
	int    seqno = 0;
	Buffer cseq, methd;

	methd = init_Buffer();
	cseq  = search_protocol_header(lp, "CSeq", 1);
	methd = cawk_Buffer(cseq, ' ', 1);
	seqno = atoi((char*)methd.buf);
	free_Buffer(&methd);
	methd = cawk_Buffer(cseq, ' ', 2);
	free_Buffer(&cseq);

	UDP_DUMP_MODE print_message("[%d] SIP_FROM_OUTSIDE: Original is here.\n", CrntPID);
	UDP_DUMP_MODE print_message("\n%s\n", buf.buf);

	call_id = search_protocol_header(lp, "Call-ID", 1);
	tList* lt = strncmp_tList(Trans_Table, (char*)call_id.buf, 0, 1);

	// SIP Response from OutSide
	if (!strncasecmp((char*)hd[0].buf, "SIP/", 4)) {

		del_sip_via(lp, MyIntIPaddr, 0);
		del_sip_via(lp, MyExtIPaddr, 0);

		// REGISTER Response from OutSide
		if (!strcasecmp((char*)methd.buf, "REGISTER")) {
			if (UA_Register_URI.buf!=NULL) {
				Buffer reg_domain;
				unsigned short reg_port;
				decomp_hostport(UA_Register_URI, &reg_domain, &reg_port);
				replace_sip_contact(lp, (char*)reg_domain.buf, reg_port);
				free_Buffer(&reg_domain);
				free_Buffer(&UA_Register_URI);
			}
		}

		// INVITE Response from OutSide
		else if (!strcasecmp((char*)methd.buf, "INVITE")) {
			if (hd[1].buf[0]=='2') {

				// for CRYPT
				if (CryptMode==ON) {
					tList* ls = get_sdp_body_list(lp);
					tList* pp = ls;	
			
					Buffer spki = init_Buffer();
					while (pp!=NULL) {
						if (!strcmp((char*)pp->ldat.key.buf, "m") && !strcmp((char*)pp->ldat.val.buf, SPKI_MEDIA_TYPE)) {
							pp = del_tList_node(pp);
							while (pp!=NULL) {
								if (!strcmp((char*)pp->ldat.key.buf, "a") && !strncmp((char*)pp->ldat.val.buf, SPKI_MEDIA_KEY, strlen(SPKI_MEDIA_KEY))) {
									free_Buffer(&spki);
									spki = cawk_Buffer(pp->ldat.val, ':', 2);
									pp = del_tList_node(pp);
								}
								else break;
							}
							break;
						}
						pp = pp->next;
					}

					if (spki.buf!=NULL) {
						clear_CRYPT_parameter();
						Buffer dec = decode_base64_Buffer(spki);
    					gen_CRYPT_SharedKey(SSL_DH, dec);

						DEBUG_MODE {
							Buffer ckey = encode_base64_Buffer(*CRYPT_SharedKey);
							print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
							print_message("RECV SPKI = %s\n", spki.buf);
							print_message("Crypt Key = %s\n", ckey.buf);
							print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
							free_Buffer(&ckey);
						}

						free_Buffer(&spki);
						free_Buffer(&dec);
					}
					del_tList(&ls);
				}

				if (lt!=NULL && lt->ldat.val.buf==NULL) {
					lt->ldat.val = get_sip_contact_uri(lp);			// contact_domain
				}
				rtp_info = open_rtp_sockets_by_sdp(lp, NULL, (char*)call_id.buf, FALSE);
				replace_sdp_invite_addr(lp, NULL, MyIntIPaddr, rtp_info->t_port, FALSE);
				exec_rtp_forwarder((char*)call_id.buf, MaxIdleTime);	
				DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: INVITE Success Response (%s)\n", CrntPID, hd[1].buf);
			}

			else if (hd[1].buf[0]=='1') {
				DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: INVITE Temporarily Response (%s)\n", CrntPID, hd[1].buf);
			}

			else if (hd[1].buf[0]=='3') {
				DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: INVITE Redirect Response (%s)\n", CrntPID, hd[1].buf);
			}

			else {
				DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: INVITE Error Response = %s\n", CrntPID, lh->ldat.val.buf);
				sip_cancel_or_bye((char*)call_id.buf);
			}
		}

		// BYE Response from OutSide
		else if (!strcasecmp((char*)methd.buf, "BYE")) {
			sip_cancel_or_bye((char*)call_id.buf);

			if (CryptMode==ON) {
				clear_CRYPT_parameter();
			}
		}

		// CANCEL Response from OutSide
		else if (!strcasecmp((char*)methd.buf, "CACEL")) {
			sip_cancel_or_bye((char*)call_id.buf);
		}

		// other method Response from OutSide
		else {
			DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: other response = %s:%d\n", CrntPID, methd.buf, seqno);
		}

		// Contact Record
		if (strcasecmp((char*)methd.buf, "REGISTER")) {
			replace_sip_contact(lp, MyIntIPaddr, sip_port.s_port);		// get_contact_uri() より後方に配置すること
		}
	}

	// SIP Request from OutSide
	else {
		if (lt!=NULL && lt->ldat.val.buf!=NULL) {
			contact_domain = get_sip_domain(lt->ldat.val);
		}

		insert_sip_via(lp, MyIntIPaddr, sip_port.s_port, NULL, TRUE);

		// INVITE Request from OutSide (Called)
		if (!strcasecmp((char*)hd[0].buf, "INVITE")) {
			if (lt==NULL) lt = add_list_or_table(Trans_Table, 0, 0, (char*)call_id.buf, NULL);
			if (lt!=NULL && lt->ldat.val.buf==NULL) {
				lt->ldat.val = get_sip_contact_uri(lp);			// contact_domain
			}

			char faddr[LNAME], taddr[LNAME];
			snprintf(faddr, LNAME, "%s:%d", MyExtIPaddr, sip_port.v_port);
			snprintf(taddr, LNAME, "%s:%d", UAgentName,  sip_port.u_port);
			replace_protocol_record_item(lh, ' ', 2, faddr, taddr);

			rtp_info = open_rtp_sockets_by_sdp(lp, NULL, (char*)call_id.buf, FALSE);
			replace_sdp_invite_addr(lp, NULL, MyIntIPaddr, rtp_info->t_port, FALSE);

			// for CRYPT
			if (CryptMode==ON) {
				// SDP に Base64_DHspki を挿入
				tList* ls = get_sdp_body_list(lp);
				tList* pp = ls;	
			
				Buffer spki = init_Buffer();
				while (pp!=NULL) {
					if (!strcmp((char*)pp->ldat.key.buf, "m") && !strcmp((char*)pp->ldat.val.buf, SPKI_MEDIA_TYPE)) {
						pp = del_tList_node(pp);
						while (pp!=NULL) {
							if (!strcmp((char*)pp->ldat.key.buf, "a") && !strncmp((char*)pp->ldat.val.buf, SPKI_MEDIA_KEY, strlen(SPKI_MEDIA_KEY))) {
								free_Buffer(&spki);
								spki = cawk_Buffer(pp->ldat.val, ':', 2);
								pp = del_tList_node(pp);
							}
							else break;
						}
						break;
					}
					pp = pp->next;
				}

				if (spki.buf!=NULL) {
					Buffer dec = decode_base64_Buffer(spki);
					Buffer enc = get_DHspki_fs(dec);
					MY_DHspki  = encode_base64_Buffer(enc);
    				gen_CRYPT_SharedKey(SSL_DH, dec);

					DEBUG_MODE {
							Buffer ckey = encode_base64_Buffer(*CRYPT_SharedKey);
							print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
							print_message("RECV SPKI = %s\n", spki.buf);
							print_message("MY_DHspki = %s\n", MY_DHspki.buf);
							print_message("Crypt Key = %s\n", ckey.buf);
							print_message("VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV\n");
							free_Buffer(&ckey);
					}

					free_Buffer(&spki);
					free_Buffer(&dec);
					free_Buffer(&enc);
				}
				del_tList(&ls);
			}
		}

		// ACK Request from OutSide (Responseなし)
		else if (!strcasecmp((char*)hd[0].buf, "ACK")) {
			char faddr[LNAME], taddr[LNAME];
			snprintf(faddr, LNAME, "%s:%d", MyExtIPaddr, sip_port.v_port);
			snprintf(taddr, LNAME, "%s:%d", UAgentName,  sip_port.u_port);
			replace_protocol_record_item(lh, ' ', 2, faddr, taddr);
		}

		// BYE Request from OutSide
		else if (!strcasecmp((char*)hd[0].buf, "BYE")) {
			char address[LNAME];

			snprintf(address, LNAME, "%s:%d", MyExtIPaddr, sip_port.v_port);
			replace_protocol_record_item(lh, ' ', 2, address, SIPdomainName);

			if (CryptMode==ON) {
				clear_CRYPT_parameter();
			}
		}

		// CANCEL Request from OutSide
		else if (!strcasecmp((char*)hd[0].buf, "CANCEL")) {
			char faddr[LNAME], taddr[LNAME];

			snprintf(faddr, LNAME, "%s:%d", MyExtIPaddr, sip_port.v_port);
			snprintf(taddr, LNAME, "%s:%d", UAgentName,  sip_port.u_port);
			replace_protocol_record_item(lh, ' ', 2, faddr, taddr);
		}

		// other method from OutSide
		else {
			DEBUG_MODE print_message("[%d] SIP_FROM_OUTSIDE: other request = %s:%d\n", CrntPID, methd.buf, seqno);
		}

		replace_sip_contact(lp, MyIntIPaddr, sip_port.s_port);		// get_contact_uri() より後方
	}

	del_sip_record_route_all(lp);
	snd = restore_sip_header(lp);

	UDP_DUMP_MODE print_message("[%d] SIP_FROM_OUTSIDE: Transfer is here.\n", CrntPID);
	UDP_DUMP_MODE print_message("\n%s\n", snd.buf);

	DEBUG_MODE {
		rtp_info = get_rtp_netinfo((char*)call_id.buf);
		print_message("=== Trans_Table ========== SIP_FROM_OUTSIDE =============\n");
		print_tList(stderr, Trans_Table);
		print_message("=========================================================\n");
		if (rtp_info!=NULL) {
			print_message("Socket vd_sock = %d, td_sock = %d\n",rtp_info->vd_sock, rtp_info->td_sock);
			print_message("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
		}
	}

	free_Buffer(&methd);
	free_Buffer(&contact_domain);
	free_Buffer(&call_id);
	del_Buffer_dim(&hd);
	del_all_tList(&lp);

	return snd;
}




////////////////////////////////////////////////////////////////////////////////////////////////

/**
void   sip_forwarder(int tsock, Buffer buf)

	tsock : コントロールプロセスへのソケット
*/
void   sip_forwarder(int tsock, Buffer buf, SIP_PortInfo sip_port)
{
	int	   cc, num, nd, vsock;
	unsigned short vport;
	struct sockaddr_in  waddr, xaddr, iaddr;
	Buffer snd;

	time_t ntm;
	fd_set mask;
	struct timeval timeout;

	DEBUG_MODE print_message("[%d] SIP_FORWARDER: started.\n", CrntPID);

	init_rand();

    del_all_tList(&Process_List);
    del_all_tList(&Trans_Table);
    Process_List = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, LIST_ANCHOR, NULL, 0);
    Trans_Table  = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, LIST_ANCHOR, NULL, 0);
	SendPacket_Address = init_Buffer();
	UA_Register_URI    = init_Buffer();
	MY_DHspki          = init_Buffer();

	clear_CRYPT_parameter();

	//////////////////////////////////////////////////////////////////////////
	vsock = get_valid_udp_socket(MinUdpExPort, MaxUdpExPort, &vport);
	xaddr = get_sockaddr(SIPserverName, SIPserverPort);
	iaddr = get_local_sockaddr(sip_port.i_port);

	sip_port.v_port = vport;
	sip_port.x_port = SIPserverPort;

	// First Packet from InSide
	snd = sip_from_inside(buf, sip_port, vsock);
	if (snd.buf!=NULL) {
		cc  = udp_send_Buffer(vsock, &snd, &xaddr);
		free_Buffer(&snd);
	}
	else {
		// そのまま転送
		cc  = udp_send_Buffer(vsock, &buf, &xaddr);
	}
	DEBUG_MODE {
		char* ip_addr = get_ipaddr(xaddr.sin_addr);
		print_message("[%d] SIP_FORWARDER: send outside data to [%s:%d]\n\n", CrntPID, ip_addr, ntohs(xaddr.sin_port));
	}

	num = Max(tsock, vsock);
	ntm = time(NULL);

	Loop {
		do {
			timeout.tv_sec  = TIME_OUT;
			timeout.tv_usec = 0;
			FD_ZERO(&mask);
			FD_SET(tsock, &mask);
			FD_SET(vsock, &mask);
			nd = select(num+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);

		/////////////////////////////////////////////////////////////////////////////
		// from InSide
		if (FD_ISSET(tsock, &mask)) {
			cc = udp_recv_Buffer(tsock, &buf, &waddr);
			if (cc>0) {
				DEBUG_MODE {
				//if (!is_same_sockaddr(iaddr, waddr)) {
					Buffer hostport = get_hostport_sockaddr(waddr);
					print_message("[%d] SIP_FORWARDER: Received packet from InSide (%s)\n", CrntPID, hostport.buf);
					free_Buffer(&hostport);
				}

				ntm = time(NULL);
				snd = sip_from_inside(buf, sip_port, vsock);
				if (snd.buf!=NULL) {
					if (SendPacket_Address.buf!=NULL) waddr = get_sockaddr_Buffer(SendPacket_Address);
					else                              waddr = xaddr;	// SIPサーバ
					if (waddr.sin_port==0) waddr.sin_port = htons(SIP_DEFAULT_PORT);

					cc = udp_send_Buffer(vsock, &snd, &waddr);
					free_Buffer(&snd);

					DEBUG_MODE {
						Buffer hostport = get_hostport_sockaddr(waddr);
						print_message("[%d] SIP_FORWARDER: Sended packet to ====> %s\n", CrntPID, hostport.buf);
						if (cc<=0) print_message("[%d] SIP_FORWARDER: Send Error!!     ====> %s\n", CrntPID, hostport.buf);
						free_Buffer(&hostport);
					}
				}
			}
			else {
				DEBUG_MODE print_message("[%d] SIP_FORWARDER: recived abnormal data from inside. cc = %d\n", CrntPID, cc);
				break;
			}
		}

		/////////////////////////////////////////////////////////////////////////////
		// from OutSide
		if (FD_ISSET(vsock, &mask)) {
			cc = udp_recv_Buffer(vsock, &buf, &waddr);
			if (cc>0) {
				DEBUG_MODE {
				//if (!is_same_sockaddr(xaddr, waddr)) {
					Buffer hostport = get_hostport_sockaddr(waddr);
					print_message("[%d] SIP_FORWARDER: Received packet from OutSide (%s)\n", CrntPID, hostport.buf);
					free_Buffer(&hostport);
				}

				ntm = time(NULL);
				snd = sip_from_outside(buf, sip_port, tsock);
				if (snd.buf!=NULL) {
					if (SendPacket_Address.buf!=NULL) waddr = get_sockaddr_Buffer(SendPacket_Address);
					else                              waddr = iaddr;	// コントロールプロセス
					if (waddr.sin_port==0) waddr.sin_port = htons(SIP_DEFAULT_PORT);

					cc = udp_send_Buffer(tsock, &snd, &waddr);
					free_Buffer(&snd);

					DEBUG_MODE {
						Buffer hostport = get_hostport_sockaddr(waddr);
						print_message("[%d] SIP_FORWARDER: Sended packet to ====> %s\n", CrntPID, hostport.buf);
						if (cc<=0) print_message("[%d] SIP_FORWARDER: Send Error!!     ====> %s\n", CrntPID, hostport.buf);
						free_Buffer(&hostport);
					}
				}
			}
			else {
				DEBUG_MODE print_message("[%d] SIP_FORWARDER: recived abnormal data from outside. cc = %d\n", CrntPID, cc);
				break;
			}
		}

		if (Process_List->ldat.id==0) {
			if ((int)(time(NULL)-ntm)>MaxIdleTime) {
				DEBUG_MODE print_message("[%d] SIP_FORWARDER: exit. idling = %d > %d\n", CrntPID, (int)(time(NULL)-ntm), MaxIdleTime);
				break;
			}
		}
		else ntm = time(NULL);
	}

	DEBUG_MODE print_message("[%d] SIP_FORWARDER: exit!!!", CrntPID);

	free_Buffer(&SendPacket_Address);
	del_tList(&Process_List);
	del_tList(&Trans_Table);
	close(vsock);

	return;
}







