/**  
  SIP Forwarder Configure File Tool Program 	

				sip_fwdconfig.c v1,0 by Fumi.Iseki (C)2009-2010
*/



#include "sip_forwarder.h"




//////////////////////////////////////////////////////////////////////////
// Configuration File
//

void  read_config_file(char* fn)
{
	tList* lt;

	lt = read_index_tList_file(fn, ' ');

	if (lt!=NULL) {
		DEBUG_MODE   print_message("[%d] READ_CONFIG_FILE: readed configuration file [%s]\n", CrntPID, fn);

		MinUdpExPort   = get_intparam_tList(lt, "MinUdpExPort",   MinUdpExPort);
		MaxUdpExPort   = get_intparam_tList(lt, "MaxUdpExPort",   MaxUdpExPort);
		MinUdpInPort   = get_intparam_tList(lt, "MinUdpInPort",   MinUdpInPort);
		MaxUdpInPort   = get_intparam_tList(lt, "MaxUdpInPort",   MaxUdpInPort);
		MaxIdleTime	   = get_intparam_tList(lt, "MaxIdleTime",	  MaxIdleTime);

		if (MinUdpExPort>MaxUdpExPort) int_swap(MinUdpExPort, MaxUdpExPort);
		if (MinUdpInPort>MaxUdpInPort) int_swap(MinUdpInPort, MaxUdpInPort);

		Temp_File_Dir	 = get_strparam_tList(lt, "Temp_File_Dir",	  Temp_File_Dir);
		Hosts_Allow_File = get_strparam_tList(lt, "Hosts_Allow_File", Hosts_Allow_File);

		del_all_tList(&lt);
	}
	else {
		DEBUG_MODE print_message("[%d] READ_CONFIG_FILE: cannot read configuration file [%s]\n", CrntPID, fn);
	}

	DEBUG_MODE {
		print_message("[%d] READ_CONFIG_FILE: MinUdpExPort     = %d\n", CrntPID, MinUdpExPort);
		print_message("[%d] READ_CONFIG_FILE: MaxUdpExPort     = %d\n", CrntPID, MaxUdpExPort);
		print_message("[%d] READ_CONFIG_FILE: MinUdpInPort     = %d\n", CrntPID, MinUdpInPort);
		print_message("[%d] READ_CONFIG_FILE: MaxUdpInPort     = %d\n", CrntPID, MaxUdpInPort);
		print_message("[%d] READ_CONFIG_FILE: MaxIdleTime      = %d\n", CrntPID, MaxIdleTime);

		print_message("[%d] READ_CONFIG_FILE: Temp File Dir    = %s\n", CrntPID, Temp_File_Dir);
		print_message("[%d] READ_CONFIG_FILE: Hosts Allow File = %s\n", CrntPID, Hosts_Allow_File);
	}
}







