/*	
	SIP Forwarder Initialize Program 

				sip_fwdinit.c v1.0  by Fumi.Iseki (C)2009-2010
*/


#include "password.h"
#include "sip_forwarder.h"
#include "sip_fwdmain.h"
#include "sip_fwdtools.h"



#define  CONFIG_FILE    	"/usr/local/etc/sip_forwarder/sip_forwarder.conf"
#define  DHKEY_FILE   		"/usr/local/etc/sip_forwarder/dhkey"


int		SysLogLevel 		= LOG_INFO;
//int 	SysLogLevel			= LOG_ERR;
int 	LogMode				= OFF;
int 	UDPDumpMode			= OFF;


// 転送先への接続ポート
int		MinUdpExPort		= 14000;
int		MaxUdpExPort		= 14999;

int		MinUdpInPort		= 15000;
int		MaxUdpInPort		= 15999;


int		MaxIdleTime			= 300;

char*	Temp_File_Dir		= "/var/sip_forwarder/";
char*	Hosts_Allow_File 	= "/usr/local/etc/sip_forwarder/hosts.allow";

char*	LogFileName			= "sip_forwarder.log";
FILE* 	LogFile				= NULL;


char*	MyExtIPaddr			= NULL;
char*	MyExtIPaddrNum		= NULL;
char*	MyIntIPaddr			= NULL;
char*	MyIntIPaddrNum		= NULL;


tList* 	Process_List 		= NULL;
tList* 	Trans_Table 		= NULL;
tList* 	Allow_IPaddr		= NULL;

pid_t	RootPID 			= 0;
pid_t   CrntPID				= 0;





int main(int argc, char** argv)
{
	int	 i;
	int	 lgtyp = -1;
	unsigned short sport = 0;
	struct passwd* pw;

	Buffer servername, domainname, username, conffile, pidfile, extipaddr, intipaddr, logfile;
	Buffer pki, dhkeyfile;

	// 引数処理
	servername = make_Buffer(LNAME);
	domainname = make_Buffer(LNAME);
	username   = make_Buffer(LNAME);
	pidfile	   = make_Buffer(LNAME);
	conffile   = make_Buffer(LNAME);
	extipaddr  = make_Buffer(LNAME);
	intipaddr  = make_Buffer(LNAME);
	logfile    = make_Buffer(LNAME);
	dhkeyfile  = make_Buffer(LNAME); 

	for (i=1; i<argc; i++) {
		if		(!strcmp(argv[i],"-s"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &servername);}
		else if	(!strcmp(argv[i],"-m"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &domainname);}
		else if	(!strcmp(argv[i],"-p"))   {if (i!=argc-1) sport = (unsigned short)atoi(argv[i+1]);}

		else if (!strcmp(argv[i],"-c"))   {if (i!=argc-1) CryptMode = ON;}
		else if (!strcmp(argv[i],"-k"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &dhkeyfile);}

		else if (!strcmp(argv[i],"-u"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &username);}
		else if (!strcmp(argv[i],"-f"))	  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
		else if (!strcmp(argv[i],"-l"))   {if (i!=argc-1 && *(argv[i+1])!='-') copy_s2Buffer(argv[i+1], &logfile); LogMode=ON;}
		else if (!strcmp(argv[i],"-v"))   {if (i!=argc-1) lgtyp = atoi(argv[i+1]);}
		else if (!strcmp(argv[i],"-i"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &intipaddr); MyIntIPaddr=(char*)intipaddr.buf;}
		else if (!strcmp(argv[i],"-ii"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &intipaddr); MyIntIPaddr=(char*)intipaddr.buf;}
		else if (!strcmp(argv[i],"-ie"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &extipaddr); MyExtIPaddr=(char*)extipaddr.buf;}

		else if (!strcmp(argv[i],"-d"))   DebugMode   = ON;
		else if (!strcmp(argv[i],"-x"))   UDPDumpMode = ON;
		else if (!strcmp(argv[i],"-xu"))  UDPDumpMode = ON;

		else if (!strcmp(argv[i],"-pid")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &pidfile); }
	}

	CrntPID = RootPID = getpid();
	if (sport==0) sport = SIP_FRWRDR_PORT;

	// Server
	if (servername.buf[0]!='\0') {
		i = 0;
		while(servername.buf[i]!='\0' && servername.buf[i]!=':') i++;
		if (servername.buf[i]==':') {
			SIPserverPort = (unsigned short)atoi((char*)&(servername.buf[i+1]));
			servername.buf[i] = '\0';
		}
		SIPserverName = (char*)servername.buf;
	}

	if (SIPserverName==NULL || SIPserverPort==0) {
		syslog(SysLogLevel, "sip_fwdinit: ERROR: unknown sip server name or sip server port.");
 		print_message("[%d] SIP_FWDINIT: ERROR: unknown sip server name or sip server port.\n", CrntPID);
 		print_message("[%d] SIP_FWDINIT: ERROR: use -s option. usage... %s -s sip_server_name:sip_server_port\n", CrntPID, argv[0]);
		exit(1);
	}

	if (domainname.buf[0]!='\0') {
		SIPdomainName = (char*)domainname.buf;
	}

	// -i, -ii option
	if (MyIntIPaddr==NULL) {
		MyIntIPaddr = get_localip_bydest("192.168.0.1");
		free_Buffer(&intipaddr);
	}
	MyIntIPaddrNum = (char*)to_address_num4(MyIntIPaddr, 0);
	if (MyIntIPaddrNum==NULL) {
		syslog(SysLogLevel, "sip_fwdinit: ERROR: my internal IP address is incorrect!!!");
		print_message("[%d] SIP_FWDINIT: ERROR: my internal IP address is incorrect!!!\n", CrntPID);
		exit(1);
	}

	// -ie option
	if (MyExtIPaddr==NULL) {
		MyExtIPaddr = get_localip_bydest(SIPserverName);
		free_Buffer(&extipaddr);
	}
	MyExtIPaddrNum = (char*)to_address_num4(MyExtIPaddr, 0);
	if (MyExtIPaddrNum==NULL) {
		syslog(SysLogLevel, "sip_fwdinit: ERROR: my external IP address is incorrect!!!");
		print_message("[%d] SIP_FWDINIT: ERROR: my exterbal IP address is incorrect!!!\n", CrntPID);
		exit(1);
	}

	DEBUG_MODE {
		print_message("[%d] SIP_FWDINIT: My Internal IP  = %s\n", CrntPID, MyIntIPaddr);
		print_message("[%d] SIP_FWDINIT: My External IP  = %s\n", CrntPID, MyExtIPaddr);
		print_message("[%d] SIP_FWDINIT: SIP Server Name = %s\n", CrntPID, SIPserverName);
		if (SIPdomainName!=NULL) print_message("[%d] SIP_FWDINIT: SIP Domain Name = %s\n", CrntPID, SIPdomainName);
	}

	//
	init_rand();
	if (lgtyp>=0) SysLogLevel = lgtyp;

	/////////////////////////////////////////////////////
	// syslog のオープン
	openlog("SIP_Forwarder", LOG_PID, LOG_AUTH);

	// 設定ファイルの読み込み
	if (conffile.buf[0]=='\0') copy_s2Buffer(CONFIG_FILE, &conffile);
	read_config_file((char*)conffile.buf);
	free_Buffer(&conffile);

	// PIDファイルの作成
	if (pidfile.buf[0]!='\0') {
		FILE* fp = fopen((char*)pidfile.buf, "w");
		if (fp!=NULL) {
			fprintf(fp, "%d", (int)RootPID);
			fclose(fp);
		}
	}
	free_Buffer(&pidfile);
	DEBUG_MODE print_message("[%d] SIP_FWDINIT: root PID is [%d]\n", CrntPID);

	// 接続許可・禁止ファイルの読み込み
	Allow_IPaddr = read_ipaddr_file(Hosts_Allow_File);
	if (Allow_IPaddr!=NULL) {
		DEBUG_MODE {
			print_message("[%d] SIP_FWDINIT: readed access control list.\n", RootPID);
  			print_address_in_list(stderr, Allow_IPaddr);
		}
	}
	else {
		DEBUG_MODE print_message("[%d] SIP_FWDINIT: cannot read access contorol list. no access control.\n", CrntPID);
	}

	// for CRYPT
	if (CryptMode==ON) {
		DEBUG_MODE print_message("[%d] SIP_FWDINIT: create DH key.\n", CrntPID);
		if (dhkeyfile.buf[0]=='\0') copy_s2Buffer(DHKEY_FILE, &dhkeyfile);
    	Base64_DHspki = new_Buffer();
    	pki = get_DHspki_ff((char*)dhkeyfile.buf, 1024);
    	*Base64_DHspki = encode_base64_Buffer(pki);
    	free_Buffer(&pki);
    	free_Buffer(&dhkeyfile);
	}

	// 実効ユーザの変更
	if (username.buf[0]!='\0') {
		int uerr = -1;
		int gerr = -1;
   
		DEBUG_MODE print_message("[%d] SIP_FWDINIT: change effective user to [%s]．\n", CrntPID, username.buf);
		if (isdigit(username.buf[0])) {
			gerr = 0;
			uerr = seteuid(atoi((char*)username.buf));
		}
		else {
			pw = getpwnam((char*)username.buf);
			if (pw!=NULL) {
				gerr = setegid(pw->pw_gid);
				uerr = seteuid(pw->pw_uid);
			}
		}
		if (gerr==-1) {
			DEBUG_MODE print_message("[%d] SIP_FWDINIT: WARNING: cannot change effectinve group.\n", CrntPID);
		}
		if (uerr==-1) {
			DEBUG_MODE print_message("[%d] SIP_FWDINIT: WARNING: cannot change effectinve user [%s].\n", CrntPID, username.buf);
		}
	}
	free_Buffer(&username);

	// 作業ディレクトリの書き込みチェック
	char* tempfile = temp_filename(Temp_File_Dir, WORK_FILENAME_LEN);
	if (tempfile!=NULL) {
		FILE* fp = fopen(tempfile, "w");
		if (fp==NULL) {
			syslog(SysLogLevel, "sip_fwdinit: ERROR: sip_forwarder cannot write working directory [%s]. going down!!  please check permission!!", Temp_File_Dir);
			print_message("SIP_FWDINIT: ERROR: sip_forwarder cannot write working directory [%s]. going down!!  please check permission!!\n", Temp_File_Dir);
			sip_fdmain_term(1);
		}
		fclose(fp);
		unlink(tempfile);
		free(tempfile);
	}

	// 前回残った作業用ゴミファイルを削除
	//clean_work_file(Temp_File_Dir, WORK_FILENAME_LEN);

	// ログファイルの書き込みチェック
	if (LogMode) {
		if (logfile.vldsz<=0) {
			copy_s2Buffer(Temp_File_Dir, &logfile);
			cat_s2Buffer (LogFileName, &logfile);
		}
		
		LogFile = fopen((char*)logfile.buf, "a");
		if (LogFile==NULL) {
			DEBUG_MODE print_message("SIP_FWDINIT: WARNING: sip_forwarder cannot write logfile [%s].\n", logfile.buf);
		}
		free_Buffer(&logfile);
	}

	// 確認用Log
	DEBUG_MODE {
		print_message("[%d] SIP_FWDINIT: Connection Port = %d\n", CrntPID, sport);
	}

	sip_forwarder_main(sport);
	sip_fdmain_term(0);

	return 0;
}

