/**  
	SIP Forwarder Protocol Function & Tools

				sip_fwdtools.c v1,0  by Fumi.Iseki (C)2009-2010
*/



#include "sip_fwdmain.h"
#include "sip_fwdtools.h"
#include "sip_forwarder.h"
#include "rtp_forwarder.h"





////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Protocol Function
//

/**

*/
void  sip_cancel_or_bye(char* call_id)
{
	tList* lp = strncmp_tList(Process_List, call_id, 0, 1);

	// 中継プロセスとして起動済み
	if (lp!=NULL && lp->ldat.lv>0) {
		int   ret;
		pid_t pid;

		del_trans_table(Trans_Table, lp->ldat.id);

		ignore_sigterm_child();
		kill((pid_t)lp->ldat.lv, SIGINT);
		do {	
			pid = waitpid(-1, &ret, WNOHANG);
		} while(pid>0);
 		set_sigterm_child(sip_sigterm_child);

		del_tList_node(lp);
		Process_List->ldat.id--;
	}

	// ネゴの最中 
	else {
		lp = strncmp_tList(Trans_Table, call_id, 0, 1);
		if (lp!=NULL) {
			RTP_NetInfo* rtp_info = (RTP_NetInfo*)lp->ldat.ptr;
			if (rtp_info!=NULL) {
				if (lp->ldat.id>0) {		// T socket
					if (rtp_info->td_sock>0) close(rtp_info->td_sock);
					if (rtp_info->tc_sock>0) close(rtp_info->tc_sock);
				}
				if (lp->ldat.lv>0) {		// V socket
					if (rtp_info->vd_sock>0) close(rtp_info->vd_sock);
					if (rtp_info->vc_sock>0) close(rtp_info->vc_sock);
				}
			}
			del_tList_node(lp);
			Trans_Table->ldat.id--;
		}
	}

	return;
}




////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tools
//

/**
struct sockaddr_in  get_addr_forwarding_server(tList* table, char* ipaddr, unsigned short port)

	機能：変換テーブルからクライアント(ipaddr:port)と対になる Forwarderの情報を返す．
		  対になる Forwarderの情報が無い場合，返すデータのメンバは全て 0x00 である． 
*/
struct sockaddr_in  get_addr_forwarding_server(tList* table, char* ipaddr, unsigned short port)
{
	struct sockaddr_in addr;

	memset(&addr, 0, sizeof(struct sockaddr_in));

	while (table!=NULL) {
		if (table->ldat.val.buf!=NULL && !strcmp(ipaddr, (char*)table->ldat.val.buf)) {
			if ((int)port==table->ldat.lv) break;
		}
		table = table->next;
	}

	if (table!=NULL) addr = get_sockaddr((char*)table->ldat.key.buf, (unsigned short)table->ldat.id);
	return addr;
}
			


/**
struct sockaddr_in  get_addr_forwarding_client(tList* table, char* ipaddr, unsigned short port)

	機能：変換テーブルから Forwarder(ipaddr:port)と対になるクライアントの情報を返す．
		  対になるクライアントの情報が無い場合，返すデータのメンバは全て 0x00 である． 
*/
struct sockaddr_in  get_addr_forwarding_client(tList* table, char* ipaddr, unsigned short port)
{
	struct sockaddr_in addr;

	memset(&addr, 0, sizeof(struct sockaddr_in));

	while (table!=NULL) {
		if (table->ldat.key.buf!=NULL && !strcmp(ipaddr, (char*)table->ldat.key.buf)) {
			if ((int)port==table->ldat.id) break;
		}
		table = table->next;
	}

	if (table!=NULL) addr = get_sockaddr((char*)table->ldat.val.buf, (unsigned short)table->ldat.lv);
	return addr;
}



/**
int   del_process_table(tList* pl, int pid)

	機能：プロセスID (pl->ldat.lv)をキーにして，リストから削除
		  対になる Trans_Tableのノードを削除するために，ポート番号を返す．
*/
int   del_process_table(tList* pl, int pid)
{
	int  port = 0;
	tList* pp;

	if (pid<=0)   return 0;
	if (pl==NULL) return 0;

	DEBUG_MODE print_message("[%d] DEL_PROCESS_LIST: called with %d\n", CrntPID, pid);
	pp = pl;
	while (pp!=NULL) {
		if (pp->ldat.lv==pid) {
			port = pp->ldat.id;
			del_tList_node(pp);
			pl->ldat.id--;				// アンカー：項目の数
			break;
		}
		pp = pp->next;
	}

	return port; 
}



/**
void  del_trans_table(tList* pl, int port)

	機能：Forwarderのポート番号(T)をキーにして，変換テーブルからノードを削除．
*/
void  del_trans_table(tList* pl, int port)
{
	tList* pp;

	if (port==0)  return;
	if (pl==NULL) return;

	DEBUG_MODE print_message("[%d] DEL_TRANS_TABLE: called with %d\n", CrntPID, port);
	pp = pl;
	while (pp!=NULL) {
		if (pp->ldat.id==port) {
			del_tList_node(pp);
			pl->ldat.id--;				// 項目の数
			break;
		}
		pp = pp->next;
	}

	return; 
}



/**
void  add_list_or_table(tList* lp, int id, int lv, char* key, char* val)

	テーブル（またはリスト）へデータを登録
*/
tList*  add_list_or_table(tList* lp, int id, int lv, char* key, char* val)
{
	tList* lt = add_tList_node_bystr(lp, id, lv, key, val, NULL, 0);
	if (lt!=NULL) lp->ldat.id++;

	return lt;
}





