
/** 
	Second Life Cache Server: DB I/O

				sl_cache_db_io v1.1.0  by Fumi.Iseki (C) 2008
*/

#include "sl_cache.h"

#include "sl_cache_db_io.h"
#include "sl_cache_file.h"
#include "sl_cache_fdb.h"
#include "sl_cache_sql.h"



char*   CacheTopDir   = NULL;


//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// I/O
//

/**
int  init_cache_db(void)

*/
void  init_cache_db(void)
{
	if (CacheMode==PLN_FILE_CACHE) {
		init_file_cache();
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		init_fdb_cache();
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		init_sql_cache();
	}
	return;
}



/**
void   close_cache_db(void)

*/
void   close_cache_db(void)
{				  
	if (CacheMode==BRKLY_DB_CACHE) {
		close_fdb_cache();
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		close_sql_cache();
	}
	return;
}



/**
void   upatime_cache_db(Buffer buf)

*/
void   upatime_cache_db(Buffer buf)
{
	udp_com dat;

	if (buf.vldsz!=sizeof(udp_com)) return;
	memcpy(&dat, buf.buf, sizeof(udp_com));

	if (CacheMode==BRKLY_DB_CACHE) {
		upatime_fdb_cache(dat);
	}
	return;
}



/**
void 	save_cache_image(Buffer buf)

*/
void 	save_cache_image(Buffer buf)
{
	if (CacheMode==PLN_FILE_CACHE) {
		save_file_cache_image(buf);
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		save_fdb_cache_image(buf);
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		save_sql_cache_image(buf);
	}
	return;
}



/**
void  res_cache_image(int sock,  struct sockaddr_in addr, udp_com dat)

	機能： dat コマンドに従ってキャッシュデータをリレーサーバに送信する（ラッパー）

	引数：
		sock: リレーサーバのキャッシュデータ受信UDPソケット
		addr: キャッシュデータ受信用UDPソケットのソケット情報
		dat : コマンド

*/
void  res_cache_image(int sock,  struct sockaddr_in addr, udp_com dat)
{
	char* guid = (char*)uuid2guid((unsigned char*)dat.mesg);

	if (CacheMode==PLN_FILE_CACHE) {
		res_file_cache_image(sock, addr, guid, ntohs(dat.port));
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		res_fdb_cache_image(sock, addr, guid, ntohs(dat.port));
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		res_sql_cache_image(sock, addr, guid, ntohs(dat.port));
	}

    DEBUG_MODE print_message("[%d] RES_CACHE_IMAGE: sended cache = %s\n", CrntPID, guid);

	free(guid);
	return;
}



/**
udp_com  is_cached_image(udp_com dat)

	引数：
		dat.com[0]  COM_TXTR_CACHE_CHECK
		dat.com[2]	Zero Priority Flag
		dat.mesg   	UUID
		dat.port	Packet No. Big Endian

	戻り値：
		ret.com[0]  COM_TXTR_CACHE_CHECK
		ret.com[1]  COM_OK_REPLY --- キャッシュあり
					COM_NG_REPLY --- キャッシュなし
		ret.port	Packet No. Priority が COM_ZERO_PRIORITY の場合に書き換える（転送済みの次のパケット）．Big Endian
*/
udp_com  is_cached_image(udp_com dat)
{
	udp_com ret;
	int   zeropri_flag;
	char* guid = (char*)uuid2guid((unsigned char*)dat.mesg);

	memset(&ret, 0, sizeof(udp_com));
	zeropri_flag = OFF;
	if (dat.com[2]==COM_ZERO_PRIORITY) zeropri_flag = ON;


	if (CacheMode==PLN_FILE_CACHE) {
		ret = is_file_cached_image(guid, (int)ntohs(dat.port), zeropri_flag);
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		ret = is_fdb_cached_image(guid, (int)ntohs(dat.port), zeropri_flag);
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		ret = is_sql_cached_image(guid, (int)ntohs(dat.port), zeropri_flag);
	}

	free(guid);
	
	//memcpy(ret.pass, dat.pass, AUTH_PASSWD_LEN+1);		// for sequence check
	return ret;
}




//////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Expire Cache Data
//

unsigned int  init_expire_cache(unsigned int tm)
{
	unsigned int intvl = 0;

	if (CacheMode==PLN_FILE_CACHE) {
		intvl = init_file_expire(tm);
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		intvl = init_fdb_expire(tm);
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		intvl = init_sql_expire(tm);
	}
	return intvl;


}



char* rand_cache_db_key(void)
{
	char * key = NULL;

	if (CacheMode==PLN_FILE_CACHE) {
		key = rand_file_cache_key();
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		key = rand_fdb_cache_key();
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		key = rand_sql_cache_key();
	}
	return key;
}



void  lock_cache_db(char* key)
{
	if (CacheMode==PLN_FILE_CACHE) {
		lock_file_cache(key);
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		lock_fdb_cache(key);
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		lock_sql_cache(key);
	}
	return;
}



void unlock_cache_db(char* key)
{
	if (CacheMode==PLN_FILE_CACHE) {
		unlock_file_cache(key);
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		unlock_fdb_cache(key);
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		unlock_sql_cache(key);
	}
	return;
}



void  wait_lock_cache(void)
{
	if (CacheMode==PLN_FILE_CACHE) {
		wait_lock_file_cache();
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		wait_lock_fdb_cache();
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		wait_lock_sql_cache();
	}
	return;
}



void  wait_expire_interval(unsigned int tm)
{
	sleep(tm);
	return;
}



/**
void 	expire_cache_image(char* key, unsigned int tm)

*/
void 	expire_cache_image(char* key, unsigned int tm)
{
	if (CacheMode==PLN_FILE_CACHE) {
		expire_file_cache_image(key, tm);
	}
	else if (CacheMode==BRKLY_DB_CACHE) {
		expire_fdb_cache_image(key, tm);
	}
	else if (CacheMode==MYSQL_DB_CACHE) {
		expire_sql_cache_image(key, tm);
	}
	return;
}




/////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tools
//

/**
Buffer  make_cache_key(char* guid, int pno)

*/
Buffer  make_cache_key(char* guid, int pno)
{
	Buffer key;

	if (pno>=0) {
		key = make_Buffer(48); 			// 46 = 32+4(-)+1(.)+8(4+4)+1(\0)
		snprintf((char*)key.buf, 48, "%s.%d", guid, pno);
		key.vldsz = strlen((char*)key.buf);
	}
	else {
    	key = make_Buffer_bystr(guid);
	}

	return key;
}



