/**
	Second Life Cache Server: DB I/O Header.

				sl_cache_db_io v1.1.0  by Fumi.Iseki (C) 2008
*/


#ifndef  __SL_FILE_CACHE_H_
#define  __SL_FILE_CACHE_H_


#include "buffer.h"

#include "sl_command.h"
#include "sl_cache.h"


#define  CACHE_SUBDIR       	"cache/"
#define  EXPIRE_LOG_FILE		"sl_expire_cache.log"


extern char*	CacheTopDir;

extern int		LogModeExpire;
extern char*	LogFileNameExpire;
extern FILE*	LogFileExpire;



//////////////////////////////////////////////////////////////////////////
// Functions

void  	init_cache_db(void);
void  	close_cache_db(void);
void  	upatime_cache_db(Buffer buf);
void 	save_cache_image(Buffer buf);
void  	res_cache_image(int sock,  struct sockaddr_in addr, udp_com dat);
udp_com is_cached_image(udp_com dat);


// Expire
unsigned int  init_expire_cache(unsigned int tm);
char* 	rand_cache_db_key(void);   
void  	lock_cache_db(char* key);
void 	unlock_cache_db(char* key);
void  	wait_lock_cache(void);
void 	wait_expire_interval(unsigned int tm);
void 	expire_cache_image(char* key, unsigned int tm);


// Tools
Buffer  make_cache_key(char* guid, int pno);


#endif


