/**
	Second Life Cache Server: Berkeley DB Header.

				sl_cache_fdb.h v1.1.0 by Fumi.Iseki (C) 2008
*/


#ifndef  __SL_CACHE_FDB_H_
#define  __SL_CACHE_FDB_H_


#include "buffer.h"
#include "sl_command.h"
#include "sl_tools.h"



#define  DB_FLUSH_NUM  			50

#define  CACHE_LOCK_FDB			"/.cache_lock_fdb"

#define  CACHE_FILE_NAME 		"sl_cache"
#define  CACHE_FILE_NAME_EXT 	".db"
#define  CACHE_INDEX_NAME_EXT	".index"



//////////////////////////////////////////////////////////////////////////
// Functions

void  	init_fdb_cache(void);
void  	close_fdb_cache(void);
void  	upatime_fdb_cache(udp_com dat);
void  	save_fdb_cache_image(Buffer buf);
void  	res_fdb_cache_image(int sock, struct sockaddr_in addr, char* guid, unsigned short no);
udp_com is_fdb_cached_image(char* guid, int no, int zeropri_flag);


// Expire
unsigned int  init_fdb_expire(unsigned int tm);
char* 	rand_fdb_cache_key(void);   
void  	lock_fdb_cache(char* key);
void 	unlock_fdb_cache(char* key);
void  	wait_lock_fdb_cache(void);
void 	expire_fdb_cache_image(char* key, unsigned int tm);


// Tools
Buffer  make_cache_fdbname(char* dir, char* guid);
Buffer  make_lock_fdbname (char* dir, char* guid);

int  	is_cache_fdb_locked(char* dir, char* guid);
void  	upatime_cache_index(char* guid);

int  	check_save_fdb_image(void* dbp, Buffer dbkey, int sz);


#endif


