/**
	Second Life Cache Server: Plain File DB Header.

				sl_cache_file.h v1.1.0  by Fumi.Iseki (C) 2007
*/


#ifndef  __SL_CACHE_FILE_H_
#define  __SL_CACHE_FILE_H_



#include "buffer.h"
#include "sl_command.h"



#define  CACHE_LOCK_FILE    "/.cache_lock_file"



//////////////////////////////////////////////////////////////////////////
// Functions

void  	init_file_cache(void);
void  	save_file_cache_image(Buffer buf);
void  	res_file_cache_image(int sock, struct sockaddr_in addr, char* guid, unsigned short no);
udp_com is_file_cached_image(char* guid, int no, int zeropri_flag);


// Expire
unsigned int  init_file_expire(unsigned int tm);
char* 	rand_file_cache_key(void);   
void  	lock_file_cache(char* key);
void 	unlock_file_cache(char* key);
void  	wait_lock_file_cache(void);
void 	expire_file_cache_image(char* key, unsigned int tm);


// Tools
Buffer  make_cache_filename (char* dir, char* guid, int pno);
Buffer  make_lock_filename  (char* dir, char* guid);
int  	is_cache_file_locked(char* dir, char* guid);

int  	check_save_file_image(Buffer cname, int sz);


#endif


