/** 
	Second Life Cache Server: MySQL.

				sl_cache_sql.c  v0.0  by Fumi.Iseki
*/





#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

#include "sl_cache_sql.h"

#include "sl_relay_cache_io.h"
#include "sl_cache.h"



#ifdef ENABLE_MYSQL


#error ****************************************************************
#error MySQL Function for Texture Cache is not implemented yet!! Sorry.
#error ****************************************************************


#else 

////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Dummy Funtions for I/O
//

void  init_sql_cache(void)
{
	DEBUG_MODE print_message("[%d] INIT_SQL_CACHE_IMAGE: called.\n", CrntPID);
	return;
}



void   close_sql_cache(void)
{
	DEBUG_MODE print_message("[%d] CLOSE_SQL_CACHE_IMAGE: called.\n", CrntPID);
	return;
}



void  save_sql_cache_image(Buffer buf)
{
	DEBUG_MODE print_message("[%d] SAVE_SQL_CACHE_IMAGE: called.\n", CrntPID);
	return;
}



void  res_sql_cache_image(int sock, struct sockaddr_in addr, char* guid, unsigned short no)
{
	DEBUG_MODE print_message("[%d] RES_SQL_CACHE_IMAGE: called with guid = %s\n", CrntPID, guid);
	return;
}



udp_com  is_sql_cached_image(char* guid, int no, int zeropri_flag)
{
	udp_com ret;

	DEBUG_MODE print_message("[%d] IS_SQL_CACHE_IMAGE: called with guid = %s\n", CrntPID, guid);
	memset(&ret, 0, sizeof(udp_com));
	ret.com[0] = COM_TXTR_CACHE_RESULT;
	ret.com[1] = COM_NG_REPLY;	
	ret.port   = htons((unsigned short)no);

	return ret;
}




/////////////////////////////////////////////////////////////////////////////////////////////////////////
// Dummy Functions for Expire
//

unsigned int  init_sql_expire(unsigned int tm)
{
	DEBUG_MODE print_message("[%d] INIT_SQL_EXPIRE: called.\n", CrntPID);
	return 0;
}



char* rand_sql_cache_key(void)
{
	DEBUG_MODE print_message("[%d] RAND_SQL_CACHE_DB_KEY: called.\n", CrntPID);
	return NULL;
}



void  lock_sql_cache(char* key)
{
	DEBUG_MODE print_message("[%d] LOCK_SQL_CACHE_DB: called with key = %s\n", CrntPID, key);
	return;
}



void  unlock_sql_cache(char* key)
{
	DEBUG_MODE print_message("[%d] UNLOCK_SQL_CACHE_DB: called with key = %s\n", CrntPID, key);
	return;
}



void  wait_lock_sql_cache(void)
{
	DEBUG_MODE print_message("[%d] WAIT_LOCK_SQL_CACHE_DB: called.\n", CrntPID);
	//sleep(5);
	return;
}



void  expire_sql_cache_image(char* key, unsigned int tm)
{
	DEBUG_MODE print_message("[%d] EXPIRE_SQL_CACHE_IMAGE: called with key = %s, time = %d\n", CrntPID, key, tm);
	return;
}





#endif


