/**
	Second Life Cache Server: MySQL Header.

				sl_cache_sql.h v0.0  by Fumi.Iseki
*/


#ifndef  __SL_CACHE_SQL_H_
#define  __SL_CACHE_SQL_H_


#include "buffer.h"
#include "sl_command.h"



//////////////////////////////////////////////////////////////////////////
// Functions

void  	init_sql_cache(void);
void  	close_sql_cache(void);
void  	save_sql_cache_image(Buffer buf);
void  	res_sql_cache_image(int sock, struct sockaddr_in addr, char* guid, unsigned short no);
udp_com is_sql_cached_image(char* guid, int no, int zeropri_flag);


// Expire
unsigned int  init_sql_expire(unsigned int tm);
char* 	rand_sql_cache_key(void);   
void  	lock_sql_cache(char* key);
void 	unlock_sql_cache(char* key);
void  	wait_lock_sql_cache(void);
void  	expire_sql_cache_image(char* key, unsigned int tm);




#endif


