/**
	Second Life Cache Server: UDP Texture Cache Header File

				sl_cache.h v1.1.0  by Fumi.Iseki (C) 2007
*/


#ifndef  __SL_CACHE_H_
#define  __SL_CACHE_H_


#include "tools.h"
#include "password.h"
#include "network.h"
#include "ipaddr_tool.h"
#include "https_tool.h"

#include "sl_tools.h"
#include "sl_cache_db_io.h"



#define  SL_CACHE_VERSION  "sl_cache v1.1.0   (C) Fumi.Iseki"


#define  PLN_FILE_CACHE  	1
#define  BRKLY_DB_CACHE  	2
#define  MYSQL_DB_CACHE  	3


#define  CONFIG_FILE  		"/usr/local/etc/sl_proxy/sl_cahe.conf"

#define  MAX_RCACHE_CNT		1000



typedef struct {
	char guid[38];
	unsigned short pkt;
} ack_List;



typedef struct {
	int	 				psock;		// PUT中継プロセスの受信ソケット
	int	 				gsock;		// キャッシュサーバの udp_relayへのテクスチャデータ送信ソケット
	int	 				qsock;		// キャッシュサーバの udp_relayからのリクエスト受信ソケット
	int	 				asock;		// キャッシュサーバの PUT中継プロセスへの COM_TXTR_CACHE_UPATIME用の送信ソケット
	struct sockaddr_in 	raddr;		// PUT中継プロセスの転送データ受信ソケット情報
	struct sockaddr_in 	paddr;		// PUT中継プロセスと通信する udp_relayのソケット情報
	struct sockaddr_in 	gaddr;		// キャッシュサーバからテクスチャを受信する udp_relayのソケット情報
	struct sockaddr_in 	qaddr;		// キャッシュサーバへのリクエストを送信する udp_relayのソケット情報
	struct sockaddr_in 	aaddr;		// キャッシュサーバの COM_TXTR_CACHE_UPATIME用の送信ソケット情報
	char*  				passwd;		// 通信用パスワード（暫定版）
} relay_param;





//////////////////////////////////////////////////////////////////////////

extern int	 DebugMode;

extern int	 Vofd, Wofd;

extern int	 SysLogLevel;

extern FILE* LogFile;
extern int	 LogMode;

extern char* Temp_File_Dir;
extern char* Hosts_Allow_File;

extern int	 CacheMode;
extern int	 ExpireMode;

extern char* MyIPaddr;
extern char* MyIPaddrNum;

extern int	 MinUdpPutPort;
extern int	 MaxUdpPutPort;
extern int	 MinUdpGetPort;
extern int	 MaxUdpGetPort;

extern int	 MaxIdleTime;
extern int	 GetPacketNum;


extern tList* Process_List;
extern tList* Allow_IPaddr;



extern unsigned short 	CacheCPort;
extern unsigned short 	CachePPort;

extern unsigned int		udp_sendCache_Counter;
extern unsigned int	 	all_Request_Counter;
extern unsigned int	 	hit_Request_Counter;



extern tList* ImageData_List;
/*
転送したテクスチャデータのリスト．順序よく送信されていることを前提としている（仮定している）が，
実際に順序良く転送されている保障はない．従って, id, lvは推測値．
厳密には keyは，直前に転送したテクスチャデータの guid．
	ImageData_List->key : テクスチャデータのGUID
	ImageData_List->id  : テクスチャデータのACK受信済みパケットNo.
	ImageData_List->lv  : テクスチャデータの転送済みパケットNo.
	ImageData_List->val.vldsz : テクスチャデータの全パケット数
	id == vldsz なら全データ送信完了
*/

extern ack_List  ACK_List[LST_SZ];
/*
ACKチェック用のリスト
	id				  : キャッシュサーバが送信したデータのシーケンスNo. ACKチェック用．
	ACK_List[id].guid : キャッシュサーバが送信したテクスチャデータの GUID
	ACK_LIst[id].pkt  : そのテクスチャデータのパケット（分割）No.
*/




//////////////////////////////////////////////////////////////////////////
// Functions

// sl_cmain.c
void	sl_cmain_term(int signal);
void  	sl_sigterm_child(int signal);


// sl_cconfig.c
void	read_config_file(char* fn);


// sl_cache.c
void	sl_cache_server(void);
void  	relay_to_put_cache_server(relay_param uparam);

relay_param	 exchange_info_with_udp_relay(void); 



#endif

