/*    
    Second Life Cache Server: Help 

				sl_cache_help.c v1.0  by Fumi.Iseki (C)2009
*/


#include "sl_cache_help.h"



void  sl_cache_help(FILE* fp)
{
    fprintf(fp, "\n");
    fprintf(fp, " sl_cache  ");
    fprintf(fp, "[-p port_no] [-f config_file] [-u user_name] [-i interface_address] \n");
    fprintf(fp, "           [-pid pid_file] [-l [hirate_logfile]] [-v syslog_level] \n");
    fprintf(fp, "           [-xpr  [expire_days]] [-lx [expire_logfile]] \n");
    fprintf(fp, "           [-fdb] [-d] \n");
    fprintf(fp, "           [--version] [--help] [-h]\n");
    fprintf(fp, "\n");

    fprintf(fp, "        -p   : port number that Relay Server(sl_relay) connects. default is 8200. \n");
    fprintf(fp, "        -f   : configuration file. default is /usr/local/etc/sl_proxy/sl_cahe.conf \n");
    fprintf(fp, "        -u   : specify effective user. \n");
    fprintf(fp, "        -i   : specify sl_relay side network interface IP address. \n");
    fprintf(fp, "               if your server has two or more network interfaces, you need to use this option. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -pid : specify pid file.\n");
    fprintf(fp, "        -l   : create hit rate log file. default file name is /var/sl_proxy/sl_cache_hitrate.log \n");
    fprintf(fp, "        -v   : level of syslog. default is LOG_INFO (7).\n");
    fprintf(fp, "\n");

    fprintf(fp, "        -xpr : execute the cache expire daemon. The expire time can be continuously specified by day unit. default is the 30days.\n"); 
    fprintf(fp, "               the expire demon retrieves at random and deletes data without the access during the specified days. \n");
    fprintf(fp, "        -lx  : create cache expire log file. default file name is /var/sl_proxy/sl_expire_cache.log \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -fdb : Berkeley DB is used for the data base. default is plane file. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -d   : debug mode. display debug information. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        --version  : display Version information. \n");
    fprintf(fp, "        --help, -h : display this Help messages. \n");
    fprintf(fp, "\n");

	return;
}

