/**  
  Second Life Cache Server: Texture Cache Config Tools Program.	

				sl_cconfig.c v1.0  by Fumi.Iseki (C) 2007
*/



#include "sl_cache.h"




//////////////////////////////////////////////////////////////////////////
// Configuration File
//

void  read_config_file(char* fn)
{
	tList* lt;

	lt = read_index_tList_file(fn, ' ');

	if (lt!=NULL) {
		DEBUG_MODE print_message("[%d] READ_CCONFIG_FILE: readed cache configuration file [%s]\n", CrntPID, fn);

		MinUdpPutPort     = get_intparam_tList(lt, "MinUdpPutPort",		MinUdpPutPort);
		MaxUdpPutPort     = get_intparam_tList(lt, "MaxUdpPutPort",		MaxUdpPutPort);
		MinUdpGetPort     = get_intparam_tList(lt, "MinUdpGetPort",		MinUdpGetPort);
		MaxUdpGetPort     = get_intparam_tList(lt, "MaxUdpGetPort",		MaxUdpGetPort);
		MaxIdleTime       = get_intparam_tList(lt, "MaxIdleTime",		MaxIdleTime);
		//MaxRequestRate    = get_intparam_tList(lt, "MaxRequestRate",	MaxRequestRate);
		GetPacketNum      = get_intparam_tList(lt, "GetPacketNum", 		GetPacketNum);
		Temp_File_Dir     = get_strparam_tList(lt, "Temp_File_Dir",		Temp_File_Dir);
		Hosts_Allow_File  = get_strparam_tList(lt, "Hosts_Allow_File",	Hosts_Allow_File);

		del_all_tList(&lt);
	}
	else {
		DEBUG_MODE print_message("[%d] READ_CCONFIG_FILE: cannot read cache configuration file [%s]\n", CrntPID, fn);
	}

	DEBUG_MODE {
		print_message("[%d] READ_CCONFIG_FILE: MinUdpPutPort    = %d\n", CrntPID, MinUdpPutPort);
		print_message("[%d] READ_CCONFIG_FILE: MaxUdpPutPort    = %d\n", CrntPID, MaxUdpPutPort);
		print_message("[%d] READ_CCONFIG_FILE: MinUdpGetPort    = %d\n", CrntPID, MinUdpGetPort);
		print_message("[%d] READ_CCONFIG_FILE: MaxUdpGetPort    = %d\n", CrntPID, MaxUdpGetPort);
		print_message("[%d] READ_CCONFIG_FILE: MaxIdleTime      = %d\n", CrntPID, MaxIdleTime);
		//print_message("[%d] READ_CCONFIG_FILE: MaxRequestRate   = %d\n", CrntPID, MaxRequestRate);
		print_message("[%d] READ_CCONFIG_FILE: GetPacketNum     = %d\n", CrntPID, GetPacketNum);
		print_message("[%d] READ_CCONFIG_FILE: Hosts_Allow_File = %s\n", CrntPID, Hosts_Allow_File);
		print_message("[%d] READ_CCONFIG_FILE: Temp_File_Dir    = %s\n", CrntPID, Temp_File_Dir);
	}
}



