/*  
	Second Life Cache Server: Main Program 	

									sl_cmain.c v1.1.0  by Fumi.Iseki (C) 2007
*/



#include "sl_tools.h"
#include "sl_cache_help.h"
#include "sl_cache.h"
#include "sl_put_cache.h"
#include "sl_expire_cache.h"
#include "sl_relay_cache_io.h"



int   	Vofd				= 0;
int   	Wofd				= 0;

char* 	Temp_File_Dir	   	= "/var/sl_proxy/";
char* 	Hosts_Allow_File 	= "/usr/local/etc/sl_proxy/hosts_cache.allow";

int   	SysLogLevel 		= LOG_INFO;
int   	LogMode   			= OFF;
char* 	LogFileName 	   	= "sl_cache_hitrate.log";
FILE* 	LogFile			 	= NULL;

int   	LogModeExpire 		= OFF;
char* 	LogFileNameExpire  	= "sl_expire_cache.log";
FILE* 	LogFileExpire	 	= NULL;

int   	CacheMode 			= PLN_FILE_CACHE;
int 	ExpireMode			= OFF;

char* 	MyIPaddr		 	= NULL;
char* 	MyIPaddrNum	 		= NULL;

int   	MinUdpPutPort  		= 10000;
int   	MaxUdpPutPort  		= 10999;
int   	MinUdpGetPort  		= 11000;
int   	MaxUdpGetPort  		= 11999;

int   	MaxIdleTime			= 300;
int   	GetPacketNum   		= 10;
//int	MaxRequestRate 		= 100;


tList* 	Process_List  		= NULL;
tList* 	Allow_IPaddr   		= NULL;


pid_t  	RootPID				= 0;		// メインプロセスの PID

unsigned short CacheCPort	= 0;		// キャッシュサーバのコントロールポート(TCP)
unsigned short CachePPort	= 0;		// キャッシュ用データの受信ポート(UDP)








int main(int argc, char** argv)
{
	int	   i, lgtyp=-1;
	unsigned int expire = 0;
	char*  tempfile;
	pid_t  pid;

	unsigned short  cport=0;
	int	   cdlen;
	struct sockaddr_in px_addr;
	struct passwd* pw;
	struct sigaction sa;

	Buffer username, conffile, pidfile, logfile, elogfile, myipaddr;


	// 引数処理
	username = make_Buffer(LNAME);
	conffile = make_Buffer(LNAME);
	pidfile	 = make_Buffer(LNAME);
	myipaddr = make_Buffer(LNAME);
	logfile  = make_Buffer(LNAME);
	elogfile = make_Buffer(LNAME);

	for (i=1; i<argc; i++) {
		if		(!strcmp(argv[i],"-p"))   {if (i!=argc-1) cport = (unsigned short)atoi(argv[i+1]);}
		else if (!strcmp(argv[i],"-f"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
		else if (!strcmp(argv[i],"-u"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &username);}
		else if (!strcmp(argv[i],"-i"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &myipaddr); MyIPaddr = (char*)myipaddr.buf;}

		else if (!strcmp(argv[i],"-pid")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &pidfile);}
		else if (!strcmp(argv[i],"-l"))   {if (i!=argc-1 && *(argv[i+1])!='-') copy_s2Buffer(argv[i+1], &logfile);  LogMode=ON;}
		else if (!strcmp(argv[i],"-v"))   {if (i!=argc-1) lgtyp = atoi(argv[i+1]);}

		else if (!strcmp(argv[i],"-xpr")) {if (i!=argc-1 && *(argv[i+1])!='-') expire=atoi(argv[i+1]);else expire=DEFAULT_CACHE_EXPIRE; ExpireMode=ON;}
		else if (!strcmp(argv[i],"-lx"))  {if (i!=argc-1 && *(argv[i+1])!='-') copy_s2Buffer(argv[i+1], &elogfile); LogModeExpire=ON;}

		else if (!strcmp(argv[i],"-fdb")) CacheMode = BRKLY_DB_CACHE;
		else if (!strcmp(argv[i],"-sql")) CacheMode = MYSQL_DB_CACHE;

		else if (!strcmp(argv[i],"-d"))   DebugMode = ON;

		else if (!strcmp(argv[i],"--version")) { fprintf(stdout, SL_CACHE_VERSION); fprintf(stdout, "\n"); exit(0); }
		else if (!strcmp(argv[i],"--help")) {sl_cache_help(stdout); exit(0);}
		else if (!strcmp(argv[i],"-h"))     {sl_cache_help(stdout); exit(0);}

		// old option
		else if (!strcmp(argv[i],"-c"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
	}


	CrntPID = RootPID = getpid();

#ifndef ENABLE_BERKELEYDB
	if (CacheMode==BRKLY_DB_CACHE) {
		print_message("[%d] SL_CMAIN: ERROR: Berkelery DB Function is not linked!!!\n", CrntPID);
		exit(1);
	}
#endif

#ifndef ENABLE_MYSQL
	if (CacheMode==MYSQL_DB_CACHE) {
		print_message("[%d] SL_CMAIN: ERROR: MySQL Function is not linked!!!\n", CrntPID);
		exit(1);
	}
#endif

	if (cport==0) cport = CACHE_CPORT;
	CacheCPort = cport;
	CachePPort = cport + 1;

	if (lgtyp>=0) SysLogLevel = lgtyp;

	// -i option
	if (MyIPaddr==NULL) {
		MyIPaddr = get_localip_bydest("192.168.0.1");
		free_Buffer(&myipaddr);
	}   
	MyIPaddrNum = (char*)to_address_num4(MyIPaddr, 0);
	if (MyIPaddrNum==NULL) {
		print_message("[%d] SL_CMAIN: ERROR: my IP address is incorrect!!!\n", CrntPID);
		exit(1);
	}

	// -xpr option
	if (ExpireMode==ON) {
		if (expire<=0) expire = DEFAULT_CACHE_EXPIRE;
		expire = expire*86400;							// * 1day (sec)
	}
	else {
		LogModeExpire = OFF;
	}


	init_rand();


///////////////////////////////////////////////////////////////////////////
	// syslog のオープン
	openlog("SecondLife_Cache", LOG_PID, LOG_AUTH);


	// 設定ファイルの読み込み
	if (conffile.buf[0]=='\0') copy_s2Buffer(CONFIG_FILE, &conffile);
	read_config_file((char*)conffile.buf);
	free_Buffer(&conffile);


	// 接続許可・禁止ファイルの読み込み
	Allow_IPaddr = read_ipaddr_file(Hosts_Allow_File);
	if (Allow_IPaddr!=NULL) {
		//syslog(SysLogLevel, "sl_cmain: readed access allow list for relay server.");
		DEBUG_MODE {
			print_message("[%d] SL_CMAIN: readed access control list for relay server.\n", CrntPID);
		  	print_address_in_list(stderr, Allow_IPaddr);
		}
	}
	else {
		syslog(SysLogLevel, "sl_cmain: cannot read access contorol list for relay server. no access control.");
		DEBUG_MODE print_message("[%d] SL_CMAIN: cannot read access contorol list for relay server. no access control.\n", CrntPID);
	}


	// PIDファイルの作成
	if (pidfile.buf[0]!='\0') {
		FILE* fp = fopen((char*)pidfile.buf, "w");
		if (fp!=NULL) {
			fprintf(fp, "%d", (int)RootPID);
			fclose(fp);
		}
	}
	free_Buffer(&pidfile);


	// 実効ユーザの変更
	if (username.buf[0]!='\0') {
		int uerr = -1;
		int gerr = -1;
   
		DEBUG_MODE print_message("[%d] SL_CMAIN: change effective user to [%s]．\n", CrntPID, username.buf);
		if (isdigit(username.buf[0]) || username.buf[0]=='-') {
			gerr = 0;
			uerr = seteuid(atoi((char*)username.buf));
		}
		else {
			pw = getpwnam((char*)username.buf);
			if (pw!=NULL) {
				gerr = setegid(pw->pw_gid);
				uerr = seteuid(pw->pw_uid);
			}
		}
		if (gerr==-1) {
			syslog(SysLogLevel, "sl_cmain: WARNING: cannot change effective group: [%s]", strerror(errno));
			DEBUG_MODE print_message("[%d] SL_CMAIN: cannot change effectinve group.\n", CrntPID);
		}
		if (uerr==-1) {
			syslog(SysLogLevel, "sl_cmain: WARNING: cannot change effective user (%s): [%s]", username.buf, strerror(errno));
			DEBUG_MODE print_message("[%d] SL_CMAIN: cannot change effectinve user [%s].\n", CrntPID, username.buf);
		}
	}
	free_Buffer(&username);


	// シグナルハンドリング
	sa.sa_handler = sl_cmain_term;
	sa.sa_flags   = 0;
	sigemptyset(&sa.sa_mask);
	sigaddset(&sa.sa_mask,  SIGCHLD);
	sigaction(SIGINT,  &sa, NULL);
	sigaction(SIGHUP,  &sa, NULL);
	sigaction(SIGTERM, &sa, NULL);

	set_sigterm_child(sl_sigterm_child);		// Childプロセス終了時の処理設定
	DEBUG_MODE set_sigseg_handler(NULL);


	// 作業ディレクトリの書き込みチェック
	tempfile = temp_filename(Temp_File_Dir, WORK_FILENAME_LEN);
	if (tempfile!=NULL) {
		FILE* fp = fopen(tempfile, "w");
		if (fp==NULL) {
			syslog(SysLogLevel, "sl_cmain: ERROR: sl_cache cannot write working directory [%s]. going down!!  please check permission!!", Temp_File_Dir);
			print_message("[%d] SL_CMAIN: ERROR: sl_cache cannot write working directory [%s].\n", CrntPID, Temp_File_Dir);
			print_message("[%d] SL_CMAIN: ERROR: going down!!  please check directory permission!!\n", CrntPID);
			sl_cmain_term(1);
		}
		fclose(fp);
		unlink(tempfile);
		free(tempfile);
	}


	// ログファイルの書き込みチェック
	if (LogMode) {
		if (logfile.vldsz<=0) {
			copy_s2Buffer(Temp_File_Dir, &logfile);
			cat_s2Buffer (LogFileName,   &logfile);
		}

		LogFile = fopen((char*)logfile.buf, "a");
		if (LogFile==NULL) {
			DEBUG_MODE print_message("[%d] SL_CMAIN: WARNING: sl_cache cannot write hitrate logfile [%s].\n", CrntPID, logfile.buf);
		}
		free_Buffer(&logfile);
	}

	if (LogModeExpire) {
		if (elogfile.vldsz<=0) {
			copy_s2Buffer(Temp_File_Dir,     &elogfile);
			cat_s2Buffer (LogFileNameExpire, &elogfile);
		}

		LogFileExpire = fopen((char*)elogfile.buf, "a");
		if (LogFileExpire==NULL) {
			LogModeExpire = OFF;
			DEBUG_MODE print_message("[%d] SL_CMAIN: WARNING: sl_cache cannot write expire logfile [%s].\n", CrntPID, elogfile.buf);
		}
		free_Buffer(&elogfile);
	}


	// データベースの初期化
	init_cache_db();


////////////////////////////////////////////////////////////////////////////////////
// PUT集約プロセスの起動
//
	Process_List = add_tList_node_int(NULL, 0, 0);		// アンカー

	pid = fork();
	if (pid==0) {
		CrntPID = getpid();
		put_cache_server(CachePPort);
		exit(0);
	}
	add_tList_node_int(Process_List, 0, (int)pid);



////////////////////////////////////////////////////////////////////////////////////
// Expire Daemon の起動
// 
	if (ExpireMode) {
		pid = fork();
		if (pid==0) {
			CrntPID = getpid();
			sl_expire_cache_daemon(expire);
			exit(0);
		}
	}
	add_tList_node_int(Process_List, 0, (int)pid);



////////////////////////////////////////////////////////////////////////////////////
//
//
	syslog(SysLogLevel, "sl_cmain: start main loop for TCP connection. port = %d", CacheCPort);
	DEBUG_MODE print_message("[%d] SL_CMAIN: start main loop for TCP connection. port = %d\n", CrntPID, CacheCPort);

	// メインループ
	Vofd = tcp_server_socket((int)CacheCPort);
	Loop {
		cdlen = sizeof(px_addr);
		Wofd = accept_intr(Vofd, (struct sockaddr*)&px_addr, (socklen_t*)&cdlen);
		if (Wofd<0) {
			syslog(SysLogLevel, "sl_cmain: ERROR: accept() error [%s]", strerror(errno));
			print_message("[%d] SL_CMAIN: ERROR: accept() error [%s].\n", CrntPID, strerror(errno));
			sl_cmain_term(1);
		}

		char* ipaddr	= get_ipaddr(px_addr.sin_addr);
		char* ipaddrnum = (char*)to_address_num4(ipaddr, 0);

		// check IP
		if (Allow_IPaddr!=NULL && !is_host_in_list(Allow_IPaddr, (unsigned char*)ipaddrnum, NULL)) {
			syslog(SysLogLevel, "sl_cmain: WARNING: not allowed access from [%s]", ipaddr);
			DEBUG_MODE print_message("[%d] SL_CMAIN: WARNING: not allowed access from [%s]\n", CrntPID, ipaddr);

			freeNull(ipaddr);
			freeNull(ipaddrnum);
			close(Wofd);
			Wofd = 0;
			continue;
		}

		pid = fork();
		if (pid==0) {
			CrntPID = getpid();
			sl_cache_server();
			sl_cmain_term(0);
		}
		add_tList_node_int(Process_List, 0, (int)pid);

		freeNull(ipaddr);
		freeNull(ipaddrnum);
		close(Wofd);
		Wofd = 0;
	}

	// not reachable
	close(Vofd);
	Vofd = 0;
	sl_cmain_term(0);
}







//////////////////////////////////////////////////////////////////////////
// プログラムの終了
//

/**
void  sl_cmain_term(int sig)

	機能：起動した子プロセスを全て終了させて，自分も終了する．

	引数：sig: 受信したシグナル（この関数を呼び出したシグナル）
			   特に使用はしない．
*/
void  sl_cmain_term(int sig)
{ 
	int	   ret;
	pid_t  pid;
	tList* lp;


	if (Wofd>0) socket_close(Wofd);

	// Main Process
	if (RootPID==getpid()) {
		syslog(SysLogLevel, "sl_cmain_term: main program is going die!!");
		DEBUG_MODE print_message("[%d] SL_CMAIN_TERM: main program is going die!!\n", CrntPID);
		if (LogMode) {
			fflush(LogFile);
			fclose(LogFile);
			LogFile = NULL;
		}
		if (LogModeExpire) {
			fflush(LogFileExpire);
			fclose(LogFileExpire);
			LogFileExpire = NULL;
		}

		closelog();						// close syslog
		if (Vofd>0) socket_close(Vofd);
	}

	close_cache_db();

	signal(SIGCHLD, SIG_IGN);

	if (Process_List!=NULL) {
		lp = Process_List->next;
		while(lp!=NULL) {
			if (lp->ldat.lv>1) kill((pid_t)lp->ldat.lv, SIGINT);
			lp = lp->next;
		}
		if (Process_List->next!=NULL) {
			do {		  		// チャイルドプロセスの終了を待つ   
				pid = waitpid(-1, &ret, WNOHANG);
			} while(pid>0);
		}

		del_all_tList(&Process_List);
	}

	exit(sig);
}





/**			
void  sl_sigterm_child(int signal)
				  
	機能：child プロセス終了時の処理
 
*/
void  sl_sigterm_child(int signal)
{
	pid_t pid = 0;
	int ret;

	DEBUG_MODE print_message("[%d] SL_SIGTERM_CHILD: called. signal = %d\n", (int)getpid(), signal);

	do {	// チャイルドプロセスの終了を待つ
		pid = waitpid(-1, &ret, WNOHANG);
		if (pid>0) del_process_list(Process_List, (int)pid, NULL);
	} while(pid>0);
}




