/**
	Second Life Relay Server: UDP Control Command Header File

				sl_command.h v1.5  by Fumi.Iseki (C)2007
*/


#ifndef  __SL_COMMAND_H_
#define  __SL_COMMAND_H_


#include "network.h"
#include "tlist.h"



extern unsigned int  RequestSeqNum;





// Control Commands

#define  COM_MESG_LEN 				128	
#define  COM_PASS_LEN 				24		// need  COM_PASS_LEN > AUTH_PASSWD_LEN+1 (in sl_tools.h)


typedef struct {
	unsigned char  	com[4];
	unsigned char 	addr[4];
	unsigned int	seqnum;
	unsigned short 	port;					// Big Endian
	unsigned short 	prtcl;					// Big Endian
	char  			mesg[COM_MESG_LEN];		// 128 octet
	char			uid [LSNAME];			// 32 octet
	char  			pass[COM_PASS_LEN];		
} udp_com, tcp_com;			// 200 octet




// com[0] に設定
#define  COM_ACK_PACKET				0x01
#define  COM_ALIVE_REQUEST	 	  	0x02
#define  COM_PING_REQUEST	 	  	0x03
#define  COM_PING_REPLY	 			0x04

#define  COM_ERROR_TIMEOUT			0x10
#define  COM_ERROR_RECV				0x11
#define  COM_SESSN_CLOSED			0x12

// for Relay Controller
#define  COM_IP_PORT_REQUEST 	  	0x20
#define  COM_IP_PORT_REPLY	 		0x21
#define  COM_IP_PORT_REPORT 	  	0x22
#define  COM_FQDN_PORT_REQUEST		0x24
#define  COM_FQDN_PORT_REPLY		0x25
#define  COM_PAIR_UDP_REQUEST 	  	0x2a
#define  COM_PAIR_UDP_REPLY	 		0x2b

#define  COM_IP_PORT_DEL_REQUEST   	0x30
#define  COM_IP_PORT_DEL_REPLY	 	0x31
#define  COM_FQDN_PORT_DEL_REQUEST	0x32
#define  COM_FQDN_PORT_DEL_REPLY	0x33
#define  COM_CORRECT_VWIP_REQUEST	0x34
#define  COM_TERM_PROCESS_REQUEST	0x35
#define  COM_RESET_PROCESS_REQUEST	0x36
#define  COM_PAIR_TCP_KILL_REQUEST	0x37

// for 情報サーバ
#define  COM_INFO_LOGIN_NOTIFY 		0x40
#define  COM_INFO_CRRCTIP_NOTIFY 	0x41

#define  COM_INFO_GATHER_START		0x50	// Start Range
#define  COM_INFO_SET_AGENT			0x51	// HTTPS (login_relay)
#define  COM_INFO_UPD_AGENT			0x52	// HTTPS (https_relay)
#define  COM_INFO_DEL_AGENT			0x53	// UDP 	 (udp_relay)
#define  COM_INFO_SET_SIM			0x58    // 
#define  COM_INFO_GATHER_END		0x5f	// End Range

#define  COM_INFO_TENDER_START		0x60
#define  COM_INFO_GET_NAME_BYHNDL	0x61
#define  COM_INFO_GET_NAME_REPLY	0x62
#define  COM_INFO_GET_WHITE_BYNAME	0x66
#define  COM_INFO_GET_WHITE_BYHNDL	0x67
#define  COM_INFO_GET_WHITE_REPLY	0x6a
#define  COM_INFO_TENDER_END		0x6f

// for キャッシュサーバ
#define  COM_TXTR_CACHE_REQUEST		0x80
#define  COM_TXTR_CACHE_CHECK		0x82
#define  COM_TXTR_CACHE_RESULT		0x83
#define  COM_TXTR_CACHE_NOCHECK		0x84
#define  COM_TXTR_CACHE_UPATIME		0x8f	// for expire. <-->SIMで存在しないパケット種別を指定しないといけない

// for Voice Relay サーバ
#define  COM_VOICE_GET_ACCNT_SVR	0x90
#define  COM_VOICE_GET_SIP_SVR		0x91
#define  COM_VOICE_SET_ACCNT_SVR	0x93
#define  COM_VOICE_SET_SIP_SVR		0x94


// com[1] に設定  REPLY
#define  COM_ERROR_REPLY			0x00
#define  COM_OK_REPLY				0x01
#define  COM_NG_REPLY				0x02
#define  COM_UNKNOWN_REPLY			0x03
#define  COM_FORBIDDEN_REPLY		0x04
#define  COM_ERROR_SEQUENCE			0x05
#define  COM_ERROR_PASSWD			0x06


// com[2] に設定 パラメータ
#define  COM_ZERO_PRIORITY			0x01
#define	 COM_HAS_REGION_HANDLE		0x02


// 中継プロセスの起動モード
#define  COM_DEFAULT_MODE  			0x00
#define  COM_HTTP_MODE	   			0x01
#define  COM_HTTPS_MODE	   			0x02
//#define  COM_FORK_MODE	   		0x04
#define  COM_STREAM_MODE	   		0x08
#define  COM_LOGIN_MODE	 	  		0x10
#define  COM_BAKED_MODE				0x20
/*
COM_DEFAULT_MODE	その時のデフォルト．つまり何も特別なことは行わない
COM_HTTP_MODE	  	サーバとの通信に HTTP を使用する．デフォルトは UseClientSSLに指定した内容
COM_HTTPS_MODE	  	サーバとの通信で HTTPS を優先的に使用する. デフォルトは UseClientSSLに指定した内容
COM_FORK_MODE	   	サーバとの通信でチャイルドプロセスを fork する．デフォルトは forkする．
					'10 6/19 v1.9以降は常にforkする仕様に変更．
COM_STREAM_MODE	 	ストリームデータを取り扱う場合に指定
COM_LOGIN_MODE		ログインプロセスであるとこを示す．login_relay()で使用 -> 使用取りやめ
COM_BAKED_MODE		Baked Texture用

COM_FORK_MODE, COM_STREAM_MODE は現在のところ MediaURL, MusicURLの処理のみに使用
	COM_FORK_MODE  		ストリームデータ転送専用に子プロセスを起動するため
						'10 6/19 v1.9以降は常にforkする仕様に変更．
	COM_STREAM_MODE		ストリームデータを受信したデータから順次転送させるため（通常は全てのデータを受信してから転送）
*/





//////////////////////////////////////////////////////////////////////////
// Functions

udp_com  recv_udp_command(int sock, struct sockaddr_in* addr, int stm, int utm);
tcp_com  recv_tcp_command(int sock, int stm, int utm);

unsigned short  udp_command_check_ipport(int sock, struct sockaddr_in addr, int prtcl, unsigned char* buf, int pos, int hpos, 
																											unsigned char mode, char* passwd);
unsigned short  udp_command_check_fqdn  (int sock, struct sockaddr_in addr, int prtcl, char* hname, unsigned short port, char* handle,
																											unsigned char mode, char* passwd);

void  udp_command_req_pair_udp(int sock, struct sockaddr_in addr, char* hname, unsigned short* vport, unsigned short* sport, char* passwd);
void  udp_command_res_pair_udp(int sock, struct sockaddr_in addr, udp_com dat, tList* iplist, char* passwd);

void  udp_command_del_ipport(int sock, struct sockaddr_in addr, struct sockaddr_in ss_addr, char* passwd);
void  udp_command_del_fqdn  (int sock, struct sockaddr_in addr, char* hname, unsigned short hport, char* passwd);

void  udp_command_keep_alive(int sock, struct sockaddr_in addr);
void  udp_command_reset	 	(int sock, struct sockaddr_in addr, char* passwd);
void  udp_command_terminate (int sock, struct sockaddr_in addr, char* passwd);
void  udp_command_correct_ip(int sock, struct sockaddr_in addr, char* ipa, char* passwd);


void  udp_command_kill_pair_tcp(int sock, struct sockaddr_in addr, char* ipnum, char* passwd);


#endif
