/** 
	Second Life Expire Cache Daemon Program

				sl_expire_cache.c v1.0  by Fumi.Iseki (C) 2009
*/



#include "sl_expire_cache.h"
#include "sl_cache.h"



char*  ExpireLockKey 	= NULL;




/////////////////////////////////////////////////////////////////////////////////
/**
	機能：

	引数：
*/
void  sl_expire_cache_daemon(unsigned int xprtm)
{
	struct sigaction sa;

	init_rand();
	CrntPID = getpid();

	DEBUG_MODE print_message("[%d] SL_EXPIRE_CACHE_DAEMON: start.\n", CrntPID);

	// シグナルハンドリング
	sa.sa_handler = sl_expire_cache_term;
	sa.sa_flags   = 0;      
	sigemptyset(&sa.sa_mask); 
	sigaction(SIGINT,  &sa, NULL);
	sigaction(SIGHUP,  &sa, NULL);
	sigaction(SIGTERM, &sa, NULL);

	unsigned int intvl = init_expire_cache(xprtm);
	Loop {
		sl_expire_cache(xprtm);
		wait_expire_interval(intvl);
	}

	return;
}



void  sl_expire_cache(unsigned int xprtm)
{
	ExpireLockKey = rand_cache_db_key();
	lock_cache_db(ExpireLockKey);
	wait_lock_cache();

	expire_cache_image(ExpireLockKey, xprtm);		
	unlock_cache_db(ExpireLockKey);
	freeNull(ExpireLockKey);

	return;
}



void  sl_expire_cache_term(int sig)
{
	DEBUG_MODE print_message("[%d] SL_EXPIRE_CACHE_TERM: called with signal = %d\n", CrntPID, sig);

	if (ExpireLockKey!=NULL) {
		unlock_cache_db(ExpireLockKey);
		freeNull(ExpireLockKey);
	}
	close_cache_db();

	exit(1);
}


