/** 
	Second Life Put Cache Server: UDP Texture Put Cache Program

				sl_put_cache.c v1.1.0  by Fumi.Iseki (C) 2007
*/



#include "sl_put_cache.h"
#include "sl_cache.h"



int			CacheSaveCnter;
time_t		CacheSaveTimer; 




/////////////////////////////////////////////////////////////////////////////////
/**
void  put_cache_server(unsigned short port)

	機能：127.0.0.1(localhost) からの High 9, 10 のデータをキャッシュとしてファイルに保存する．
		  セキュリティ上の理由から 127.0.0.1 からのリクエストしか受け付けない．

		  追加：Berkeley DB用にデータのアクセスタイム保存のための機能を追加 '09 2/28

	引数：port --  データを受信するポート番号
*/
void  put_cache_server(unsigned short port)
{
	int	   nd, sofd, cc;
	struct sockaddr_in addr;
	Buffer buf;
	char*  ipaddr;

	fd_set mask;
	struct timeval timeout;

	init_rand();

	buf  = make_Buffer(LFRAME);
	sofd = udp_server_socket((int)port);	
	if (sofd<=0) {
		//syslog(SysLogLevel, "put_cache_server: ERROR: put cache socket open error!!. port = %d", port);
		print_message("[%d] PUT_CACHE_SERVER: ERROR: Put Cache socket open error!!. port = %d\n", CrntPID, port);
		exit(1);
	}

	DEBUG_MODE {
		print_message("[%d] PUT_CACHE_SERVER: Start Put Cache Server. Port = %d\n", CrntPID, port);
		CacheSaveCnter = 0;
		CacheSaveTimer = time(NULL); 
	}

	Loop {
		do {
			timeout.tv_sec  = TIME_OUT;
			timeout.tv_usec = 0;
			FD_ZERO(&mask); 
			FD_SET(sofd, &mask);
			nd = select(sofd+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);

		if (FD_ISSET(sofd, &mask)) {
			cc = udp_recv_Buffer(sofd, &buf, &addr);
			if (cc>0) {
				ipaddr = get_ipaddr(addr.sin_addr); 
				if (!strcmp(ipaddr, "127.0.0.1")) {
					if (buf.buf[0]==COM_TXTR_CACHE_UPATIME && buf.vldsz==sizeof(udp_com)) {
						//DEBUG_MODE print_message("[%d] PUT_CACHE_SERVER: received upatime command.\n", CrntPID);
						upatime_cache_db(buf);
					}
					else {
						save_cache_image(buf);
					}
					// Saving Rate
					DEBUG_MODE {
						CacheSaveCnter++;
						if (CacheSaveCnter>=MAX_SCACHE_CNT) {
							float save_rate = (float)(time(NULL)-CacheSaveTimer)/MAX_SCACHE_CNT;
							CacheSaveCnter = 0;
							CacheSaveTimer = time(NULL);
 							print_message("[%d] PUT_CACHE_SERVER: rate of saving image cache = %f(sec)/packet\n", CrntPID, save_rate);
						}
					}
				}
				else {
 					DEBUG_MODE print_message("[%d] PUT_CACHE_SERVER: WARNING: not allowed access from [%s]\n", CrntPID, ipaddr);
				}
				freeNull(ipaddr);
			}
		}
	}
	
	free_Buffer(&buf);
}



