/**  
	Second Life Infomation Server: SL Infomation Server DB I/O

				sl_info_dbio.c v1.0 by Fumi.Iseki (C)2008
*/



#include "sl_info_db_io.h"

#include "sl_info_file.h"
#include "sl_info_fdb.h"
#include "sl_info_sql.h"



char*	DBFileDir	= NULL;



///////////////////////////////////////////////////////////////////////////////////////////////
//
// データベース依存
//

void   init_sim_db()
{
	if (DBMode==PLN_FILE_INFO) {
		init_sim_file();
	}
	else if (DBMode==BRKLY_DB_INFO) {
		init_sim_fdb();
	}
	else if (DBMode==MYSQL_DB_INFO) {
		init_sim_sql();
	}
	return;
}



void   close_sim_db()
{
	if (DBMode==MYSQL_DB_INFO) {
		close_sim_sql();
	}
	return;
}



void  update_sim_db(Sim_Info* sim_info)
{
	sim_info->update = (int)time(NULL);

	if (DBMode==PLN_FILE_INFO) {
		update_sim_file(sim_info);
	}
	else if (DBMode==BRKLY_DB_INFO) {
		update_sim_fdb(sim_info);
	}
	else if (DBMode==MYSQL_DB_INFO) {
		update_sim_sql(sim_info);
	}
	return;
}



Sim_Info*  get_sim_db_byname(char* sim_name)
{
	Sim_Info* sim_info = NULL;

	if (DBMode==PLN_FILE_INFO) {
		sim_info = get_sim_file_byname(sim_name);
	}
	else if (DBMode==BRKLY_DB_INFO) {
		sim_info = get_sim_fdb_byname(sim_name);
	}
	else if (DBMode==MYSQL_DB_INFO) {
		sim_info = get_sim_sql_byname(sim_name);
	}
	return sim_info;
}



Sim_Info*  get_sim_db_byhandle(char* handle)
{
	Sim_Info* sim_info = NULL;

	if (DBMode==PLN_FILE_INFO) {
		sim_info = get_sim_file_byhandle(handle);
	}
	else if (DBMode==BRKLY_DB_INFO) {
		sim_info = get_sim_fdb_byhandle(handle);
	}
	else if (DBMode==MYSQL_DB_INFO) {
		sim_info = get_sim_sql_byhandle(handle);
	}
	return sim_info;
}



