/**  
	Second Life Infomation Server: Berkeley DB I/O

				sl_info_fdb.c v1.0 by Fumi.Iseki (C)2008
*/


#ifdef HAVE_CONFIG_H
	#include "config.h" 
#endif

#include "sl_info_fdb.h"



#ifdef ENABLE_BERKELEYDB
#ifdef HAVE_DB_H


#include "bdb_tool.h"
#include "sl_tools.h"
#include "sl_relay_info_io.h"

#include "sl_info_tools.h"
#include "sl_info_db_io.h"



char*	DBFilePathNAME 	= NULL;
char*	DBFilePathHNDL 	= NULL;




//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

void	init_sim_fdb()
{
	// Directory
	if (DBFileDir==NULL) {
		Buffer dbdir = make_Buffer(LNAME);
		copy_s2Buffer(Temp_File_Dir, &dbdir);
		cat_s2Buffer (INFO_SUBDIR,   &dbdir);
		DBFileDir = (char*)dbdir.buf;				// donot free
		mkdir(DBFileDir, 0700);		 				// 失敗無視
	}
	
	// File Name
	Buffer dbfile = make_Buffer(LNAME);
	copy_s2Buffer(DBFileDir,    &dbfile);
	cat_s2Buffer (DB_FILE_NAME, &dbfile);

	// Name DB File
	if (DBFilePathNAME==NULL) {
		Buffer name_file = make_Buffer(LNAME);
		copy_Buffer(&dbfile, &name_file);
		cat_s2Buffer(DB_NAME_FILE_EXT, &name_file);
		DBFilePathNAME = (char*)name_file.buf;		// not free
	}

	// Handle DB File
	if (DBFilePathHNDL==NULL) {
		Buffer handle_file = make_Buffer(LNAME);
		copy_Buffer(&dbfile, &handle_file);
		cat_s2Buffer(DB_HNDL_FILE_EXT, &handle_file);
		DBFilePathHNDL = (char*)handle_file.buf;	// not free
	}

	DEBUG_MODE print_message("[%d] INIT_SIM_FDB: DB File = %s, %s\n", CrntPID, DBFilePathNAME, DBFilePathHNDL);

	check_fdb_file(DBFilePathNAME);
	check_fdb_file(DBFilePathHNDL);

	return;
}



void	update_sim_fdb(Sim_Info* sim_info)
{
	Buffer kname, handle, dat;

	if (sim_info==NULL) return;

	kname  = make_Buffer(LSNAME);
	handle = make_Buffer(REGION_HANDLE_LEN);
	dat    = make_Buffer(sizeof(Sim_Info));

	copy_s2Buffer(sim_info->sim_name, &kname);
	copy_b2Buffer(sim_info->handle, &handle, REGION_HANDLE_LEN);
	copy_b2Buffer((void*)sim_info, &dat, sizeof(Sim_Info));

	//print_message("Write %s\n", DBFilePathNAME);
	DB* dsn = open_fdb(DBFilePathNAME, 0);
	if (dsn!=NULL) {
		set_fdb_data(dsn, kname, dat);
		close_fdb(&dsn);
	}

	//print_message("Write %s %d\n", DBFilePathHNDL, handle.vldsz);
	//fdump_Buffer(handle);
	DB* dhd = open_fdb(DBFilePathHNDL, 0);
	if (dhd!=NULL) {
		set_fdb_data(dhd, handle, dat);
		close_fdb(&dhd);
	}

	free_Buffer(&kname);
	free_Buffer(&handle);
	free_Buffer(&dat);

	return;
}



Sim_Info*  get_sim_fdb_byname(char* sim_name)
{
	Sim_Info* sim_info = NULL;
	Buffer key, dat;

	key = make_Buffer(LSNAME);
	copy_s2Buffer(sim_name, &key);

	DB* dbp = open_fdb(DBFilePathNAME, DB_RDONLY);
	if (dbp!=NULL) {
		dat = get_fdb_data(dbp, key);
		sim_info = (Sim_Info*)dat.buf;
		close_fdb(&dbp);
	}
	free_Buffer(&key);

	return sim_info;
}



Sim_Info*  get_sim_fdb_byhandle(char* handle)
{
	Sim_Info* sim_info = NULL;
	Buffer key, dat;

	key = make_Buffer(REGION_HANDLE_LEN);
	copy_b2Buffer(handle, &key, REGION_HANDLE_LEN);

	DB* dbp = open_fdb(DBFilePathHNDL, DB_RDONLY);
	if (dbp!=NULL) {
		dat = get_fdb_data(dbp, key);
		sim_info = (Sim_Info*)dat.buf;
		close_fdb(&dbp);
	}
	free_Buffer(&key);

	return sim_info;
}




////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#else
    #error *****************************************************************************
    #error You specified --enable-db at configure, but there is not db.h in this system.
    #error *****************************************************************************
#endif



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#else


void	init_sim_fdb()
{
	return;
}


void	update_sim_fdb(Sim_Info* sim_info)
{
	return;
}


Sim_Info*  get_sim_fdb_byname(char* sim_name)
{
	return NULL;
}


Sim_Info*  get_sim_fdb_byhandle(char* handle)
{
	return NULL;
}


#endif


