/**  
	Second Life Infomation Server: Plane File DB I/O

				sl_info_file.c v1.0 by Fumi.Iseki (C)2007
*/


#include "sl_tools.h"
#include "sl_relay_info_io.h"

#include "sl_info_tools.h"
#include "sl_info_db_io.h"
#include "sl_info_file.h"



char*	PLFilePath 	 	= NULL;
char*	PLFilePathHNDL 	= NULL;




//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

void	init_sim_file()
{
	int  i, len;
	Buffer fnamed = make_Buffer(LNAME);
	Buffer fhndld = make_Buffer(LNAME);

	if (DBFileDir==NULL) {
		Buffer dbdir = make_Buffer(LNAME);
		copy_s2Buffer(Temp_File_Dir, &dbdir);
		cat_s2Buffer (INFO_SUBDIR,   &dbdir);
		DBFileDir = (char*)dbdir.buf;	 		// donot free
		mkdir(DBFileDir, 0700);					// 失敗無視
	}

	DEBUG_MODE print_message("[%d] INIT_SIM_FILE: create or check cache directories ... ", CrntPID);

	// SIM Nameキーファイル保存用ディレクトリ
	if (PLFilePath==NULL) {
		copy_s2Buffer(DBFileDir, &fnamed);
		cat_s2Buffer (INFO_SUBDIR_FNAME, &fnamed);
		PLFilePath = (char*)fnamed.buf;	
		mkdir(PLFilePath, 0700);
	}

	len = strlen(PLFilePath);
	cat_s2Buffer(" ", &fnamed);
	for (i=0; i<26; i++) {
		PLFilePath[len] = (unsigned char)('A' + i);
		mkdir(PLFilePath, 0700);
  		DEBUG_MODE print_message("%c ", PLFilePath[len]);
	}
	PLFilePath[len] = SIM_NAME_OTHER_DIR;
	mkdir(PLFilePath, 0700);
	DEBUG_MODE print_message("%c \n", PLFilePath[len]);
	PLFilePath[len] = '\0';

	// SIM HANDLE キーファイル保存用ディレクトリ
	if (PLFilePathHNDL==NULL) {
		copy_s2Buffer(DBFileDir, &fhndld);
		cat_s2Buffer (INFO_SUBDIR_FHNDL, &fhndld);
		PLFilePathHNDL = (char*)fhndld.buf;	
		mkdir(PLFilePathHNDL, 0700);				 // 失敗無視
	}
	
	len = strlen(PLFilePathHNDL);
	cat_s2Buffer("   ", &fhndld);
	for (i=0; i<256; i++) {
		snprintf(PLFilePathHNDL+len, 4, "%03d", i);
		mkdir(PLFilePathHNDL, 0700);
  		DEBUG_MODE print_message("%s ", PLFilePathHNDL+len);
	}
  	DEBUG_MODE print_message("\n");
	PLFilePathHNDL[len] = '\0';

	return;
}



void	update_sim_file(Sim_Info* sim_info)
{
	if (sim_info==NULL) return;

	char* flname = make_sim_info_filename(sim_info->sim_name);
	char* hdname = make_sim_info_hndlname(sim_info->handle);

	FILE* flp = fopen(flname, "wb");

	if (flp!=NULL) {
		fwrite(sim_info, sizeof(Sim_Info), 1, flp);
		fclose(flp);
		link(flname, hdname);
	}
	freeNull(flname);
	freeNull(hdname);

	return;
}



Sim_Info*  get_sim_file_byname(char* sim_name)
{
	Sim_Info* sim_info;
	int   sz = sizeof(Sim_Info);

	char* fn = make_sim_info_filename(sim_name);
	FILE* fp = fopen(fn, "r");
	if (fp==NULL) {
		freeNull(fn);
		return NULL;
	}

	sim_info = (Sim_Info*)malloc(sz);
	memset(sim_info, 0, sz);
	fread(sim_info, sz, 1, fp);
	fclose(fp);
	
	freeNull(fn);
	return sim_info;
}



Sim_Info*  get_sim_file_byhandle(char* handle)
{
	Sim_Info* sim_info;
	int   sz = sizeof(Sim_Info);

	char* fn = make_sim_info_hndlname(handle);
	FILE* fp = fopen(fn, "r");
	if (fp==NULL) {
		freeNull(fn);
		return NULL;
	}

	sim_info = (Sim_Info*)malloc(sz);
	memset(sim_info, 0, sz);
	fread(sim_info, sz, 1, fp);
	fclose(fp);
	
	freeNull(fn);
	return sim_info;
}



char*  make_sim_info_filename(char* sim_name)
{
	char  dirn[3];
	if (sim_name==NULL || sim_name[0]=='\0') return NULL;

	Buffer fname = make_Buffer(LNAME);
	copy_s2Buffer(PLFilePath, &fname);
	
	if (isalpha(sim_name[0])) dirn[0] = toupper(sim_name[0]);
	else                      dirn[0] = SIM_NAME_OTHER_DIR;
	dirn[1] = '/';
	dirn[2] = '\0';

	cat_s2Buffer(dirn, &fname);
	cat_s2Buffer(sim_name, &fname);

	//DEBUG_MODE print_message("%s\n", fname.buf);
	return (char*)fname.buf;
}



char*  make_sim_info_hndlname(char* handle)
{
	char  dirn[20];
	unsigned int  xx, yy;

	if (handle==NULL) return NULL;

	Buffer fname = make_Buffer(LNAME);
	copy_s2Buffer(PLFilePathHNDL, &fname);
	
	get_uint_from_RegionHandle(handle, &xx, &yy);
	snprintf(dirn, 18, "%03u/%06u-%06u", xx%256, xx, yy);		// 3+1+6+1+6 = 17
	cat_s2Buffer(dirn, &fname);

	//DEBUG_MODE print_message("%s\n", fname.buf);
	return (char*)fname.buf;
}




