/**  
  Second Life Infomation Server: Config Tools Program for Information Server	

				sl_iconfig.c v1.0  by Fumi.Iseki (C)2008
*/



#include "sl_tools.h"
#include "sl_info.h"
#include "sl_info_tools.h"
#include "sl_info_whitelist.h"




//////////////////////////////////////////////////////////////////////////
// Configuration File
//

void  read_config_file(char* fn)
{
	tList* lt;

	lt = read_index_tList_file(fn, ' ');

	if (lt!=NULL) {
		DEBUG_MODE print_message("[%d] READ_ICONFIG_FILE: readed configuration file [%s]\n", CrntPID, fn);

		MinUdpGatherPort  = get_intparam_tList(lt, "MinUdpGatherPort",	MinUdpGatherPort);
		MaxUdpGatherPort  = get_intparam_tList(lt, "MaxUdpGatherPort",	MaxUdpGatherPort);
		MinUdpInfoPort    = get_intparam_tList(lt, "MinUdpInfoPort",	MinUdpInfoPort);
		MaxUdpInfoPort    = get_intparam_tList(lt, "MaxUdpInfoPort",	MaxUdpInfoPort);
		MaxIdleTime       = get_intparam_tList(lt, "MaxIdleTime",		MaxIdleTime);
		Hosts_Allow_File  = get_strparam_tList(lt, "Hosts_Allow_File",	Hosts_Allow_File);
		White_List_File   = get_strparam_tList(lt, "White_List_File",	White_List_File);
		Temp_File_Dir     = get_strparam_tList(lt, "Temp_File_Dir",		Temp_File_Dir);

		del_all_tList(&lt);
	}
	else {
		DEBUG_MODE print_message("[%d] READ_ICONFIG_FILE: cannot read information configuration file [%s]\n", CrntPID, fn);
	}

	DEBUG_MODE {
		print_message("[%d] READ_ICONFIG_FILE: MinUdpGatherPort = %d\n", CrntPID, MinUdpGatherPort);
		print_message("[%d] READ_ICONFIG_FILE: MaxUdpGatherPort = %d\n", CrntPID, MaxUdpGatherPort);
		print_message("[%d] READ_ICONFIG_FILE: MinUdpInfoPort   = %d\n", CrntPID, MinUdpInfoPort);
		print_message("[%d] READ_ICONFIG_FILE: MaxUdpInfoPort   = %d\n", CrntPID, MaxUdpInfoPort);
		print_message("[%d] READ_ICONFIG_FILE: MaxIdleTime      = %d\n", CrntPID, MaxIdleTime);
		print_message("[%d] READ_ICONFIG_FILE: Hosts_Allow_File = %s\n", CrntPID, Hosts_Allow_File);
		print_message("[%d] READ_ICONFIG_FILE: White_List_File  = %s\n", CrntPID, White_List_File);
		print_message("[%d] READ_ICONFIG_FILE: Temp_File_Dir    = %s\n", CrntPID, Temp_File_Dir);
	}
}


