/*  
	Second Life Infomation Server: Main Program 	

				sl_imain.c v1.0  by Fumi.Iseki (C)2008
*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

#include "ipaddr_tool.h"
#include "password.h"

#include "sl_tools.h"
#include "sl_info_help.h"
#include "sl_info_tools.h"
#include "sl_relay_info_io.h"

#include "sl_info_whitelist.h"
#include "sl_info_gather.h"
#include "db_io/sl_info_db_io.h"



int		Vofd				= 0;
int		Wofd				= 0;

char* 	Temp_File_Dir	   	= "/var/sl_proxy/";
char* 	Hosts_Allow_File 	= "/usr/local/etc/sl_proxy/hosts_info.allow";

char* 	White_List_Dir	 	= "/var/sl_proxy/filter/";
char* 	White_List_File 	= "/var/sl_proxy/filter/white_sim.list";
tList*  SimWhiteList 		= NULL;

char* 	LogFileName			= "sl_info_agent.log";
FILE* 	LogFile		 		= NULL;
int   	LogMode   			= OFF;
int		SysLogLevel			= LOG_INFO;

int		DBMode				= PLN_FILE_INFO;

char* 	MyIPaddr		 	= NULL;
char* 	MyIPaddrNum	 		= NULL;

int	 	MinUdpGatherPort	= 12000;
int	 	MaxUdpGatherPort	= 12999;
int		MinUdpInfoPort		= 13000;
int		MaxUdpInfoPort		= 13999;
	
int	 	MaxIdleTime			= 300;

tList*  Process_List		= NULL;
tList* 	Allow_IPaddr   		= NULL;

pid_t   GPid				= 0;		// 情報収集サーバの PID
pid_t   TPid				= 0;		// 情報提供サーバの PID
pid_t   IPid				= 0;		// 情報サーバのコントロールプロセスの PID

unsigned short InfoGPort	= 0;		// 情報収集サーバの受信ポート(UDP)
unsigned short InfoTPort	= 0;		// 情報提供サーバの受信ポート(UDP)
unsigned short InfoIPort	= 0;		// 情報サーバのコントロールポート(TCP)

int		UseWhiteFilter		= OFF;





int main(int argc, char** argv)
{
	int	   i, lglvl=-1;
	char*  tempfile;
	pid_t  pid;

	unsigned short iport=0;
	int	cdlen;
	struct sockaddr_in px_addr;
	struct passwd* pw;
	struct sigaction sa;

	Buffer username, conffile, myipaddr, pidfile, logfile, wlist, wlist_dir;

	// 引数処理
	username = make_Buffer(LNAME);
	conffile = make_Buffer(LNAME);
	pidfile	 = make_Buffer(LNAME);
	myipaddr = make_Buffer(LNAME);
	logfile  = make_Buffer(LNAME);
	wlist    = make_Buffer(LNAME);

	for (i=1; i<argc; i++) {
		if		(!strcmp(argv[i],"-p"))   {if (i!=argc-1) iport = (unsigned short)atoi(argv[i+1]);}
		else if (!strcmp(argv[i],"-f"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
		else if (!strcmp(argv[i],"-u"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &username);}
		else if (!strcmp(argv[i],"-i"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &myipaddr); MyIPaddr = (char*)myipaddr.buf;}

		else if (!strcmp(argv[i],"-pid")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &pidfile);}
		else if (!strcmp(argv[i],"-l"))   {if (i!=argc-1 && *(argv[i+1])!='-') copy_s2Buffer(argv[i+1], &logfile); LogMode=ON;}
		else if (!strcmp(argv[i],"-v"))   {if (i!=argc-1) lglvl = atoi(argv[i+1]);}

		else if (!strcmp(argv[i],"-fdb")) DBMode = BRKLY_DB_INFO;
		else if (!strcmp(argv[i],"-sql")) DBMode = MYSQL_DB_INFO;

		else if (!strcmp(argv[i],"-wf"))  {if (i!=argc-1 && *(argv[i+1])!='-') copy_s2Buffer(argv[i+1], &wlist); UseWhiteFilter=ON;}

		else if (!strcmp(argv[i],"-d"))   DebugMode = ON;

		else if (!strcmp(argv[i],"--version")) { fprintf(stdout, SL_INFO_VERSION); fprintf(stdout, "\n"); exit(0); }
		else if (!strcmp(argv[i],"--help")) {sl_info_help(stdout); exit(0);}
		else if (!strcmp(argv[i],"-h"))     {sl_info_help(stdout); exit(0);}
		
		// old option
		else if (!strcmp(argv[i],"-c"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
	}

	CrntPID = getpid();

#ifndef ENABLE_BERKELEYDB
	if (DBMode==BRKLY_DB_INFO) {
		print_message("[%d] SL_IMAIN: ERROR: Berkelery DB Function is not linked!!!\n", CrntPID);	
		exit(1);
	}
#endif

#ifndef ENABLE_MYSQL
	if (DBMode==MYSQL_DB_INFO) {
		print_message("[%d] SL_IMAIN: ERROR: MySQL Function is not linked!!!\n", CrntPID);	
		exit(1);
	}
#endif

	if (iport==0) iport = INFO_SERVER_CPORT;
	InfoIPort = iport;
	InfoGPort = iport + 1;
	InfoTPort = iport + 2;

	if (lglvl>=0) SysLogLevel = lglvl;

	// -i option
	if (MyIPaddr==NULL) {
		MyIPaddr = get_localip_bydest("192.168.0.1");
		free_Buffer(&myipaddr);
	}
	MyIPaddrNum = (char*)to_address_num4(MyIPaddr, 0);
	if (MyIPaddrNum==NULL) {
		print_message("[%d] SL_IMAIN: ERROR: my IP address is incorrect!!!\n", CrntPID);	
		exit(1);
	}

	init_rand();

	///////////////////////////////////////////////////////
	// syslog のオープン
	openlog("SecondLife_Info", LOG_PID, LOG_AUTH);

	// 設定ファイルの読み込み
	if (conffile.buf[0]=='\0') copy_s2Buffer(CONFIG_FILE, &conffile);
	read_config_file((char*)conffile.buf);
	free_Buffer(&conffile);

	// Relayサーバの接続許可ファイルの読み込み
	Allow_IPaddr = read_ipaddr_file(Hosts_Allow_File);
	if (Allow_IPaddr!=NULL) {
		//syslog(SysLogLevel, "sl_imain: readed access control list for relay server.");
		DEBUG_MODE {
			print_message("[%d] SL_IMAIN: readed access control list for relay server.\n", CrntPID);
		  	print_address_in_list(stderr, Allow_IPaddr);
		}
	}
	else {
		syslog(SysLogLevel, "sl_imain: cannot read access control list for relay server. no access control.");
		DEBUG_MODE print_message("[%d] SL_IMAIN: cannot read access contol list for relay server. no access control.\n", CrntPID);
	}

	// PIDファイルの作成
	IPid = getpid();
	if (pidfile.buf[0]!='\0') {
		FILE* fp = fopen((char*)pidfile.buf, "w");
		if (fp!=NULL) {
			fprintf(fp, "%d", (int)IPid);
			fclose(fp);
		}
	}
	free_Buffer(&pidfile);

	// 実効ユーザの変更
	if (username.buf[0]!='\0') {
		int uerr = -1;
		int gerr = -1;
   
		DEBUG_MODE print_message("[%d] SL_IMAIN: change effective user to [%s]．\n", CrntPID, username.buf);
		if (isdigit(username.buf[0]) || username.buf[0]=='-') {
			gerr = 0;
			uerr = seteuid(atoi((char*)username.buf));
		}
		else {
			pw = getpwnam((char*)username.buf);
			if (pw!=NULL) {
				gerr = setegid(pw->pw_gid);
				uerr = seteuid(pw->pw_uid);
			}
		}
		if (gerr==-1) {
			syslog(SysLogLevel, "sl_imain: cannot change effective group: [%s]", strerror(errno));
			DEBUG_MODE print_message("[%d] SL_IMAIN: cannot change effectinve group.\n", CrntPID);
		}
		if (uerr==-1) {
			syslog(SysLogLevel, "sl_imain: cannot change effective user (%s): [%s]", username.buf, strerror(errno));
			DEBUG_MODE print_message("[%d] SL_IMAIN: cannot change effectinve user [%s].\n", CrntPID, username.buf);
		}
	}
	free_Buffer(&username);

	// シグナルハンドリング
	sa.sa_handler = sl_imain_term;
	sa.sa_flags   = 0;
	sigemptyset(&sa.sa_mask);
	sigaddset(&sa.sa_mask, SIGCHLD);
	sigaction(SIGINT,  &sa, NULL);
	sigaction(SIGHUP,  &sa, NULL);
	sigaction(SIGTERM, &sa, NULL);

	set_sigterm_child(sl_sigterm_child);			// Childプロセス終了時の処理設定
	DEBUG_MODE set_sigseg_handler(NULL);

	// 作業ディレクトリの書き込みチェック
	tempfile = temp_filename(Temp_File_Dir, WORK_FILENAME_LEN);
	if (tempfile!=NULL) {
		FILE* fp = fopen(tempfile, "w");
		if (fp==NULL) {
			syslog(SysLogLevel, "sl_imain: ERROR: sl_info cannot write working directory [%s]. going down!!  please check permission!!", Temp_File_Dir);
			print_message("[%d] SL_IMAIN: ERROR: sl_info cannot write working directory [%s]. \n", CrntPID, Temp_File_Dir);
			print_message("[%d] SL_IMAIN: ERROR: going down!!  please check directory permission!!\n", CrntPID);
			sl_imain_term(1);
		}
		fclose(fp);
		unlink(tempfile);
		free(tempfile);
	}

	// ログファイルの書き込みチェック
	if (LogMode) {
		if (logfile.vldsz<=0) {
			copy_s2Buffer(Temp_File_Dir, &logfile);
			cat_s2Buffer (LogFileName, &logfile);
		}

		LogFile = fopen((char*)logfile.buf, "a");
		if (LogFile==NULL) {
			syslog(SysLogLevel, "sl_imain: WARNING: sl_info cannot write logfile [%s].", logfile.buf);
			DEBUG_MODE print_message("[%d] SL_IMAIN: WARNING: sl_info cannot write logfile [%s].\n", CrntPID, logfile.buf);
		}
		free_Buffer(&logfile);
	}

	// データベースの作成またはチェック
	syslog(SysLogLevel, "sl_imain: DB Mode is %d.", DBMode);
	DEBUG_MODE print_message("[%d] SL_IMAIN: DB Mode is %d.\n", CrntPID, DBMode);
	init_sim_db();

	// ホワイトリストフィルター　設定ファイルの優先順位：コマンドオプション -> 設定ファイル -> デフォルト値
	if (UseWhiteFilter) {
		if (wlist.vldsz>0) {
			White_List_File = (char*)wlist.buf;
			wlist_dir = dup_Buffer(wlist);
			White_List_Dir  = (char*)wlist_dir.buf;
			int i = strlen((char*)wlist_dir.buf)-1;
			while (i>=0 && wlist_dir.buf[i]!='\0' && wlist_dir.buf[i]!='/') i--;
			wlist_dir.buf[i+1] = '\0';
		}
		SimWhiteList = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, NULL, NULL, 0);

		relay_param rparam;
		memset(&rparam, 0, sizeof(relay_param));
		if (!init_whitelist(rparam)) {
			sl_imain_term(1);
		}
	}

	////////////////////////////////////////////////////////////////////////////////////
	//
	// 
	Process_List = add_tList_node_int(NULL, 0, 0);	// アンカー
   
	// 情報収集サーバの起動
	GPid = fork();
	if (GPid==0) {
		CrntPID = getpid();
		del_all_tList(&Process_List);
		info_gathering_server(InfoGPort);
		exit(0);
	}
	add_tList_node_int(Process_List, 0, (int)GPid);

	////////////////////////////////////////////////////////////////////////////////////
	// 情報サーバ メインループ
	syslog(SysLogLevel, "sl_imain: start Main Loop for TCP connection. Port = %d", InfoIPort);
	DEBUG_MODE print_message("[%d] SL_IMAIN: start Main Loop for TCP connection. Port = %d\n", CrntPID, InfoIPort);

	Vofd = tcp_server_socket((int)InfoIPort);
	Loop {
		cdlen = sizeof(px_addr);
		Wofd = accept_intr(Vofd, (struct sockaddr*)&px_addr, (socklen_t*)&cdlen);
		if (Wofd<0) {
			syslog(SysLogLevel, "sl_imain: ERROR: accept() error [%s]", strerror(errno));
			print_message("[%d] SL_IMAIN: ERROR: accept() error [%s].\n", CrntPID, strerror(errno));
			sl_imain_term(1);
		}

		char* ipaddr	= get_ipaddr(px_addr.sin_addr);
		char* ipaddrnum = (char*)to_address_num4(ipaddr, 0);

		// check IP
		if (Allow_IPaddr!=NULL && !is_host_in_list(Allow_IPaddr, (unsigned char*)ipaddrnum, NULL)) {
			syslog(SysLogLevel, "sl_imain: WARNING: not allowed access from [%s]", ipaddr);
			DEBUG_MODE print_message("[%d] SL_IMAIN: WARNING: not allowed access from [%s]\n", CrntPID, ipaddr);

			freeNull(ipaddr);
			freeNull(ipaddrnum);
			close(Wofd);
			Wofd = 0;
			continue;
		}

		pid = fork();
		if (pid==0) {
			CrntPID = getpid();
			del_all_tList(&Process_List);
			sl_information_server();
			sl_imain_term(0);
		}
		add_tList_node_int(Process_List, 0, (int)pid);

		freeNull(ipaddr);
		freeNull(ipaddrnum);
		close(Wofd);
		Wofd = 0;
	}

	// not reachable
	close(Vofd);
	Vofd = 0;
	sl_imain_term(0);
}




//////////////////////////////////////////////////////////////////////////
// プログラムの終了
//

/**
void  sl_imain_term(int sig)

	機能：起動した子プロセスを全て終了させて，自分も終了する．

	引数：sig: 受信したシグナル（この関数を呼び出したシグナル）
			   特に使用はしない．
*/
void  sl_imain_term(int sig)
{ 
	int	ret;
	pid_t  cpid;
	tList* lp;

	DEBUG_MODE print_message("[%d] SL_IMAIN_TERM: called.\n", CrntPID);

	cpid = getpid();

	if (Wofd>0) socket_close(Wofd);
	Wofd = 0;

	// Main Process
	if (IPid==cpid) {
		syslog(SysLogLevel, "sl_imain_term: main program is going die!!");
		DEBUG_MODE print_message("[%d] SL_IMAIN_TERM: main program is going die!!\n", CrntPID);

		LOG_FILE {
			fflush(LogFile);
			fclose(LogFile);
			LogFile = NULL;
		}
		closelog();						// close syslog
		if (Vofd>0) socket_close(Vofd);
		Vofd = 0;
	}
	
	close_sim_db();

	signal(SIGCHLD, SIG_IGN);
	if (Process_List!=NULL) {
		lp = Process_List->next;
		while(lp!=NULL) {
			if (lp->ldat.lv>1) {
				DEBUG_MODE print_message("[%d] SL_IMAIN_TERM: kill [%d]!!\n", CrntPID, lp->ldat.lv);
				kill((pid_t)lp->ldat.lv, SIGINT);
			}
			lp = lp->next;
		}
		if (Process_List->next!=NULL) {
			do {		  		// チャイルドプロセスの終了を待つ   
				cpid = waitpid(-1, &ret, WNOHANG);
			} while(cpid>0);
		}

		del_all_tList(&Process_List);
	}

	exit(sig);
}



/**			
void  sl_sigterm_child(int signal)
				  
	機能：child プロセス終了時の処理
*/
void  sl_sigterm_child(int signal)
{
	pid_t pid = 0;
	int ret;

	DEBUG_MODE print_message("[%d] SL_SIGTERM_CHILD: called. signal = %d\n", (int)getpid(), signal);

	do {	// チャイルドプロセスの終了を待つ
		pid = waitpid(-1, &ret, WNOHANG);
		if (pid>0) del_process_list(Process_List, (int)pid, NULL);
	} while(pid>0);
}

