/**  
	Second Life Infomation Server 

				sl_info.c v1.0 by Fumi.Iseki (C)2008
*/


#include "sl_tools.h"
#include "sl_command.h"

#include "sl_info.h"
#include "sl_info_tools.h"
#include "sl_info_db_io.h"
#include "sl_info_whitelist.h"
#include "sl_info_gather.h"



///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Infomation Server
//

/**
void  sl_information_server()

	機能：情報サーバ
*/
void  sl_information_server()
{
	pid_t child;
	unsigned short tport, gport;
	relay_param  rparam;

	init_rand();
	Process_List = add_tList_node_int(NULL, 0, 0);		// 途中で死んじゃった場合用

	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Relayサーバの sl_relayと情報交換を行う
	rparam = exchange_info_with_relay(&tport, &gport);
	//print_message("gaddr_tcp = %s%d\n",get_ipaddr(rparam.gaddr_tcp.sin_addr), ntohs(rparam.gaddr_tcp.sin_port));
	//print_message("gaddr_udp = %s%d\n",get_ipaddr(rparam.gaddr_udp.sin_addr), ntohs(rparam.gaddr_udp.sin_port));
	//print_message("taddr_tcp = %s%d\n",get_ipaddr(rparam.taddr_tcp.sin_addr), ntohs(rparam.taddr_tcp.sin_port));
	//print_message("taddr_udp = %s%d\n",get_ipaddr(rparam.taddr_udp.sin_addr), ntohs(rparam.taddr_udp.sin_port));
	//char* ip = to_address_char4(rparam.viewer_ip);
	//print_message("agent = %s, viewer = %s\n",rparam.agent_name, ip);
	//freeNull(ip);

	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// 情報収集サーバへの中継プロセスの起動
	//
	if (rparam.gsock>0) {
		child = fork();
		if (child==0) {
			CrntPID = getpid();
			del_all_tList(&Process_List);
			relay_to_gathering_server(rparam);
			close(rparam.gsock);
			exit(0);
		}
		add_tList_node_int(Process_List, 0, (int)child);
		close(rparam.gsock);
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// 情報提供サーバ
	//
	if (rparam.tsock>0) {
		info_tendering_server(rparam);
		close(rparam.tsock);
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// 情報収集サーバのプロセスの停止．
	//
	struct sockaddr_in addr;
	int sock = udp_client_socket("127.0.0.1", gport, &addr);
	udp_command_terminate(sock, addr, rparam.passwd);
	close(sock);

	del_all_tList(&Process_List);
	freeNull(rparam.passwd);

	return;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Tendering Server
//

/**
void  info_tendering_server(relay_param rparam)

	機能：情報提供サーバ
*/
void  info_tendering_server(relay_param rparam)
{
	struct sockaddr_in addr;
	udp_com dat;
	Sim_Info* sim_info;

	if (UseWhiteFilter) {
		if (!init_whitelist(rparam)) {
			print_message("[%d] SL_TENDERING_SERVER: ERROR: SimWhiteList init error!!\n", CrntPID);
			return;
		}
	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	// 情報要求コマンドの処理ループ
	//	
	Loop {
		dat = recv_udp_command(rparam.tsock, &addr, MaxIdleTime, 0);
		//if (dat.com[0]==COM_ERROR_TIMEOUT || dat.com[0]==COM_SESSN_CLOSED) break;
		if (dat.com[0]==COM_ERROR_TIMEOUT) break;
        if (dat.com[0]==COM_ALIVE_REQUEST) {
			//DEBUG_MODE print_message("[%d] SL_TENDERING_SERVER: keep alive.\n", CrntPID);
			continue;
		}

		if (!is_same_sockaddr(addr, rparam.taddr_tcp) && !is_same_sockaddr(addr, rparam.taddr_udp)) {
			char* svip = get_ipaddr(addr.sin_addr);
			DEBUG_MODE print_message("[%d] SL_TENDERING_SERVER: WARNING: incorrect relay server connected!! [%s]\n", CrntPID, svip);
			freeNull(svip);
			continue;
		}

		////////////////////////////////////////////////////////////////////////////////
		// 
		if (dat.com[0]==COM_INFO_CRRCTIP_NOTIFY) {
			DEBUG_MODE print_message("[%d] SL_TENDERING_SERVER: recive COM_INFO_CRRCTIP_NOTIFY\n", CrntPID);
			memcpy(rparam.viewer_ip, dat.addr, 4);
			if (UseWhiteFilter) init_whitelist(rparam);		// エラーの場合は，フィルタの変更はなし
		}

		else if (dat.com[0]==COM_INFO_GET_NAME_BYHNDL) {
			sim_info = get_sim_db_byhandle(dat.mesg);
			if (sim_info!=NULL) {
				dat.com[1] = COM_OK_REPLY;
				memcpy(dat.mesg, sim_info->sim_name, Min(COM_MESG_LEN-1,strlen(sim_info->sim_name)+1));
				memcpy(dat.addr, sim_info->ipnum, 4);
				free(sim_info);
			}
			else {
				dat.com[1] = COM_NG_REPLY;
			}
			dat.com[0] = COM_INFO_GET_NAME_REPLY;
			udp_send(rparam.tsock, (char*)&dat, sizeof(udp_com), &addr);
		}

		///////////////////////////////////////////////////////////////////////////////
		// White List
		else if (dat.com[0]==COM_INFO_GET_WHITE_BYHNDL) {
			int ret = check_whitelist_byhandle(SimWhiteList, dat.mesg);
			if (ret==TRUE)         dat.com[1] = COM_OK_REPLY;
			else if (ret==UNKNOWN) dat.com[1] = COM_UNKNOWN_REPLY;
			else                   dat.com[1] = COM_NG_REPLY;
			dat.com[0] = COM_INFO_GET_WHITE_REPLY;
			udp_send(rparam.tsock, (char*)&dat, sizeof(udp_com), &addr);
		}

		else if (dat.com[0]==COM_INFO_GET_WHITE_BYNAME) {
			int ret = check_whitelist_byname(SimWhiteList, dat.mesg);
			if (ret==TRUE)         dat.com[1] = COM_OK_REPLY;
			else if (ret==UNKNOWN) dat.com[1] = COM_UNKNOWN_REPLY;
			else                   dat.com[1] = COM_NG_REPLY;
			dat.com[0] = COM_INFO_GET_WHITE_REPLY;
			udp_send(rparam.tsock, (char*)&dat, sizeof(udp_com), &addr);
		}

		///////////////////////////////////////////////////////////////////////////////
		// reset process
		else if (dat.com[0]==COM_RESET_PROCESS_REQUEST) {
			DEBUG_MODE print_message("[%d] SL_INFOMATION_SERVER: Process Reset!!\n", CrntPID);
			if (dat.pass!=NULL && !strncmp((char*)dat.pass, rparam.passwd, AUTH_PASSWD_LEN)) {
				if (UseWhiteFilter) {
					if (!init_whitelist(rparam)) {
						print_message("[%d] SL_INFOMATION_SERVER: ERROR: SimWhiteList reset error!!\n", CrntPID);
					}
				}
			}
		}

		// terminate process
		else if (dat.com[0]==COM_TERM_PROCESS_REQUEST) {
			DEBUG_MODE print_message("[%d] SL_INFOMATION_SERVER: Process Terminate!! [%s, %s]\n", CrntPID, dat.pass, rparam.passwd);
			if (dat.pass!=NULL && !strncmp((char*)dat.pass, rparam.passwd, AUTH_PASSWD_LEN)) break;
		}
	}

	return;
}




////////////////////////////////////////////////////////////////////////////////////////////
//
//

/**
relay_param  exchange_info_with_relay(void)

	機能：
		Relayサーバの sl_relayプロセスと，TCPで情報交換を行う
		通信プロトコルは順序依存．通信開始は Relayサーバから．

	戻り値：
		rparam : sl_relay と交換したネットワーク接続データ
			gsock     -- 情報収集サーバの受信用UDPソケット
			tsock     -- 情報提供サーバの通信用UDPソケット
			gaddr_tcp -- リレーサーバのHTTPSリレーコントローラが情報収集サーバと通信するためのポート情報（不正接続チェック用）
			gaddr_udp -- リレーサーバの UDP リレーコントローラが情報収集サーバと通信するためのポート情報（不正接続チェック用）
			taddr_tcp -- リレーサーバのHTTPSリレーコントローラが情報提供サーバと通信するためのポート情報
			taddr_udp -- リレーサーバの UDP リレーコントローラは情報提供サーバと通信するためのポート情報
			passwd    -- 接続相手確認のためにリレーサーバへ渡したパスワード
*/
relay_param  exchange_info_with_relay(unsigned short* tport, unsigned short* gport)
{
	tcp_com dat;
	relay_param  rparam;

	memset(&rparam, 0, sizeof(relay_param));

	if (gport==NULL || tport==NULL) return rparam;
	*gport = *tport = 0;

	// Relayサーバが情報収集サーバと接続するためのIP，ポートを得る（不正接続チェック用）
	dat = recv_tcp_command(Wofd, 5, 0);
	if (dat.com[0]==COM_IP_PORT_REQUEST && dat.port!=0 && dat.prtcl!=0) {
		rparam.gaddr_tcp = get_sockaddr_bynum((char*)(dat.addr), ntohs(dat.port));
		rparam.gaddr_udp = get_sockaddr_bynum((char*)(dat.addr), ntohs(dat.prtcl));
		rparam.gsock = get_valid_udp_socket(MinUdpGatherPort, MaxUdpGatherPort, gport);
		if (rparam.gsock<0) {
			//syslog(SysLogLevel, "exchange_info_with_relay: ERROR: information command port open error!! [%d]", rparam.gsock);
			print_message("[%d] EXCHANGE_INFO_WITH_RELAY: ERROR: information command port open error!! [%d]\n", CrntPID, rparam.gsock);
			exit(1);
		}

		// 情報収集サーバのIP，ポートを通知する
		dat.com[0] = COM_IP_PORT_REPLY;
		memcpy(dat.addr, MyIPaddrNum, 4);
		dat.port = htons(*gport);
		tcp_send(Wofd, (char*)&dat, sizeof(tcp_com));
	}
	else {
		//syslog(SysLogLevel, "exchange_info_with_relay: ERROR: the first request is incorrect!! [%02x]", dat.com[0]);
		print_message("[%d] EXCHANGE_INFO_WITH_RELAY: ERROR: the first request is incorrect!! [%02x]\n", CrntPID, dat.com[0]);
		exit(1);
	}

	// Relayサーバが情報提供サーバと接続するためのIP，ポートを得る
	dat = recv_tcp_command(Wofd, 5, 0);
	if (dat.com[0]==COM_IP_PORT_REQUEST && dat.port!=0 && dat.prtcl!=0) {
		rparam.taddr_tcp = get_sockaddr_bynum((char*)(dat.addr), ntohs(dat.port));
		rparam.taddr_udp = get_sockaddr_bynum((char*)(dat.addr), ntohs(dat.prtcl));
		rparam.tsock = get_valid_udp_socket(MinUdpInfoPort, MaxUdpInfoPort, tport);
		if (rparam.tsock<0) {
			//syslog(SysLogLevel, "exchange_info_with_relay: ERROR: request command port open error!! [%d]", rparam.tsock);
			print_message("[%d] EXCHANGE_INFO_WITH_RELAY: ERROR: request command port open error!! [%d]\n", CrntPID, rparam.tsock);
			exit(1);
		}

		// 情報提供サーバのIP，ポートを通知する
		dat.com[0] = COM_IP_PORT_REPLY;
		memcpy(dat.addr, MyIPaddrNum, 4);
		dat.port = htons(*tport);

		memset(dat.pass, 0, COM_PASS_LEN);
		rparam.passwd = random_str(AUTH_PASSWD_LEN);   	// donot free
		memcpy(dat.pass, rparam.passwd, AUTH_PASSWD_LEN);

		tcp_send(Wofd, (char*)&dat, sizeof(tcp_com));
	}
	else {
		//syslog(SysLogLevel, "exchange_info_with_relay: ERROR: the second request is incorrect!! [%02x]", dat.com[0]);
		print_message("[%d] EXCHANGE_INFO_WITH_RELAY: ERROR: the second request is incorrect!! [%02x]\n", CrntPID, dat.com[0]);
		exit(1);
	}

	// ViewerのIP(ProxyのIPかもしれない)，Agent名を得る
	dat = recv_tcp_command(Wofd, 5, 0);
	if (dat.com[0]==COM_INFO_LOGIN_NOTIFY) {
		memcpy(rparam.viewer_ip,  dat.addr, 4);
		int len = Min(LSNAME-1,  strlen(dat.mesg)+1);
		memcpy(rparam.agent_name, dat.mesg, len);
	}
	else {
		//syslog(SysLogLevel, "exchange_info_with_relay: ERROR: the third request is incorrect!! [%02x]", dat.com[0]);
		print_message("[%d] EXCHANGE_INFO_WITH_RELAY: ERROR: the third request is incorrect!! [%02x]\n", CrntPID, dat.com[0]);
		exit(1);
	}

	close(Wofd);
	Wofd = 0;
	
	return rparam;
}


