/**  
	Second Life Infomation Server: Header File

				sl_info.h v1.0 by Fumi.Iseki (C)2008
*/

#ifndef  _SL_INFO_H_
#define  _SL_INFO_H_


#include "network.h"
#include "tlist.h"

#include "sl_tools.h"


#define  SL_INFO_VERSION  "sl_info v1.0.1   (C) Fumi.Iseki"


#define PLN_FILE_INFO			1
#define BRKLY_DB_INFO			2 
#define MYSQL_DB_INFO			3


#define CONFIG_FILE				"/usr/local/etc/sl_proxy/sl_info.conf"




/**
	Sim_Info = Region_Info + update
*/
typedef struct {
	char			sim_name[LSNAME];
	char			guid[LGUID];
	char			handle[REGION_HANDLE_LEN];
	char			ipnum[4];
	unsigned short  access;
	unsigned short 	state;
	int			 	pos_X;
	int			 	pos_Y;
	time_t 			update;
} Sim_Info;



typedef struct {
	int					gsock;
	int					tsock;
	struct sockaddr_in 	gaddr_tcp;
	struct sockaddr_in 	gaddr_udp;
	struct sockaddr_in 	taddr_tcp;
	struct sockaddr_in 	taddr_udp;
	char*  				passwd;
	char   				viewer_ip[4];
	char   				agent_name[LSNAME];
} relay_param;




extern int		DebugMode;
extern int   	Vofd, Wofd;

extern FILE* 	LogFile;
extern int   	LogMode;
extern int   	SysLogLevel;

extern char* 	Temp_File_Dir;
extern char*	Hosts_Allow_File;

extern char*	White_List_Dir;
extern char*	White_List_File;
extern tList*   SimWhiteList;

extern int		DBMode;

extern char* 	MyIPaddr;
extern char* 	MyIPaddrNum;

extern int	 	MinUdpGatherPort;
extern int	 	MaxUdpGatherPort;
extern int	 	MinUdpInfoPort;
extern int	 	MaxUdpInfoPort;
	
extern int	 	MaxIdleTime;

extern tList*	Process_List;
extern tList* 	Allow_IPaddr;


extern unsigned short InfoGPort;
extern unsigned short InfoTPort;

extern int		UseWhiteFilter;




//////////////////////////////////////////////////////////////////////////
// Functions

// sl_imain.c
void  	sl_imain_term(int sig);
void	sl_sigterm_child(int signal);


// sl_iconfig.c
void 	read_config_file(char* fn);



/////////////////////////////////////////////////////
// sl_info.c
void	sl_information_server(void);
void	info_tendering_server(relay_param rparam);

relay_param  exchange_info_with_relay(unsigned short* tport, unsigned short* gport);



#endif



