/**  
	Second Life Infomation Server: Gathering Server 

				sl_info_gather.c v1.0 by Fumi.Iseki (C)2008
*/

#include "sl_tools.h"
#include "sl_command.h"
#include "sl_relay_info_io.h"
#include "sl_udp_protocol.h"

#include "sl_info_gather.h"
#include "sl_info_tools.h"
#include "sl_info_db_io.h"



tList*  AgentList		= NULL;     // ぶら下がるデータ(lst)は不定長 アンカーあり
tList*  SimNameList		= NULL;     // ぶら下がるデータ(ptr)は固定長 アンカーあり



//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Gathering Server
//

/**
void  info_gathering_server(unsigned short port)

	機能：情報収集サーバ

	引数：port: 情報コマンドの受信用ポート番号
*/
void  info_gathering_server(unsigned short port)
{
	int	   ret, sock;
	struct sockaddr_in px_addr;
	int	   tm = 600;

	sock = udp_server_socket(port);
	if (sock<=0) {
		//syslog(SysLogLevel, "info_gathering_server: ERROR: server socket open error. [%d]", sock);
		print_message("[%d] INFO_GATHERING_SERVER: ERROR: server socket open error. [%d]\n", CrntPID, sock);
		exit(1);
	}

	AgentList   = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, NULL, NULL, 0);
	SimNameList = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, NULL, NULL, 0);

	DEBUG_MODE print_message("[%d] INFO_GATHERING_SERVER: Start Infomation Gathering Server. Port = %d\n", CrntPID, port);

	// Mail Loop
	Loop {
        udp_com cmnd = recv_udp_command(sock, &px_addr, tm, 0);
		if (cmnd.com[0]==COM_ERROR_TIMEOUT) continue;

		char* ipaddr = get_ipaddr(px_addr.sin_addr);
		if (strcmp(ipaddr, "127.0.0.1")) {
			freeNull(ipaddr);
			continue;
		}
		freeNull(ipaddr);

		//////////////////////////////////////////////////////////////////////
		ret = info_gathering_command(cmnd);
		//////////////////////////////////////////////////////////////////////

		if (ret) {
			expire_list(AgentList, (unsigned int)INFO_AGENT_EXPIRE_TIME);
			check_list_limitsize(SimNameList, INFO_SIM_LIST_MAX, (int)(INFO_SIM_LIST_MAX*INFO_SIM_LIST_DEL_RATE));

			/*DEBUG_MODE {
				print_message("-----------------------------------------------------------------------\n");
				print_agent_list(stderr, AgentList);
				print_message("-----------------------------------------------------------------------\n");
				print_sim_list(stderr, SimNameList);
				fflush(stderr);
			}*/
			LOG_FILE {
				fprintf(LogFile, "-----------------------------------------------------------------------\n");
				print_agent_list(LogFile, AgentList);
				fflush(LogFile);
			}/**/
		}
	}

	close(sock);
}




//////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Gathering Relay Server
//

/**
void  relay_to_gathering_server(relay_param rparam)

	機能：
		リレーサーバからの情報コマンドを情報収集サーバへ転送する．必ず，Gathering Serverと同じマシンで動かすこと．

	引数：
		rparam : sl_relay と交換したネットワーク接続データ
*/
void  relay_to_gathering_server(relay_param rparam)
{
	int	    cc, cofd;
	udp_com cmnd; 
	struct  sockaddr_in  sv_addr, cl_addr;

	cofd = udp_client_socket("127.0.0.1", InfoGPort, &cl_addr);
	if (cofd<=0) {
		//syslog(SysLogLevel, "relay_to_gathering_server: ERROR: gathering server socket open error!!. port = %d", InfoGPort);
		print_message("[%d] RELAY_TO_GATHERING_SERVER: ERROR: gathering server socket open error!! port = %d\n", CrntPID, InfoGPort);
		exit(1);
	}

	Loop {
        cmnd = recv_udp_command(rparam.gsock, &sv_addr, MaxIdleTime, 0);
		if (cmnd.com[0]==COM_ERROR_TIMEOUT) continue;
		//if (cmnd.com[0]==COM_ERROR_TIMEOUT) break;
		//if (cmnd.com[0]==COM_ALIVE_REQUEST) continue;

		if (cmnd.pass==NULL || strncmp(cmnd.pass, rparam.passwd, AUTH_PASSWD_LEN)) {
			char* svip = get_ipaddr(sv_addr.sin_addr);
			DEBUG_MODE print_message("[%d] RELAY_TO_GATHERING_SERVER: WARNING: passwprd is miss match. cmnd = %s, rparam =%s from %s\n", 
																								CrntPID, cmnd.pass, rparam.passwd, svip);
			freeNull(svip);
			continue;
		}	

		if ((is_same_sockaddr(rparam.gaddr_tcp, sv_addr) || is_same_sockaddr(rparam.gaddr_udp, sv_addr))) { 
			if (cmnd.com[0]==COM_TERM_PROCESS_REQUEST) {
				DEBUG_MODE print_message("[%d] RELAY_TO_GATHERING_SERVER: received terminate command from relay server.\n", CrntPID);
				break;
			}
   			cc = udp_send(cofd, (char*)&cmnd, sizeof(udp_com), &cl_addr);
		}
		else {
			char* svip = get_ipaddr(sv_addr.sin_addr);
			if (!strcmp(svip, "127.0.0.1")) {
				if (cmnd.com[0]==COM_TERM_PROCESS_REQUEST) {
					DEBUG_MODE print_message("[%d] RELAY_TO_GATHERING_SERVER: received terminate command from localhost.\n", CrntPID);
					break;
				}
			}
			else {
				DEBUG_MODE print_message("[%d] RELAY_TO_GATHERING_SERVER: WARNING: incorrect relay server connected!! [%s]\n", CrntPID, svip);
			}
			freeNull(svip);
		}	
	}

	close(cofd);
	return;
}
 



////////////////////////////////////////////////////////////////////////////////////////////
//
// 	Gathering Server のコマンド処理
//

/**
int  info_gathering_command(Buffer buf)

	機能：UDPコマンドのメイン処理

	戻り値：TRUE  データの更新があった．
		　　FALSE データの更新はなかった．または不正なコマンド．
*/
int  info_gathering_command(udp_com cmnd)
{
	int      ret;
	tList*   agent_list;

	agent_list = AgentList;

	if (cmnd.uid==NULL) return FALSE;

	// full_nameで AgentListを検索
	while(agent_list!=NULL) {
		if (!strcasecmp((char*)(agent_list->ldat.key.buf), cmnd.uid)) break;
		agent_list = agent_list->next;
	}
	if (agent_list!=NULL) agent_list->ldat.lv = (int)time(NULL);

	DEBUG_MODE print_message("[%d] INFO_GATHERING_COMMAND: command is 0x%02x\n", CrntPID, cmnd.com[0]);

	// for Avatar
	ret = TRUE;
	if 		(cmnd.com[0]==COM_INFO_SET_AGENT) set_agent_info(agent_list, cmnd);
	else if (cmnd.com[0]==COM_INFO_UPD_AGENT) update_agent_info(agent_list, cmnd);
	else if (cmnd.com[0]==COM_INFO_DEL_AGENT) del_tList_node(agent_list);

	// for SIM
	else if (cmnd.com[0]==COM_INFO_SET_SIM)   ret = set_sim_info(agent_list, cmnd);
	else return FALSE; 

	return ret;
}



/**
void  set_agent_info(tList* agent_list, udp_com cmnd)

	機能：Agentの情報を大域リストノード AgentList に格納する．
		  既に該当 Agentのデータが存在する場合，agent_list にそのデータを入れて置く．
		　この場合はデータが上書きされる．
		　agent_list==NULL すなわち，該当Agentのデータがまだ存在しない場合は，新しく作成される．

	引数：
		agent_list   -- 該当Agentのデータが存在する場合は，そのデータへのポインタ．
		cmnd -- sl_relay から送られてきたデータ．

	構造体： sl_relay_info_io.h

			typedef struct {
    			char  agent_id  [LGUID];
    			char  first_name[LSNAME];
    			char  last_name [LSNAME];
			} Agent_Info;       // 40+32+32 = 104 octet
*/
void  set_agent_info(tList* agent_list, udp_com cmnd)
{
	if (agent_list!=NULL) del_tList_node(agent_list);

	Agent_Info* agent_info = (Agent_Info*)cmnd.mesg;
	char* ipa = to_address_char4(cmnd.addr);

	tList* pm = add_tList_node_bystr(AgentList, 0, (int)time(NULL), cmnd.uid, cmnd.pass, NULL, 0);
	pm->ldat.lst = add_tList_node_bystr(NULL, 0, 0, INFO_KEY_AGENT_ID, agent_info->agent_id, NULL, 0);

	add_tList_node_bystr(pm->ldat.lst, 0, 0, INFO_KEY_LAST_NAME,  agent_info->last_name,  NULL, 0);
	add_tList_node_bystr(pm->ldat.lst, 0, 0, INFO_KEY_FIRST_NAME, agent_info->first_name, NULL, 0);
	add_tList_node_bystr(pm->ldat.lst, 0, 0, INFO_KEY_FULL_NAME,  cmnd.uid, NULL, 0);
	add_tList_node_bystr(pm->ldat.lst, 0, 0, INFO_KEY_VIEWER_IP,  ipa, NULL, 0);

	freeNull(ipa);
	return;
}



/**
void  update_agent_info(tList* agent_list, udp_com cmnd)

	機能：大域リストノード AgentList中のAgent情報を更新する．
		　agent_list==NULL すなわち，該当Agentのデータがまだ存在しない場合は，新しく作成される．

	引数：
		agent_list   -- 該当Agentのデータが存在する場合は，そのデータへのポインタ．
		cmnd -- sl_relay から送られてきたデータ．
*/
void  update_agent_info(tList* agent_list, udp_com cmnd)
{
	if (agent_list==NULL) {
		set_agent_info(NULL, cmnd);
		return;
	}

	Agent_Info* agent = (Agent_Info*)cmnd.mesg;
	char* ipa = to_address_char4(cmnd.addr);

	if (agent_list->ldat.lst==NULL) agent_list->ldat.lst = add_tList_node_bystr(NULL, 0, 0, INFO_KEY_AGENT_ID, agent->agent_id, NULL, 0);
	else update_tList_node_bystr(agent_list->ldat.lst, 0, 0, INFO_KEY_AGENT_ID, agent->agent_id, NULL, 0);

	update_tList_node_bystr(agent_list->ldat.lst, 0, 0, INFO_KEY_LAST_NAME,  agent->last_name,  NULL, 0);
	update_tList_node_bystr(agent_list->ldat.lst, 0, 0, INFO_KEY_FIRST_NAME, agent->first_name, NULL, 0);
	update_tList_node_bystr(agent_list->ldat.lst, 0, 0, INFO_KEY_FULL_NAME,  cmnd.uid, NULL, 0);
	update_tList_node_bystr(agent_list->ldat.lst, 0, 0, INFO_KEY_VIEWER_IP,  ipa, NULL, 0);

	freeNull(ipa);
	return;
}




/**
int  set_sim_info(tList* agent_list, udp_com cmnd)

	機能：SIMの情報を検索し，リストに格納する．検索キーは Region Handle
*/
int  set_sim_info(tList* agent_list, udp_com cmnd)
{
	Sim_Info* 	 sim_info    = NULL;
	Region_Info* region_info = NULL;
	tList* sim_list = SimNameList;

	int	   ret = FALSE;
	int    savedbf = FALSE;
	time_t uptime;

	uptime = time(NULL);

	// 該当 Agentなし
	if (agent_list==NULL) {
		agent_list = add_tList_node_bystr(AgentList, 0, (int)uptime, cmnd.uid, NULL, NULL, 0);
	}

	region_info = (Region_Info*)cmnd.mesg;
	if (region_info->state & HAS_REGION_POSITION) {
		region_info->pos_X = ntohl(region_info->pos_X);
		region_info->pos_Y = ntohl(region_info->pos_Y);
	}

	// キャッシュリストの検索
	while (sim_list!=NULL) {
		if (!bincmp((unsigned char*)region_info->handle, sim_list->ldat.val.buf, REGION_HANDLE_LEN)) {
			if (sim_list->ldat.ptr!=NULL) {
				sim_info = sim_list->ldat.ptr;
				break;
			}
		}
		sim_list = sim_list->next;
	}

	// キャッシュリストにデータが無い場合は，キャッシュリストに登録
	if (sim_info==NULL) {
		sim_info = get_sim_db_byhandle(region_info->handle);
		if (sim_info!=NULL) { 	// データベースにデータあり
			tList* end_p = find_tList_end(SimNameList);
			sim_list = add_tList_node_bystr(end_p, 0, (int)uptime, sim_info->sim_name, NULL, NULL, 0);
			sim_list->ldat.val = set_Buffer(sim_info->handle, REGION_HANDLE_LEN);
			sim_list->ldat.ptr = (void*)sim_info;
			sim_list->ldat.sz  = sizeof(Sim_Info);
			sim_info->update   = uptime; 
		}
		else { 					// データベースにデータ無し
			tList* end_p = find_tList_end(SimNameList);
			sim_list = add_tList_node_bystr(end_p, 0, (int)uptime, region_info->sim_name, NULL, NULL, sizeof(Sim_Info));
			sim_list->ldat.val = set_Buffer(region_info->handle, REGION_HANDLE_LEN);

			sim_info = sim_list->ldat.ptr;
			memcpy(sim_info, region_info, sizeof(Region_Info));
			sim_info->state &= HAS_REGION_HERE_CLEAR;
			sim_info->update = uptime; 
			//get_SimPostion_from_RegionHandle(sim_info->handle, &sim_info->pos_X, &sim_info->pos_Y);
			savedbf = TRUE;
		}
		SimNameList->ldat.lv++; 
		ret = TRUE;
	}

	if (region_info->state&HAS_REGION_HERE) {
		update_tList_node_bystr(agent_list->ldat.lst, 0, (int)uptime, INFO_KEY_SIM_NAME, region_info->sim_name, NULL, 0);
		ret = TRUE;
	}

	// データベースへ保存
	if (savedbf || updated_sim_info(sim_info, region_info)) {
		update_sim_db(sim_info);
		ret = TRUE;
	}

	return ret;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// 構造体の構造に強く依存
//

int   updated_sim_info(Sim_Info* sim_info, Region_Info* region_info)
{
	int  ret = FALSE;

	if (sim_info==NULL || region_info==NULL) return FALSE;


	if (strcasecmp(sim_info->sim_name, region_info->sim_name)) {
		memcpy(sim_info->sim_name, region_info->sim_name, Min(LSNAME-1,strlen(region_info->sim_name)+1));
		ret = TRUE;
	}

	if (bincmp((unsigned char*)sim_info->guid, (unsigned char*)region_info->guid, LGUID)) {
		memcpy(sim_info->guid, region_info->guid, LGUID);
		ret = TRUE;
	}

	if (bincmp((unsigned char*)sim_info->ipnum, (unsigned char*)region_info->ipnum, 4)) {
		memcpy(sim_info->ipnum, region_info->ipnum, 4);
		ret = TRUE;
	}

	if (bincmp((unsigned char*)&sim_info->access, (unsigned char*)&region_info->access, 2)) {
		memcpy(&sim_info->access, &region_info->access, 2);
		ret = TRUE;
	}

	if (sim_info->pos_X!=region_info->pos_X || sim_info->pos_Y!=region_info->pos_Y) {
		sim_info->pos_X = region_info->pos_X;
		sim_info->pos_Y = region_info->pos_Y;
		ret = TRUE;
	}

	return ret;
}



