/**  
	Second Life Infomation Server: Gathering Server Header

				sl_info_gather.h v1.0 by Fumi.Iseki (C)2007
*/


#ifndef  _SL_INFO_GATGER_H_
#define  _SL_INFO_GATHER_H_



#include "buffer.h"
#include "tlist.h"

#include "sl_info.h"
#include "sl_command.h"
#include "sl_relay_info_io.h"


// KEYs for Infomation of Agent
#define INFO_KEY_AGENT_ID       "agent_id"
#define INFO_KEY_FULL_NAME      "full_name"
#define INFO_KEY_FIRST_NAME     "first_name"
#define INFO_KEY_LAST_NAME      "last_name"
#define INFO_KEY_SIM_NAME       "sim_name"
#define INFO_KEY_VIEWER_IP      "viewer_ip"


#define INFO_AGENT_EXPIRE_TIME  600     // AgentList Expire Time (s)

#define INFO_SIM_LIST_MAX       500     // メモリ内のSim Listの上限
#define INFO_SIM_LIST_DEL_RATE  0.2     // Sim Listが上限に達した場合，破棄するリストの割合



extern tList* 	AgentList;
extern tList* 	SimNameList;




//////////////////////////////////////////////////////////////////////////
// Functions

void	info_gathering_server(unsigned short port);
int	  	info_gathering_command(udp_com cmnd);

void	relay_to_gathering_server(relay_param rparam);

void  	set_agent_info   (tList* agent_list, udp_com cmnd);
void  	update_agent_info(tList* agent_list, udp_com cmnd);
int  	set_host_info(udp_com cmnd);
int  	set_sim_info (tList* agent_list, udp_com cmnd);

int   	updated_sim_info(Sim_Info* sim_info, Region_Info* region_info);


#endif



