/**  
	Second Life Infomation Server: White List Filter

				sl_info_whitelist.c v1.0 by Fumi.Iseki (C)2008
*/


#include "sl_tools.h"
#include "sl_info_tools.h"
#include "sl_info_whitelist.h"
#include "sl_info_db_io.h"



int		All_Sim_Allowed = FALSE;
int		PG_Sim_Allowed  = FALSE;


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// White List Filter
//
 
int  init_whitelist(relay_param rparam)
{
	Buffer wfile;
	tList* wlist = NULL;

	wfile = make_Buffer(LNAME);

	if (rparam.agent_name[0]!='\0') {
		copy_s2Buffer(White_List_Dir, &wfile);
		cat_s2Buffer (rparam.agent_name, &wfile); 
		wlist = read_tList_file((char*)wfile.buf, ON);
		DEBUG_MODE print_message("[%d] INIT_WHITELIST: readed white list file [%s].\n", CrntPID, wfile.buf);
	}

	if (wlist==NULL && *(int*)rparam.viewer_ip!=0) {
		char* ipa = to_address_char4((unsigned char*)rparam.viewer_ip);
		copy_s2Buffer(White_List_Dir, &wfile);
		cat_s2Buffer (ipa, &wfile); 
		wlist = read_tList_file((char*)wfile.buf, ON);
		freeNull(ipa);
		DEBUG_MODE print_message("[%d] INIT_WHITELIST: readed white list file [%s].\n", CrntPID, wfile.buf);
	}
	free_Buffer(&wfile);

	if (wlist==NULL) {
		wlist = read_tList_file(White_List_File, ON);
		DEBUG_MODE print_message("[%d] INIT_WHITELIST: readed white list file [%s].\n", CrntPID, White_List_File);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	if (wlist!=NULL) {
		DEBUG_MODE print_tList(stderr, wlist);
	}
	else {
		DEBUG_MODE print_message("[%d] INIT_WHITELIST: WARNING: While List File is disable [%s]. Use previous list.\n", CrntPID, White_List_File);
		if (SimWhiteList==NULL || SimWhiteList->next==NULL) {
			//syslog(SysLogLevel, "init_whitelist: ERROR: cannot read white list file [%s].", White_List_File);
			print_message("[%d] INIT_WHITELIST: ERROR: While List File is disable though Filter Mode was specified [%s].\n", CrntPID, White_List_File);
			return FALSE;
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	int pre_all_sim_allowed = All_Sim_Allowed;
	int pre_pg_sim_allowed  = PG_Sim_Allowed;

	check_consist_whitelist(&wlist);

	if (wlist==NULL && !All_Sim_Allowed && !PG_Sim_Allowed) {
		DEBUG_MODE print_message("[%d] INIT_WHITELIST: WARNING: All SIMs are invalid in White List. Use previous list.\n", CrntPID, White_List_File);
		All_Sim_Allowed = pre_all_sim_allowed;
		PG_Sim_Allowed  = pre_pg_sim_allowed;
		if (SimWhiteList==NULL || SimWhiteList->next==NULL) {
			//syslog(SysLogLevel, "init_whitelsit: ERROR: all sims are invalid in white list." );
			print_message("[%d] INIT_WHITELIST: ERROR: All SIMs are invalid in Whilte List.\n", CrntPID);
			return FALSE;
		}
	}
	else {		 
		DEBUG_MODE {
			if (All_Sim_Allowed) {
				print_message("--- All SIMs are allowed --------------------------------\n");
			}
			if (PG_Sim_Allowed) {
				print_message("--- PG SIMs are allowed ---------------------------------\n");
			}
			if (wlist!=NULL) {
				print_message("--- Valid SIMs ------------------------------------------\n");
				print_tList(stderr, wlist);
				print_message("---------------------------------------------------------\n");
			}
		}
	}

	if (SimWhiteList!=NULL) {
		if (SimWhiteList->next!=NULL) del_tList(&SimWhiteList->next);
		SimWhiteList->next = wlist;
	}
	else {
		print_message("[%d] INIT_WHITELIST: ERROR: SimWhiteList is NULL?????\n", CrntPID);
		return FALSE;
	}

	return TRUE;
}



/**
void	check_exist_whitelist(tList** wlist)

	機能：ホワイトリストのSIMの情報をデータベースから獲得する．
		  データベースに情報がないSIMはリストから削除する．
*/
void	check_consist_whitelist(tList** wlist)
{
	Sim_Info* sim_info;
	tList* pn;
	tList* pp;

	if (wlist==NULL || *wlist==NULL) return;

	All_Sim_Allowed = FALSE;
	PG_Sim_Allowed  = FALSE;

	pp = *wlist;
	while(pp!=NULL) {
		pn = pp->next;

		if (!strcmp((char*)pp->ldat.key.buf, WHITE_ALL_ALLOWED)) {
			All_Sim_Allowed = TRUE;
			if (pp==*wlist) *wlist = pn;
			del_tList_node(pp);
		}

		else if (!strcmp((char*)pp->ldat.key.buf, WHITE_PG_ALLOWED)) {
			PG_Sim_Allowed = TRUE;
			if (pp==*wlist) *wlist = pn;
			del_tList_node(pp);
		}

		else {	
			sim_info = get_sim_db_byname((char*)pp->ldat.key.buf);
			if (sim_info!=NULL) {
				pp->ldat.val = set_Buffer(sim_info->handle, REGION_HANDLE_LEN);
				pp->ldat.sz  = 2;
				pp->ldat.ptr = malloc(pp->ldat.sz);
				memcpy(pp->ldat.ptr, &sim_info->access, 2);
			}
			else {
				//print_message("[%d] CHECK_WHITE_LIST: WARNING: %s is unknown SIM in White List!!\n", CrntPID, pp->ldat.key.buf);
				if (pp==*wlist) *wlist = pn;
				del_tList_node(pp);
			}
		}
		pp = pn;
	}
	
	return;
}



int	 check_whitelist_byname(tList* sim_list, char* sim_name)
{
	if (sim_list==NULL || sim_name==NULL) return FALSE;
	if (All_Sim_Allowed) return TRUE;

	// リストの検索
	tList* pp = strncasecmp_tList(sim_list, sim_name, 0, 1);
	if (pp!=NULL) return TRUE;

	int ret = FALSE;
	if (PG_Sim_Allowed) {
		Sim_Info* sim_info = get_sim_db_byname(sim_name);
		if (sim_info!=NULL) {
			if (sim_info->access&ACCESS_PG_BIT) ret = TRUE;
			freeNull(sim_info);
		}
		else ret = UNKNOWN;
	}

	return ret;
} 



int	 check_whitelist_byhandle(tList* sim_list, char* handle)
{
	if (sim_list==NULL || handle==NULL) return FALSE;
	if (All_Sim_Allowed) return TRUE;

	// リストの検索
	tList* pp = sim_list;
	while (pp!=NULL) {
		if (!bincmp((unsigned char*)handle, pp->ldat.val.buf, REGION_HANDLE_LEN)) {
			break;
		}
		pp = pp->next;
	}
	if (pp!=NULL) return TRUE;

	int ret = FALSE;
	if (PG_Sim_Allowed) {
		Sim_Info* sim_info = get_sim_db_byhandle(handle);
		if (sim_info!=NULL) {
			if (sim_info->access&ACCESS_PG_BIT) ret = TRUE;
			freeNull(sim_info);
		}
		else ret = UNKNOWN;
	}

	return ret;
} 



