/**  
	Second Life Relay Server: Relay Server - Infomation Server I/O Header File.

				sl_relay_info_io.h  v1.5 by Fumi.Iseki (C)2008
*/


#ifndef  _SL_RELAY_INFO_IO_H_
#define  _SL_RELAY_INFO_IO_H_



/**
SIMの情報を拾うUDPプロトコル

	UDP_REGION_HANDSHK  (Low 148)	SIM Name, SIM UUID, Access
	UDP_AGENT_MOVE_CMPL (Low 250)	Region Handle
	UDP_SIM_STATS       (Low 140)	SIM Position (X, Y)
*/




#include "network.h"
#include "txml.h"

#include "sl_tools.h"
#include "sl_command.h"
#include "sl_xml_tag.h"



#define INFO_SERVER				"127.0.0.1"		// default IP
#define INFO_SERVER_CPORT		8086			// default port

#define	FILTER_LIST_MAX			100
#define	FILTER_LIST_DEL_RATE	0.2



// UDP通信から udp_relayが得た情報　(udp_relay 1つに SIMが 1つ対応している)
#define HAS_REGION_HANDLE		0x01	// SIM のリージョンハンドルを得ている
#define HAS_REGION_NAME			0x02	// SIM の名前を得ている．
#define HAS_REGION_POSITION		0x04	// SIM の位置を得ている．
#define HAS_REGION_HERE			0x08	// Avatarが現在いる SIMであることを示す．
#define HAS_REGION_HERE_CLEAR	0xf7	// HAS_REGION_HERE & HAS_REGION_HERE_CLEAR = 0x00





////////////////////////////////////////////////////////////////////
// Infomation: Login シーケンスから情報を得る．

typedef struct {
	char			agent_id  [LGUID];
	char			first_name[LSNAME];
	char			last_name [LSNAME];
} Agent_Info;		// 40+32+32 = 104 octet   udp_com.mesg より小さい必要がある．



// Auth_Info + Agent_Info
typedef struct {
	Agent_Info		agent;
	char			viewer_ip[4];
	char			session_id[LGUID];
	char			full_name[LSNAME];
} Login_Info;		// 104+40+4+32 = 180 octet




////////////////////////////////////////////////////////////////////
// UDP通信から情報を得る (see also Sim_Info in sl_info.h)

typedef struct {
	char			sim_name[LSNAME];
	char			guid[LGUID];
	char			handle[REGION_HANDLE_LEN];
	char			ipnum[4];
	unsigned short  access;
	unsigned short  state;
	int				pos_X;
	int				pos_Y;
} Region_Info;		// 32+40+8+4+2+2+4+4 = 96 octet



typedef struct {
	int					gsock_tcp;			// TCPリレーコントローラ用の Gathering Server中継サーバへのソケット
	int					gsock_udp;			// UDPリレーコントローラ用の Gathering Server中継サーバへのソケット
	int					tsock_tcp;			// TCPリレーコントローラ用の Tendering Server中継サーバへのソケット
	int					tsock_udp;			// UDPリレーコントローラ用の Tendering Server中継サーバへのソケット
	struct sockaddr_in 	gaddr;
	struct sockaddr_in 	taddr;
	char*  				passwd;
} info_param;





/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//

extern Login_Info  	LoginInformation;






/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
Login_Info	 get_login_info(tXML* vxml, tXML* sxml);
info_param   exchange_info_with_info(void);

int		send_agent_info (int isock, struct sockaddr_in addr, Login_Info info, int mode, char* passwd);
void	send_region_info(int isock, struct sockaddr_in addr, Login_Info info, Region_Info region_info, char* passwd);
int		pickup_region_info(Buffer buf, int prtcl, Region_Info* region_info);

char*	get_sim_name_byhandle (int sock, struct sockaddr_in addr, char* handle, char* passwd);
int  	get_sim_white_byname  (int sock, struct sockaddr_in addr, char* name,   char* passwd);
int  	get_sim_white_byhandle(int sock, struct sockaddr_in addr, char* handle, char* passwd);

void	reset_simname_cache(void);

udp_com	get_region_info_from_tender(int sock, struct sockaddr_in* addr, udp_com dat, char* passwd);




#endif

