/**  
	Second Life Infomation Server: Tools

				sl_info_tools.c v1.0 by Fumi.Iseki (C)2008
*/


#include "sl_tools.h"
#include "sl_info_tools.h"




////////////////////////////////////////////////////////////////////////////////////////////
//
//  Tools
//

void  print_agent_list(FILE* fp, tList* pp) 
{
	if (pp!=NULL && !strcmp((char*)pp->ldat.key.buf, LIST_ANCHOR)) pp = pp->next;
	if (pp==NULL) {
		fprintf(fp, "List is Null.\n");
		fflush(fp);
		return;
	}

	while (pp!=NULL) {
		fprintf(fp, "%10d %s\n", (unsigned int)pp->ldat.lv, pp->ldat.key.buf);
		tList* sp = pp->ldat.lst;
		while (sp!=NULL) {
			fprintf(fp, "		%s: %s\n", sp->ldat.key.buf, sp->ldat.val.buf);
			sp = sp->next;
		}
		pp = pp->next;
	}

	fflush(fp);
	return;
}



/**

*/
void  print_sim_list(FILE* fp, tList* pp) 
{
	if (pp!=NULL && !strcmp((char*)pp->ldat.key.buf, LIST_ANCHOR)) pp = pp->next;
	if (pp==NULL) {
		fprintf(fp, "List is Null.\n");
		fflush(fp);
		return;
	}

	while (pp!=NULL) {
		Sim_Info* sim = (Sim_Info*)(pp->ldat.ptr);
		print_sim_info(fp, sim);
		pp = pp->next;
	}

	fflush(fp);
	return;
}




////////////////////////////////////////////////////////////////////////
//
// 構造体の構造に強く依存
//

/**
	Sim_Info (sl_relay_info_io.h) に依存
*/
void  print_sim_info(FILE* fp, Sim_Info* sim) 
{
	char* ipa = to_address_char4((unsigned char*)sim->ipnum);

	fprintf(fp, "%s\n", sim->sim_name);
	fprintf(fp, "     ID: %s\n", sim->guid);
	fprintf(fp, "     IP: %s\n", ipa);
	fprintf(fp, "      X: %d\n", sim->pos_X);
	fprintf(fp, "      Y: %d\n", sim->pos_Y);
	fprintf(fp, " Access: 0x%04x\n", sim->access);
	fprintf(fp, " Handle: 0x");
	print_16x(fp, (unsigned char*)sim->handle, 8);
	fprintf(fp, " Update: %u\n", (unsigned int)sim->update);
	fprintf(fp, "\n");

	freeNull(ipa);
	return;
}



