/**  
  Second Life Relay Program: Configure File Tool Program 	

				sl_config.c v1.2 by Fumi.Iseki	(C)2007
*/



#include "sl_relay.h"



//////////////////////////////////////////////////////////////////////////
// Configuration File
//

void  read_config_file(char* fn)
{
	tList* lt;

	lt = read_index_tList_file(fn, ' ');

	if (lt!=NULL) {
		DEBUG_MODE   print_message("[%d] READ_CONFIG_FILE: readed configuration file [%s]\n", CrntPID, fn);

		MinUdpExPort   = get_int_param_tList(lt, "MinUdpExPort",   MinUdpExPort);
		MaxUdpExPort   = get_int_param_tList(lt, "MaxUdpExPort",   MaxUdpExPort);
		MinTcpExPort   = get_int_param_tList(lt, "MinTcpExPort",   MinTcpExPort);
		MaxTcpExPort   = get_int_param_tList(lt, "MaxTcpExPort",   MaxTcpExPort);
		MinUdpImPort   = get_int_param_tList(lt, "MinUdpImPort",   MinUdpImPort);
		MaxUdpImPort   = get_int_param_tList(lt, "MaxUdpImPort",   MaxUdpImPort);
		MinTcpImPort   = get_int_param_tList(lt, "MinTcpImPort",   MinTcpImPort);
		MaxTcpImPort   = get_int_param_tList(lt, "MaxTcpImPort",   MaxTcpImPort);
		MinControlPort = get_int_param_tList(lt, "MinControlPort", MinControlPort);
		MaxControlPort = get_int_param_tList(lt, "MaxControlPort", MaxControlPort);
		MaxIdleTime	   = get_int_param_tList(lt, "MaxIdleTime",	  MaxIdleTime);

		if (MinUdpExPort>MaxUdpExPort) int_swap(MinUdpExPort, MaxUdpExPort);
		if (MinTcpExPort>MaxTcpExPort) int_swap(MinTcpExPort, MaxTcpExPort);
		if (MinUdpImPort>MaxUdpImPort) int_swap(MinUdpImPort, MaxUdpImPort);
		if (MinTcpImPort>MaxTcpImPort) int_swap(MinTcpImPort, MaxTcpImPort);
		if (MinControlPort>MaxControlPort) int_swap(MinControlPort, MaxControlPort);

		CERT_PEM_File	 = get_str_param_tList(lt, "CERT_PEM_File", CERT_PEM_File);
		SKEY_PEM_File	 = get_str_param_tList(lt, "SKEY_PEM_File", SKEY_PEM_File);
		CA_PEM_File		 = get_str_param_tList(lt, "CA_PEM_File",   CA_PEM_File);

		Temp_File_Dir	 = get_str_param_tList(lt, "Temp_File_Dir",	  Temp_File_Dir);
		Hosts_Allow_File = get_str_param_tList(lt, "Hosts_Allow_File", Hosts_Allow_File);
		Proxy_Allow_File = get_str_param_tList(lt, "Proxy_Allow_File", Proxy_Allow_File);
		SL_GridInfo_File = get_str_param_tList(lt, "SL_GridInfo_File", SL_GridInfo_File);
		ExternalWebProxy = get_str_param_tList(lt, "ExternalWebProxy", ExternalWebProxy);

		del_all_tList(&lt);
	}
	else {
		DEBUG_MODE print_message("[%d] READ_CONFIG_FILE: cannot read configuration file [%s]\n", CrntPID, fn);
	}

	DEBUG_MODE {
		print_message("[%d] READ_CONFIG_FILE: MinUdpExPort     = %d\n", CrntPID, MinUdpExPort);
		print_message("[%d] READ_CONFIG_FILE: MaxUdpExPort     = %d\n", CrntPID, MaxUdpExPort);
		print_message("[%d] READ_CONFIG_FILE: MinTcpExPort     = %d\n", CrntPID, MinTcpExPort);
		print_message("[%d] READ_CONFIG_FILE: MaxTcpExPort     = %d\n", CrntPID, MaxTcpExPort);
		print_message("[%d] READ_CONFIG_FILE: MinUdpImPort     = %d\n", CrntPID, MinUdpImPort);
		print_message("[%d] READ_CONFIG_FILE: MaxUdpImPort     = %d\n", CrntPID, MaxUdpImPort);
		print_message("[%d] READ_CONFIG_FILE: MinTcpImPort     = %d\n", CrntPID, MinTcpImPort);
		print_message("[%d] READ_CONFIG_FILE: MaxTcpImPort     = %d\n", CrntPID, MaxTcpImPort);
		print_message("[%d] READ_CONFIG_FILE: MinControlPort   = %d\n", CrntPID, MinControlPort);
		print_message("[%d] READ_CONFIG_FILE: MaxControlPort   = %d\n", CrntPID, MaxControlPort);
		print_message("[%d] READ_CONFIG_FILE: MaxIdleTime      = %d\n", CrntPID, MaxIdleTime);

		print_message("[%d] READ_CONFIG_FILE: Temp File Dir    = %s\n", CrntPID, Temp_File_Dir);
		print_message("[%d] READ_CONFIG_FILE: Hosts Allow File = %s\n", CrntPID, Hosts_Allow_File);
		print_message("[%d] READ_CONFIG_FILE: SL GridInfo File = %s\n", CrntPID, SL_GridInfo_File);

		if (UseExtWebProxy) {
			print_message("[%d] READ_CONFIG_FILE: ExternalWebProxy = %s\n", CrntPID, ExternalWebProxy);
		}
		if (RstrctIntWebProxy) {
			print_message("[%d] READ_CONFIG_FILE: Proxy Allow File = %s\n", CrntPID, Proxy_Allow_File);
		}

		if (UseServerSSL) {
			print_message("[%d] READ_CONFIG_FILE: CERT PEM File    = %s\n", CrntPID, CERT_PEM_File);
			print_message("[%d] READ_CONFIG_FILE: SKEY PEM File    = %s\n", CrntPID, SKEY_PEM_File);
		}
		if (UseClientSSL && UseClientCA) {
			print_message("[%d] READ_CONFIG_FILE: CA PEM File      = %s\n", CrntPID, CA_PEM_File);
		}
	}
}



