/*	
	Second Life Relay Server: Main Program 

				sl_main.c v1.11  by Fumi.Iseki (C)2008-2010
*/


#include "password.h"
#include "ipaddr_tool.h"

#include "sl_relay.h"
#include "sl_web_proxy.h"
#include "sl_udp_transform.h"




char*	LoginServer			= NULL;
unsigned short LoginPort	= 0;

int		ALLDumpMode			= OFF;
int		TCPDumpMode			= OFF;
int		HTTPDumpMode		= OFF;
int		UDPDumpMode			= OFF;
int		UDPFullDumpMode		= OFF;

int		ExperimentMode		= OFF;

int		CacheMode			= OFF;
int		CachePutMode 		= ON;
int		CacheGetMode 		= ON;
int		TextureFullDLMode	= OFF;

//int	TelpFlSpMode		= OFF;

int		InjectionMode 		= OFF;
int		SeqNumRewrite		= OFF;


int		SysLogLevel 		= LOG_INFO;
//int 	SysLogLevel			= LOG_ERR;
int 	LogMode				= OFF;

int 	LocalMode			= OFF;

int		UseServerSSL 		= OFF;
int		UseClientSSL 		= ON;
int		UseClientCA			= OFF;

int		EnableMMRelay		= OFF;
int		UseExtWebProxy 		= OFF;
int		UseIntWebProxy 		= OFF;
int		RstrctIntWebProxy	= OFF;

int		UseInfoServer		= OFF;
int		UseWhiteFilter		= OFF;

int		UseVoiceServer		= OFF;

int		Vofd 				= 0;
int		Wofd 				= 0;


int		RepVersionMode		= OFF;
char*	RepVersion 			= NULL;


// サーバへのUDP接続ポート
int		MinUdpExPort		= 2000;
int		MaxUdpExPort		= 2999;

// サーバへのHTTPS接続ポート
int		MinTcpExPort		= 2000;
int		MaxTcpExPort		= 2999;

// UDPの待ち受けポート
int		MinUdpImPort		= 3000;
int		MaxUdpImPort		= 3999;

// HTTP(S)の待ち受けポート
int		MinTcpImPort		= 3000;
int		MaxTcpImPort		= 3999;

// コントロール用UDPポート
int		MinControlPort 		= 4000;
int		MaxControlPort 		= 4100;


int		MaxIdleTime			= 300;

char*	Temp_File_Dir		= "/var/sl_proxy/";
char*	Hosts_Allow_File 	= "/usr/local/etc/sl_proxy/hosts_relay.allow";
char*	Proxy_Allow_File 	= "/usr/local/etc/sl_proxy/proxy_dist.allow";

char*	LogFileName			= "sl_relay.log";
FILE* 	LogFile				= NULL;

char*	CERT_PEM_File 		= "/usr/local/etc/sl_proxy/cert.pem";
char*	SKEY_PEM_File 		= "/usr/local/etc/sl_proxy/skey.pem";
char*	CA_PEM_File			= "/usr/local/etc/sl_proxy/CA_lindenlab.pem";

char*	SL_GridInfo_File	= "/usr/local/etc/sl_proxy/sl_gridinfo.xml";

char*	MyIPaddr			= NULL;
char*	MyIPaddrNum			= NULL;
char*	VwIPaddr			= NULL;
char*	VwIPaddrNum			= NULL;
int		RelayServerPort		= 0;


// for External Server
char*	ExternalWebProxy	= NULL;
char*	ExternalWebProxyIP	= NULL;

char*	CacheServer			= NULL;
char*	CacheServerIP		= NULL;
char*	CacheServerIPNum	= NULL;
int		CacheServerPort 	= 0;

char*	InfoServer			= NULL;
char*	InfoServerIP		= NULL;
char*	InfoServerIPNum		= NULL;
int		InfoServerPort 		= 0;

char*	VoiceServer			= NULL;
char*	VoiceServerIP		= NULL;
char*	VoiceServerIPNum	= NULL;
int		VoiceServerPort 	= 0;

char*	ToCacheIPaddr		= NULL;	// キャッシュサーバへ接続する時のIP. MyIPaddr or 127.0.0.1
char*	ToCacheIPaddrNum 	= NULL;
char*	ToInfoIPaddr	 	= NULL;	// 情報サーバへ接続する時のIP. MyIPaddr or 127.0.0.1
char*	ToInfoIPaddrNum 	= NULL;

info_param		InfoParam;
cache_param		CacheParam;
voice_param		VoiceParam;

tList* 	Process_List 		= NULL;
tList* 	Relay_List 			= NULL;
tList* 	Allow_IPaddr		= NULL;

pid_t	RootPID 			= 0;





int main(int argc, char** argv)
{
	int	   i, cdlen, lgtyp=-1;
	unsigned short  vport=0, hport;
	unsigned short  cport=0, wport=0, iport=0;
	char*  tempfile;

	struct passwd* pw;
	struct sockaddr_in vw_addr;
	struct sigaction sa;

	Buffer hostname, username, conffile, pidfile, web_proxy, myipaddr, version, logfile;
	Buffer cache_server, info_server, voice_server;
	pid_t  pid;
	SSL*   ssl = NULL;

	// 引数処理
	hostname  = make_Buffer(LNAME);
	username  = make_Buffer(LNAME);
	pidfile	  = make_Buffer(LNAME);
	conffile  = make_Buffer(LNAME);
	web_proxy = make_Buffer(LNAME);
	myipaddr  = make_Buffer(LNAME);
	logfile   = make_Buffer(LNAME);
	version   = make_Buffer_bystr(SL_VERSION_CONTENT);

	cache_server = make_Buffer(LNAME);
	info_server  = make_Buffer(LNAME);
	voice_server = make_Buffer(LNAME);

	for (i=1; i<argc; i++) {
		if 		(!strcmp(argv[i],"-s"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &hostname);}
		else if	(!strcmp(argv[i],"-p"))   {if (i!=argc-1) vport = (unsigned short)atoi(argv[i+1]);}
		else if (!strcmp(argv[i],"-f"))	  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
		else if (!strcmp(argv[i],"-u"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &username);}
		else if (!strcmp(argv[i],"-i"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &myipaddr); MyIPaddr = (char*)myipaddr.buf;}

		else if (!strcmp(argv[i],"-pid")) {if (i!=argc-1) copy_s2Buffer(argv[i+1], &pidfile); }
		else if (!strcmp(argv[i],"-l"))   {if (i!=argc-1 && *(argv[i+1])!='-') copy_s2Buffer(argv[i+1], &logfile); LogMode=ON;}
		else if (!strcmp(argv[i],"-v"))   {if (i!=argc-1) lgtyp = atoi(argv[i+1]);}

		else if (!strcmp(argv[i],"-cs"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &cache_server); CacheMode=ON;}
		else if (!strcmp(argv[i],"-cg"))  CachePutMode  = OFF;		// Get only
		else if (!strcmp(argv[i],"-cp"))  CacheGetMode  = OFF;		// Put only

		else if (!strcmp(argv[i],"-txf")) TextureFullDLMode = ON;
		else if (!strcmp(argv[i],"-lm"))  LocalMode = ON;			// non secure

		else if (!strcmp(argv[i],"-is"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &info_server);   UseInfoServer=ON;}
		else if (!strcmp(argv[i],"-wf"))  UseWhiteFilter = ON;

		else if (!strcmp(argv[i],"-vs"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &voice_server);  UseVoiceServer=ON;}

		else if (!strcmp(argv[i],"-as"))  UseServerSSL  = ON;
		else if (!strcmp(argv[i],"-aca")) UseClientCA   = ON;
		else if (!strcmp(argv[i],"-ano")) UseClientSSL  = OFF;

		else if (!strcmp(argv[i],"-xp"))  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &web_proxy);	   UseExtWebProxy=ON;}
		else if (!strcmp(argv[i],"-ip"))  {if (i!=argc-1) wport = (unsigned short)atoi(argv[i+1]); UseIntWebProxy=ON;}
		else if (!strcmp(argv[i],"-ipx")) {if (i!=argc-1) wport = (unsigned short)atoi(argv[i+1]); RstrctIntWebProxy=ON;}
		else if (!strcmp(argv[i],"-mm"))  EnableMMRelay = ON;

		else if (!strcmp(argv[i],"-ver")) {if (i!=argc-1) cat_s2Buffer(argv[i+1], &version); RepVersionMode=ON; RepVersion=(char*)version.buf;}

		else if (!strcmp(argv[i],"-d"))   DebugMode    = ON;
		else if (!strcmp(argv[i],"-x"))   ALLDumpMode  = ON;
		else if (!strcmp(argv[i],"-xh"))  HTTPDumpMode = ON;
		else if (!strcmp(argv[i],"-xt"))  TCPDumpMode  = ON;
		else if (!strcmp(argv[i],"-xu"))  UDPDumpMode  = ON;
		else if (!strcmp(argv[i],"-xuf")) UDPFullDumpMode = ON;
		else if (!strcmp(argv[i],"-xa")) {UDPFullDumpMode = ON; ALLDumpMode  = ON;}

		else if (!strcmp(argv[i],"--version")) { fprintf(stdout, SL_RELAY_VERSION); fprintf(stdout, "\n"); exit(0); }
		else if (!strcmp(argv[i],"--help")) { sl_relay_help(stdout); exit(0); }
		else if (!strcmp(argv[i],"-h"))     { sl_relay_help(stdout); exit(0); }
		else if (!strcmp(argv[i],"-exp")) ExperimentMode = ON;

		// old option
		else if (!strcmp(argv[i],"-c"))	  {if (i!=argc-1) copy_s2Buffer(argv[i+1], &conffile);}
		else if (!strcmp(argv[i],"-e"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &cache_server); CacheMode=ON;}
		else if (!strcmp(argv[i],"-g"))   CachePutMode  = OFF;		// Get only
		else if (!strcmp(argv[i],"-n"))   CacheGetMode  = OFF;		// Put only
		else if (!strcmp(argv[i],"-t"))   UseServerSSL  = ON;
		else if (!strcmp(argv[i],"-o"))   UseClientSSL  = OFF;
		else if (!strcmp(argv[i],"-a"))   UseClientCA   = ON;
		else if (!strcmp(argv[i],"-w"))   {if (i!=argc-1) copy_s2Buffer(argv[i+1], &web_proxy);	   UseExtWebProxy=ON;}
		else if (!strcmp(argv[i],"-m"))   EnableMMRelay = ON;
	}

	CrntPID = RootPID = getpid();

	if (hostname.buf[0]=='\0') copy_s2Buffer(SL_LOGIN_SERVER, &hostname);
	if (vport==0) vport = SERVER_PORT;
	RelayServerPort = vport;

	// Login Server
	i = 0;
	while(hostname.buf[i]!='\0' && hostname.buf[i]!=':') i++;
	if (hostname.buf[i]==':') {
		hport = (unsigned short)atoi((char*)&(hostname.buf[i+1]));
		hostname.buf[i] = '\0';
	}
	else hport = HTTPS_PORT;			// default of HTTPS port

	LoginServer = (char*)hostname.buf;
	LoginPort   = (unsigned short)hport;

	// Cache Server
	if (CacheMode) {
		cport = 0;
		if (cache_server.buf[0]=='\0' || cache_server.buf[0]=='-') {
			copy_s2Buffer(CACHE_SERVER, &cache_server);
		}
			
		i = 0;
		while(cache_server.buf[i]!='\0' && cache_server.buf[i]!=':') i++;
		if (cache_server.buf[i]==':') {
			cport = (unsigned short)atoi((char*)&(cache_server.buf[i+1]));
			cache_server.buf[i] = '\0';
		}

		CacheServer   = (char*)cache_server.buf;
		CacheServerIP = get_ipaddr_byname(CacheServer);
		if (CacheServerIP!=NULL) {
			CacheServerIPNum = (char*)to_address_num4(CacheServerIP, 0);
			if (cport==0) cport = CACHE_CPORT;
			CacheServerPort = cport;
			// 接続用IP
			ToCacheIPaddr = get_localip_bydest(CacheServerIP);
			if (ToCacheIPaddr!=NULL) ToCacheIPaddrNum = (char*)to_address_num4(ToCacheIPaddr, 0);
		}
		else {
			CacheMode	 = OFF;
			CachePutMode = OFF;
			CacheGetMode = OFF;
			DEBUG_MODE print_message("[%d] SL_MAIN: WARNING: Disable Cache Server.\n", CrntPID);
		}
	}
	else {
		CachePutMode = OFF;
		CacheGetMode = OFF;
	}

	// Infomation Server
	if (UseWhiteFilter) UseInfoServer = ON;
	if (UseInfoServer) {
		iport = 0;
		if (info_server.buf[0]=='\0' || info_server.buf[0]=='-') {
			copy_s2Buffer(INFO_SERVER, &info_server);
		}
			
		i = 0;
		while(info_server.buf[i]!='\0' && info_server.buf[i]!=':') i++;
		if (info_server.buf[i]==':') {
			iport = (unsigned short)atoi((char*)&(info_server.buf[i+1]));
			info_server.buf[i] = '\0';
		}

		InfoServer   = (char*)info_server.buf;
		InfoServerIP = get_ipaddr_byname(InfoServer);
		if (InfoServerIP!=NULL) {
			InfoServerIPNum = (char*)to_address_num4(InfoServerIP, 0);
			if (iport==0) iport = INFO_SERVER_CPORT;
			InfoServerPort = iport;
			// 接続用IP
			ToInfoIPaddr = get_localip_bydest(InfoServerIP);
			if (ToInfoIPaddr!=NULL) ToInfoIPaddrNum = (char*)to_address_num4(ToInfoIPaddr, 0);
		}
		else {
			UseInfoServer = OFF;
			DEBUG_MODE print_message("[%d] SL_MAIN: WARNING: Disable Infomation Server.\n", CrntPID);
			if (UseWhiteFilter==ON) {
				syslog(SysLogLevel, "sl_main: ERROR: Infomation Server is disable though Filter Mode was specified.");
				DEBUG_MODE print_message("[%d] SL_MAIN: ERROR: Infomation Server is disable though Filter Mode was specified.\n", CrntPID);
				exit(1);
			}
		}
	}

	// Voice Relay Server
	if (UseVoiceServer) {
		iport = 0;
		if (voice_server.buf[0]=='\0' || voice_server.buf[0]=='-') {
			copy_s2Buffer(VOICE_SERVER, &voice_server);
		}
			
		i = 0;
		while(voice_server.buf[i]!='\0' && voice_server.buf[i]!=':') i++;
		if (voice_server.buf[i]==':') {
			iport = (unsigned short)atoi((char*)&(voice_server.buf[i+1]));
			voice_server.buf[i] = '\0';
		}

		VoiceServer   = (char*)voice_server.buf;
		VoiceServerIP = get_ipaddr_byname(VoiceServer);
		if (VoiceServerIP!=NULL) {
			VoiceServerIPNum = (char*)to_address_num4(VoiceServerIP, 0);
			if (iport==0) iport = VOICE_SERVER_CPORT;
			VoiceServerPort = iport;
			// 接続用IP
			//ToVoiceIPaddr = get_localip_bydest(VoiceServerIP);
			//if (ToVoiceIPaddr!=NULL) ToVoiceIPaddrNum = (char*)to_address_num4(ToVoiceIPaddr, 0);
		}
		else {
			UseVoiceServer = OFF;
			DEBUG_MODE print_message("[%d] SL_MAIN: WARNING: Disable Voice Relay Server.\n", CrntPID);
		}
	}

	// External WEB Proxy
	ExternalWebProxy = (char*)web_proxy.buf;
	if (UseExtWebProxy) {
		i = 0;
		while(web_proxy.buf[i]!='\0' && web_proxy.buf[i]!=':') i++;
		if (web_proxy.buf[i]==':') web_proxy.buf[i] = '\0';

		ExternalWebProxyIP = get_ipaddr_byname(ExternalWebProxy);  

		if (ExternalWebProxyIP==NULL) {
  			UseExtWebProxy = OFF;
			DEBUG_MODE print_message("[%d] SL_MAIN: WARNING: Disable External WEB Proxy.\n", CrntPID);
		}
	}

	// Internal WEB Proxy
	if (RstrctIntWebProxy) UseIntWebProxy = ON;
	if (UseIntWebProxy) {
		if (wport==0) wport = HTTP_PROXY_PORT;
		freeNull(ExternalWebProxyIP);
		UseExtWebProxy= ON;
		copy_s2Buffer("localhost", &web_proxy);					// to ExternalWebProxy
		Buffer web_proxy_ip = make_Buffer_bystr("127.0.0.1");
		ExternalWebProxyIP = (char*)web_proxy_ip.buf;  
	}

	// Dump Mode
	if (ALLDumpMode) {
		TCPDumpMode  = ON;
		UDPDumpMode  = ON;
		HTTPDumpMode = ON;
	}
	if (UDPFullDumpMode) UDPDumpMode = ON;

	// Local Mode
	if (LocalMode) {
		cat_s2Buffer("127.0.0.1", &myipaddr);
		MyIPaddr = (char*)myipaddr.buf;
	}

	// no -i option
	if (MyIPaddr==NULL) {
		MyIPaddr = get_localip_bydest("192.168.0.1");
		free_Buffer(&myipaddr);
	}

	//
	MyIPaddrNum	= (char*)to_address_num4(MyIPaddr, 0);
	if (MyIPaddrNum==NULL) {
		print_message("SL_MAIN: ERROR: my IP address is incorrect!!!\n");
		exit(1);
	}

	//
	init_rand();

	SeqNumRewrite = check_seqnum_rewrite_mode();		// UDPパケットのシーケンスを書き換えるかどうか？
	Process_List = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, NULL, NULL, 0);
	if (lgtyp>=0) SysLogLevel = lgtyp;


	///////////////////////////////////////////////////////////////////////////
	// syslog のオープン
	openlog("SecondLife_Relay", LOG_PID, LOG_AUTH);

	// 設定ファイルの読み込み
	if (conffile.buf[0]=='\0') copy_s2Buffer(CONFIG_FILE, &conffile);
	read_config_file((char*)conffile.buf);
	free_Buffer(&conffile);

	// PIDファイルの作成
	if (pidfile.buf[0]!='\0') {
		FILE* fp = fopen((char*)pidfile.buf, "w");
		if (fp!=NULL) {
			fprintf(fp, "%d", (int)RootPID);
			fclose(fp);
		}
	}
	free_Buffer(&pidfile);

	DEBUG_MODE print_message("[%d] SL_MAIN: root PID is [%d]\n", CrntPID);

	// 接続許可・禁止ファイルの読み込み
	Allow_IPaddr = read_ipaddr_file(Hosts_Allow_File);
	if (Allow_IPaddr!=NULL) {
		DEBUG_MODE {
			print_message("[%d] SL_MAIN: readed access control list.\n", RootPID);
			print_message("============================================\n");
  			print_address_in_list(stderr, Allow_IPaddr);
			print_message("============================================\n");
		}
		if (UseIntWebProxy || LocalMode) add_tList_node_str(Allow_IPaddr, "127.0.0.1", NULL);
	}
	else {
		DEBUG_MODE print_message("[%d] SL_MAIN: cannot read access contorol list. no access control.\n", CrntPID);
	}

	// 実効ユーザの変更
	if (username.buf[0]!='\0') {
		int uerr = -1;
		int gerr = -1;
   
		DEBUG_MODE print_message("[%d] SL_MAIN: change effective user to [%s]．\n", CrntPID, username.buf);
		if (isdigit(username.buf[0])) {
			gerr = 0;
			uerr = seteuid(atoi((char*)username.buf));
		}
		else {
			pw = getpwnam((char*)username.buf);
			if (pw!=NULL) {
				gerr = setegid(pw->pw_gid);
				uerr = seteuid(pw->pw_uid);
			}
		}
		if (gerr==-1) {
			DEBUG_MODE print_message("[%d] SL_MAIN: WARNING: cannot change effectinve group.\n", CrntPID);
		}
		if (uerr==-1) {
			DEBUG_MODE print_message("[%d] SL_MAIN: WARNING: cannot change effectinve user [%s].\n", CrntPID, username.buf);
		}
	}
	free_Buffer(&username);

	// Internal Web Proxy の起動
	if (UseIntWebProxy) {
		pid = fork();
		if (pid==0) {
			CrntPID = getpid();
			int err = sl_web_proxy_start(wport, MyIPaddr, Allow_IPaddr);
			if (err<0) {
				syslog(SysLogLevel, "sl_main: ERROR: start of Internal WEB Proxy is fail. [%d]", err);
				print_message("[%d] SL_MAIN: ERROR: Start of Internal WEB Proxy is Fail. [%d]\n", CrntPID, err);
			}
			pid = getppid();
			DEBUG_MODE print_message("[%d] SL_MAIN: send SIGINT to [%d]\n", CrntPID, pid);
			kill(pid, SIGINT);
			//sl_web_proxy_term(1);
			exit(1);
		}
		add_tList_node_int(Process_List, 0, (int)pid);
		Process_List->ldat.id++;
	}

	// シグナルハンドリング
	sa.sa_handler = sl_sigterm_process;
	sa.sa_flags   = 0;
	sigemptyset(&sa.sa_mask);
	sigaddset(&sa.sa_mask, SIGCHLD);
	sigaction(SIGINT,  &sa, NULL);
	sigaction(SIGHUP,  &sa, NULL);
	sigaction(SIGTERM, &sa, NULL);

	set_sigterm_child(sl_sigterm_child);	// Childプロセス終了時の処理設定
	DEBUG_MODE set_sigseg_handler(NULL);	// Segmentation Falt check

	// 作業ディレクトリの書き込みチェック
	tempfile = temp_filename(Temp_File_Dir, WORK_FILENAME_LEN);
	if (tempfile!=NULL) {
		FILE* fp = fopen(tempfile, "wb");
		if (fp==NULL) {
			syslog(SysLogLevel, "sl_main: ERROR: sl_relay cannot write working directory [%s]. going down!!  please check permission!!", Temp_File_Dir);
			print_message("SL_MAIN: ERROR: sl_relay cannot write working directory [%s]. going down!!  please check permission!!\n", Temp_File_Dir);
			sl_sigterm_process(1);
		}
		fclose(fp);
		unlink(tempfile);
		free(tempfile);
	}

	// 前回残った作業用ゴミファイルを削除
	//clean_work_file(Temp_File_Dir, WORK_FILENAME_LEN);

	// ログファイルの書き込みチェック
	if (LogMode) {
		if (logfile.vldsz<=0) {
			copy_s2Buffer(Temp_File_Dir, &logfile);
			cat_s2Buffer (LogFileName, &logfile);
		}
		
		LogFile = fopen((char*)logfile.buf, "a");
		if (LogFile==NULL) {
			DEBUG_MODE print_message("SL_MAIN: WARNING: sl_relay cannot write logfile [%s].\n", logfile.buf);
		}
		free_Buffer(&logfile);
	}

	// 認証局証明書のチェック
	if (UseClientSSL && UseClientCA) {
		if (!file_exist(CA_PEM_File)) {
			DEBUG_MODE print_message("SL_MAIN: WARNING: cannot read CA file [%s]. not use CA file.\n", CA_PEM_File);
			UseClientCA = OFF;
		}
	}

	// Relayサーバのサーバ証明書と秘密鍵ファイルのチェック
	if (UseServerSSL) {
		if (!file_exist(CERT_PEM_File)) {
			syslog(SysLogLevel, "sl_main: ERROR: cannot read cert file [%s].", CERT_PEM_File);
			print_message("SL_MAIN: ERROR: cannot read cert file [%s].\n", CERT_PEM_File);
			sl_sigterm_process(1);
		}
		if (!file_exist(SKEY_PEM_File)) {
			syslog(SysLogLevel, "sl_main: ERROR: cannot read secret key file [%s].", SKEY_PEM_File);
			print_message("SL_MAIN: ERROR: cannot read secret key file [%s].\n", SKEY_PEM_File);
			sl_sigterm_process(1);
		}
	}

	// 確認用Log
	DEBUG_MODE {
		if (LocalMode) {
			print_message("[%d] SL_MAIN: LocalMode is         ON\n", CrntPID);
		}
		//
		print_message("[%d] SL_MAIN: UseServerSSL        = %d\n", CrntPID, UseServerSSL);
		print_message("[%d] SL_MAIN: UseClientSSL        = %d\n", CrntPID, UseClientSSL);
		print_message("[%d] SL_MAIN: UseClientCA         = %d\n", CrntPID, UseClientCA);

		if (CacheMode) {
			print_message("[%d] SL_MAIN: Cache Server        = %s:%d\n", CrntPID, CacheServerIP, CacheServerPort);
			print_message("[%d] SL_MAIN: Connect IP to Cache = %s\n", 	 CrntPID, ToCacheIPaddr);
			print_message("[%d] SL_MAIN: Cache PutMode       = %d\n", 	 CrntPID, CachePutMode);
			print_message("[%d] SL_MAIN: Cache GetMode       = %d\n", 	 CrntPID, CacheGetMode);
		}
		print_message("[%d] SL_MAIN: SequenceNum Rewrite = %d\n", CrntPID, SeqNumRewrite);

		if (UseInfoServer) {
			print_message("[%d] SL_MAIN: Infomation Server   = %s:%d\n", CrntPID, InfoServerIP, InfoServerPort);
			print_message("[%d] SL_MAIN: Connect IP to Info  = %s\n", 	 CrntPID, ToInfoIPaddr);
			print_message("[%d] SL_MAIN: WhiteList Filtering = %d\n", 	 CrntPID, UseWhiteFilter);
		}

		if (UseVoiceServer) {
			print_message("[%d] SL_MAIN: Voice Relay Server  = %s:%d\n", CrntPID, VoiceServerIP, VoiceServerPort);
		}

		if (UseIntWebProxy) {
			print_message("[%d] SL_MAIN: Internal WEB Proxy  = %s:%d\n", CrntPID, ExternalWebProxyIP, wport);
			if (RstrctIntWebProxy) {
				print_message("[%d] SL_MAIN: Internal WEB Proxy is Restriction mode\n", CrntPID);
			}
		}
		else if (UseExtWebProxy) {
			print_message("[%d] SL_MAIN: External WEB Proxy  = %s\n", CrntPID, ExternalWebProxyIP);
		}
	}


	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// メインループ
    DEBUG_MODE print_message("[%d] SL_MAIN: start SL Relay Main Loop for TCP connection. Port = %d\n", CrntPID, vport);

	Vofd = tcp_server_socket((int)vport);

	Loop {
		cdlen = sizeof(vw_addr);
		Wofd = accept_intr(Vofd, (struct sockaddr*)&vw_addr, (socklen_t*)&cdlen);
		if (Wofd<0) {
			//DEBUG_MODE print_message("[%d] SL_MAIN: ERROR: accept() error.\n", CrntPID);
			syslog(SysLogLevel, "sl_main: ERROR: accept() error. [%s]", strerror(errno));
			print_message("[%d] SL_MAIN: ERROR: accept() error [%s].\n", CrntPID, strerror(errno));
			sl_sigterm_process(1);
		}

		VwIPaddr	= get_ipaddr(vw_addr.sin_addr);
		VwIPaddrNum = (char*)to_address_num4(VwIPaddr, 0);

		// IP Address check
		if (Allow_IPaddr!=NULL && !is_host_in_list(Allow_IPaddr, (unsigned char*)VwIPaddrNum, NULL)) {
			syslog(SysLogLevel, "sl_main: ERROR: not allowed access from [%s]", VwIPaddr);
			print_message("[%d] SL_MAIN: ERROR: not allowed access from [%s]\n", CrntPID, VwIPaddr);

			freeNull(VwIPaddr);
			freeNull(VwIPaddrNum);
			close(Wofd);
			Wofd = 0;
			continue;
		}

		// SSL socket
		if (UseServerSSL) {
			ssl_init();
			ssl = ssl_server_socket(Wofd, CERT_PEM_File, SKEY_PEM_File);
			if (ssl==NULL) { 
				syslog(SysLogLevel, "sl_main: ERROR: ssl_server_socket()");
				print_message("[%d] SL_MAIN: ERROR: ssl_server_socket().\n", CrntPID);
				sl_sigterm_process(1);
			}

			int err = SSL_accept(ssl);
	  		if (err!=1) {
				ERR_print_errors_fp(stderr);
				err = SSL_get_error(ssl, err);
				DEBUG_MODE print_message("[%d] SL_MAIN: WARNING: ssl connection fail. [%d]\n", CrntPID, err);

				freeNull(VwIPaddr);
				freeNull(VwIPaddrNum);
				close(Wofd);
				ssl_close(ssl);
				Wofd = 0;
				ssl  = NULL;
				continue;
			}
		}

		pid = fork();
		if (pid==0) {
			CrntPID = getpid();
			sl_relay(LoginServer, LoginPort, Wofd, ssl);
			sl_sigterm_process(0);
		}
		add_tList_node_int(Process_List, 0, (int)pid);
		Process_List->ldat.id++;

		freeNull(VwIPaddr);
		freeNull(VwIPaddrNum);
		ssl_close(ssl);
		close(Wofd);
		Wofd = 0;
		ssl  = NULL;
	}

	// not reachable
	socket_close(Vofd);
	Vofd = 0;
	freeNull(MyIPaddr); 

	sl_sigterm_process(0);
}



//////////////////////////////////////////////////////////////////////////
// プログラムの終了
//
void  sl_sigterm_process(int sig)
{  
	int ret;
	tList* pl = NULL;
	pid_t pid, cpid;

	pid = getpid();
	DEBUG_MODE print_message("[%d] SL_SIGTERM_PROCESS: going down!!\n", CrntPID);

	ignore_sigterm_child();

	pl = Process_List;
	while(pl!=NULL) {
		if (pl->ldat.lv>1) {
			//DEBUG_MODE print_message("SL_SIGTERM_PROCESS: down signal to [%d].\n", pl->ldat.lv);
			if (pl->ldat.lv!=0) {
				DEBUG_MODE print_message("[%d] SL_SIGTERM_PROCESS: send SIGINT to [%d]\n", CrntPID, pl->ldat.lv);
				kill((pid_t)pl->ldat.lv, SIGINT);
			}
		}
		pl = pl->next;
	}
	del_all_tList(&Process_List);
	
	do {	 		// チャイルドプロセスの終了を待つ   
		cpid = waitpid(-1, &ret, WNOHANG);
	} while(cpid>0);

	// Socket
	if (Wofd>0) socket_close(Wofd);
	Wofd = 0;

	// Root Process
	if (pid==RootPID) {
		DEBUG_MODE print_message("[%d] SL_SIGTERM_PROCESS: root process is going down.\n", CrntPID);

		LOG_FILE {
			fflush(LogFile);
			fclose(LogFile);
			LogFile = NULL;
		}

		if (Vofd>0) socket_close(Vofd);
		Vofd = 0;
		closelog();		// close syslog
	}

	exit(sig);
}



/**			   
void  sl_sigterm_child(int signal)
				  
	機能：child プロセス終了時の処理
*/				
void  sl_sigterm_child(int signal)
{				
	pid_t pid = 0;
	int ret;
				  
	//DEBUG_MODE print_message("[%d] SL_SIGTERM_CHILD: called. signal = %d\n", (int)getpid(), signal);

	do {	// チャイルドプロセスの終了を待つ   
		pid = waitpid(-1, &ret, WNOHANG);
		if (pid>0 && Process_List!=NULL) {
			del_process_list(Process_List, (int)pid, NULL);
		}
	} while(pid>0);
}



