/**
	Second Life Relay Server: Header File

				sl_relay.h v1.11  by Fumi.Iseki (C)2007-2014
*/


#ifndef  __SL_RELAY_H_
#define  __SL_RELAY_H_


#define  SL_RELAY_VERSION  "sl_relay v1.11.0  (C) Fumi.Iseki and NSL"


#ifdef HAVE_CONFIG_H
	#include "config.h"
#endif

#include "txml.h"
#include "ssl_tool.h"

#include "sl_tools.h"
#include "sl_relay_help.h"
#include "sl_relay_cache_io.h"
#include "sl_relay_info_io.h"
#include "sl_relay_voice_io.h"
 
#include "sl_xml_tag.h"


#define  RUNAWAY_TIME_OUT 		300
#define  CONFIG_FILE  			"/usr/local/etc/sl_proxy/sl_relay.conf"
#define  SL_LOGIN_SERVER 		"login.agni.lindenlab.com:443"
#define  SL_LOGIN_SERVER_BETA 	"login.aditi.lindenlab.com:443"

#define  SERVER_PORT  			8100
#define  HTTPS_PORT   			443

#define	 KEEP_ALIVE_TIME		30

#define  V2S_RECV_FILE			"1.v2s"
#define  S2V_RECV_FILE			"2.s2v"
#define  S2V_PROC_FILE			"3.s2v.proc"
#define  V2S_LOGIN_FILE			"1.v2s.login"
#define  S2V_LOGIN_FILE			"2.s2v.login"
#define  S2V_LOGIN_PROC_FILE	"3.s2v.login.proc"


// Access from Viewer
#define  FAIL_ACCESS			-2
#define  NOT_HTTP_ACCESS		-1
#define  LOGIN_ACCESS			0
#define  HTTP_OTHER_ACCESS		1
#define  GRIDINFO_ACCESS		2
#define  TOS_MESSAGE_ACCESS		3



//////////////////////////////////////////////////////////////////////////

extern char*	LoginServer;
extern unsigned short LoginPort;

extern int 		DebugMode;
extern int 		ALLDumpMode;
extern int 		TCPDumpMode;
extern int 		HTTPDumpMode;
extern int 		UDPDumpMode;
extern int 		UDPFullDumpMode;

extern int		ExperimentMode;
extern int 		RepVersionMode;

extern int		CacheMode;
extern int 		CachePutMode;
extern int 		CacheGetMode;
extern int 		TextureFullDLMode;
//extern int 	TelpFlSpMode;

extern int		InjectionMode;
extern int		SeqNumRewrite;

extern int 		SysLogLevel;

extern int 		LogMode;
extern int 		LocalMode;

extern int 		UseServerSSL;
extern int 		UseClientSSL;
extern int 		UseClientCA;

extern int 		EnableMMRelay;
extern int 		UseExtWebProxy;
extern int 		UseIntWebProxy;
extern int		RstrctIntWebProxy;

extern int 		UseInfoServer;
extern int 		UseWhiteFilter;

extern int 		UseVoiceServer;

extern int 		Vofd, Wofd;

extern int 		MaxUdpExPort, MinUdpExPort;
extern int 		MaxTcpExPort, MinTcpExPort;
extern int 		MaxUdpImPort, MinUdpImPort;
extern int 		MaxTcpImPort, MinTcpImPort;
extern int 		MaxControlPort, MinControlPort;

extern int 		MaxIdleTime;

extern char*	LogFileName;
extern FILE*	LogFile;

extern char* 	Hosts_Allow_File;
extern char* 	Proxy_Allow_File;
extern char* 	Temp_File_Dir;

extern char* 	CERT_PEM_File;
extern char* 	SKEY_PEM_File;
extern char* 	CA_PEM_File;

extern char*	SL_GridInfo_File;

extern char* 	CacheIPaddr;
extern char* 	CacheIPaddrNum;
extern char* 	MyIPaddr;
extern char* 	MyIPaddrNum;
extern char* 	VwIPaddr;
extern char* 	VwIPaddrNum;
extern int	 	RelayServerPort;

extern tList* 	Process_List;
extern tList* 	Relay_List;
extern tList* 	Allow_IPaddr;

extern char* 	RepVersion;


// for External Server  
extern char* 	ExternalWebProxy;
extern char*   	ExternalWebProxyIP;

extern char*   	CacheServer;
extern char*   	CacheServerIP;
extern char*   	CacheServerIPNum;
extern int		CacheServerPort;

extern char*   	InfoServer;
extern char*   	InfoServerIP;
extern char*   	InfoServerIPNum;
extern int		InfoServerPort;

extern char*   	VoiceServer;
extern char*   	VoiceServerIP;
extern char*   	VoiceServerIPNum;
extern int		VoiceServerPort;

extern char*   	ToCacheIPaddr;
extern char*   	ToCacheIPaddr;
extern char*   	ToCacheIPaddrNum;
extern char*  	ToInfoIPaddr;
extern char*   	ToInfoIPaddrNum;

extern info_param	InfoParam;
extern cache_param	CacheParam;
extern voice_param	VoiceParam;




//////////////////////////////////////////////////////////////////////////
// Functions

// sig term
void   	sl_sigterm_process(int signal);
void  	sl_sigterm_child(int signal);


// sl_config.c
void   	read_config_file(char* fn);


// sl_relay
void   	sl_relay(char* hostname, unsigned short cport, int sofd, SSL* sossl);
int  	login_relay(char* lhost, unsigned short lport, int sofd, SSL* sossl, unsigned short utport, unsigned short uuport,
								 					tList* iplist, tList* nmlist, tList* ipproc, tList* nmproc, char* passwd);
int		relay_save_login_res (int sofd, SSL* sossl, int cofd, SSL* cossl, char** recvfn, tList** rl, tList** pl, tXML** vxml, tXML** sxml);
int		replace_send_gridinfo(int sofd, SSL* sossl, tList* rl, tList* pl, tTree** sxml);

void	sigterm_relay_child(int signal);

#endif


