/** 
	Second Life Relay Server: Relay Server - UDP Cache Server I/O Program

				sl_relay_cache_io.c v1.5  by Fumi.Iseki (C)2007
*/



#include "sl_relay.h"
#include "sl_udp.h"
#include "sl_udp_transform.h"
#include "sl_relay_cache_io.h"



unsigned int  all_Request_Counter = 0;
unsigned int  hit_Request_Counter = 0;

int   Timeout_Counter = 0;




///////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

/**
int	udp_get_texture_cache(int qsock, Buffer* buf, struct sockaddr_in cq_addr, int vsock, struct sockaddr_in vw_addr)

	機能：High 8(テクスチャのリクエスト) のパケットのデータからキャッシュサーバにリクエストするデータを分離し，
		  キャッシュサーバにテクスチャのリクエストを行う．

	引数：
		qsock   -- キャッシュサーバのリクエスト用UDPソケット
		buf		-- Viewerから受信した High 8 のパケット
		addr	-- キャッシュサーバのネットワーク情報
		vsock   -- ViewerへのUDPソケット（ACK返答要）
		vw_addr -- Viewerのネットワーク情報

	戻り値：TRUE  -- SIMへのリクエストが残っている．
			FALSE -- 全てキャッシュサーバへリクエストしたので，SIMへのリクエストは残っていない
*/
int	udp_get_texture_cache(int qsock, Buffer* buf, struct sockaddr_in cq_addr, int vsock, struct sockaddr_in vw_addr)
{					
	unsigned char* p;
	udp_com* req;	
	int tosim = TRUE;

	p = (unsigned char*)(buf->buf+39+buf->buf[5]); 					// リクエストするイメージの数
	all_Request_Counter += (unsigned int)(*p); 						// リクエスト中の全イメージ数

	int ret = udp_check_texture_cache(qsock, buf, cq_addr, &req);	// キャッシュデータを確認し，リクエストデータを分離
	if (*p==0x00) tosim = FALSE;									// SIM に送るデータは 0
	if (ret>0) {													// キャッシュが存在．
		send_udp_message_toViewer(vsock, *buf, vw_addr, Send_P2V_ACK);	// send ACK to Viewer
		udp_request_texture_cache(qsock, req, ret, cq_addr);		// Request Cache of Texture
		free(req);
								 
		if (tosim) {
			//unsigned int svr = udp_toServer_Counter + 1;		 
			// 新しい udp_toServer_SeqNum は実際に転送する時に update_v2s_sequenceno() で計算
			unsigned int i;
			unsigned int pktn = udp_fromViewer_SeqNum - udp_fromViewer_SeqNum_pre;
			for (i=1; i<pktn; i++) {
				S2V_Ack_Valid[(udp_toServer_SeqNum+i)%LST_SZ] = TRANSFORM_VALID;
			}
			S2V_Ack_Valid[(udp_toServer_SeqNum+pktn)%LST_SZ]  = TRANSFORM_INVALID;				 // block ACK from SIM
		}

		hit_Request_Counter += (unsigned int)ret;
	}
	//hit_Request_Rate = (float)hit_Reguest_Counter/all_Request_Counter*100;
					 
	return tosim;
}




/**
int  udp_check_texture_cache(int csock, Buffer* buf, struct sockaddr_in addr, udp_com** req) 

	機能：High 8 のパケット（テクスチャのリクエスト）のデータを検査し，キャッシュサーバへのリクエストと
		  SIMへのリクエストを分離する．キャッシュサーバにリクエストするためのコマンドも生成する．

	引数：
		csock -- キャッシュサーバのリクエスト用UDPソケット
		buf   -- Viewerから受信した High 8 のパケット
		addr  -- キャッシュサーバのネットワーク情報
		*req  -- キャッシュサーバへのリクエスト用コマンドへのポインタ

	戻り値：
		return -- キャッシュにヒットしたデータの数．これは req[] の個数になる．
		buf	   -- キャッシュにヒットしたリクエスト部分を削除して返される．
		req[]  -- キャッシュにヒットしたデータをリクエストするためのコマンドデータ．要 free
*/
int  udp_check_texture_cache(int csock, Buffer* buf, struct sockaddr_in addr, udp_com** req) 
{
	unsigned char* p;
	unsigned char* u;
	unsigned char* v;
	int  rqno, i, j, n, m, cc, pos;
	udp_com* dat;
	udp_com  rcv;
	Buffer   snd;

	p = buf->buf + 6 + buf->buf[5];

	*req = NULL;
	pos  = 40 + buf->buf[5];
	rqno = (int)(unsigned int)p[33];
	dat  = (udp_com*)malloc(sizeof(udp_com)*rqno);
	if (dat==NULL) return 0;

	///////////////////////////////////////////////////////////////
	// check cached image
	for (i=0,n=0; i<rqno; i++) {
		int   cnt;
		float pri;
		//char* passwd;
		unsigned int seq = RequestSeqNum++;

		u = buf->buf + pos + 26*i;
		memset((char*)(dat+i), 0, sizeof(udp_com));
		dat[i].com[0] = COM_TXTR_CACHE_CHECK;
		dat[i].com[1] = COM_NG_REPLY;										// no cached
		dat[i].seqnum = seq;
		dat[i].port   = htons((unsigned short)(*(unsigned int*)(u+21)));	// packet No.
		memcpy(dat[i].mesg, u, 16);											// uuid
		pri = *(float*)(u+17);												// download priority
		if (pri==0.0) dat[i].com[2] = COM_ZERO_PRIORITY;					// zero priority

		cnt = 0;
		cc  = udp_send(csock, (char*)(dat+i), sizeof(udp_com), &addr);
		do {
			rcv = recv_udp_command(csock, &addr, 1, 0);
			cnt++;
		} while(seq!=rcv.seqnum && cnt<5 && rcv.com[0]!=COM_ERROR_TIMEOUT);

		// Cache Server is down ?
		if (rcv.com[0]==COM_ERROR_TIMEOUT) {
			Timeout_Counter++;
			if (Timeout_Counter>=5) {
				DEBUG_MODE print_message("[%d] UDP_CHECK_TEXTURE_CACHE: WARNING: Disconnected from Cache Server!!!!\n", CrntPID);
				CacheGetMode = OFF;
				// PUTサーバまで止まってしまう
				//udp_command_terminate(CacheParam.qsock, CacheParam.qaddr, CacheParam.passwd);
				n = 0;
				break;
			}
		}
		else {
			Timeout_Counter = 0;
		}

		if (seq!=rcv.seqnum && rcv.com[0]!=COM_ERROR_TIMEOUT) {
			//rcv.com[0] = COM_ERROR_SEQUENCE;
			rcv.com[1] = COM_ERROR_SEQUENCE;
			DEBUG_MODE print_message("[%d] UDP_CHECK_TEXTURE_CACHE: WARNING: Sequence Number is mismatch.\n", CrntPID);
		}
		//freeNull(passwd);

		if (rcv.com[0]==COM_TXTR_CACHE_RESULT && rcv.com[1]==COM_OK_REPLY) {
			n++;
			dat[i].com[1] = COM_OK_REPLY;						// cached
			dat[i].port   = rcv.port;
		}
	}

	///////////////////////////////////////////////////////////////
	// reconstraction of High 8 packet
	if (n>0) {
		*req = (udp_com*)malloc(sizeof(udp_com)*n);
		if (*req==NULL) {
			free(dat);
			return 0;
		}

		snd = make_Buffer(buf->vldsz);
		memcpy(snd.buf, buf->buf, pos);
		snd.buf[39] = (unsigned char)(rqno-n);

		for (i=0,j=0,m=0; i<rqno; i++) {
			if (dat[i].com[1]==COM_OK_REPLY) {
				dat[i].com[0] = COM_TXTR_CACHE_REQUEST;
				memcpy((char*)(*req+j), (char*)(dat+i), sizeof(udp_com));
				j++;
			}
			else {
				v = snd.buf  + pos + 26*m;
				u = buf->buf + pos + 26*i;
				memcpy(v, u, 26);
				if (dat[i].com[2]==COM_ZERO_PRIORITY) *(unsigned int*)(v+21) = ntohs(dat[i].port);
				m++;
			}
		}

		snd.vldsz = pos + 26*m;
		memcpy(buf->buf, snd.buf, snd.vldsz);
		buf->vldsz = snd.vldsz;
		free_Buffer(&snd);
	}
	free(dat);

	return n;
}



void  udp_request_texture_cache(int csock, udp_com* req, int n, struct sockaddr_in addr) 
{
	int  i;

	UDP_DUMP_MODE fprintf(stdout, "P->C [%d]: Request Texture Data(%d) to Cache Server.\n", CrntPID, n);

	for (i=0; i<n; i++) {
		udp_send(csock, (char*)(req+i), sizeof(udp_com), &addr);
	}
	return;
}



int   udp_send_ack_to_cache(int csock, Buffer* buf, struct sockaddr_in addr) 
{
	unsigned char* p;
	int i, no, cc;
	udp_com dat;

	p = buf->buf + 10 + buf->buf[5];
	no = (int)*(unsigned char*)(p);

	for (i=0; i<no; i++) {
		*(unsigned int*)(dat.addr) = *(unsigned int*)(p+1+4*i);
		dat.com[0] = COM_ACK_PACKET;
		cc = udp_send(csock, (char*)&dat, sizeof(udp_com), &addr);
	}
	return no;
}




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
cache_param	  exchange_info_with_cache()

	機能：キャッシュサーバと情報交換を行う．
		  通信プロトコルは順序依存．通信開始はこちらから．

	変数：
		csock: キャッシュサーバへの一時的な制御用TCP通信ソケット
		pport: キャッシュデータを送信する場合の送信口ポート番号 (PUT用)
		gport: キャッシュデータを受信する場合の受信ポート番号 (GET用)
		qport: キャッシュサーバにコマンドを発行する場合のコマンド送信口ポート

	引数：
		psock  : PUT用キャッシュデータを送信するためのUDPソケット
		gsock  : キャッシュデータを受信(GET)するためのUDPソケット
		qsock  : キャッシュサーバへコマンドを送信するためのUDPソケット

		cp_addr: PUT用キャッシュデータを受信するキャッシュサーバのポート情報
		cg_addr: キャッシュデータを送信するキャッシュサーバのポート情報（不正接続チェック用）
		cq_addr: コマンドを受信するキャッシュサーバのポート情報
		cpasswd: キャッシュサーバから発行された，コマンド送信権限確認用のパスワード
*/
cache_param	  exchange_info_with_cache()
{
	int  cc, csock;
	cache_param cparam;
	unsigned short pport,  gport,  qport;
	unsigned short pxport, gxport, qxport;
	tcp_com dat;

	csock = 0;
	pport = gport = qport = pxport = gxport = qxport = 0;
	memset((char*)&cparam, 0, sizeof(cache_param));

	csock = tcp_client_socket(CacheServerIP, CacheServerPort);

	if (csock>0) {
		pport = gport = qport = 0;
		cparam.qsock = get_valid_udp_socket(MinUdpExPort, MaxUdpExPort, &qport);
		if (CachePutMode) cparam.psock = get_valid_udp_socket(MinUdpExPort, MaxUdpExPort, &pport);
		if (CacheGetMode) cparam.gsock = get_valid_udp_socket(MinUdpImPort, MaxUdpImPort, &gport);

		// PUT用送信IP,ポートを通知
		dat.com[0] = COM_IP_PORT_REQUEST;
		memcpy(dat.addr, ToCacheIPaddrNum, 4);
		dat.port = htons(pport);			// 0の場合はキャッシュを送信しない
		cc = tcp_send(csock, (char*)&dat, sizeof(tcp_com));

		// PUT用サーバのIP,受信ポートを得る
		dat = recv_tcp_command(csock, 5, 0);
		if (CachePutMode && dat.com[0]==COM_IP_PORT_REPLY && dat.port!=0) {
			if (!bincmp(dat.addr, (unsigned char*)MyIPaddrNum, 4)) memcpy(dat.addr, LocalIPNum, 4); 
			else memcpy(dat.addr, CacheServerIPNum, 4); 	// キャッシュサーバを信用しない．
			pxport = ntohs(dat.port);
			cparam.paddr = get_sockaddr_bynum((char*)dat.addr, pxport); 
		}
		else {
			if (cparam.psock>0) close(cparam.psock);
			cparam.psock = 0;
			CachePutMode = OFF;
		}

		// GET用受信IP,ポートを通知
		dat.com[0] = COM_IP_PORT_REQUEST;
		memcpy(dat.addr, ToCacheIPaddrNum, 4);
		dat.port = htons(gport);			// 0の場合はキャッシュを受信しない
		tcp_send(csock, (char*)&dat, sizeof(tcp_com));

		// GETサーバ用送信IP,ポートを得る（確認用）
		dat = recv_tcp_command(csock, 5, 0);
		if (CacheGetMode && dat.com[0]==COM_IP_PORT_REPLY && dat.port!=0) {
			if (!bincmp(dat.addr, (unsigned char*)MyIPaddrNum, 4)) memcpy(dat.addr, LocalIPNum, 4); 
			else memcpy(dat.addr, CacheServerIPNum, 4); 
			gxport = ntohs(dat.port);
			cparam.gaddr = get_sockaddr_bynum((char*)dat.addr, gxport); 
		}
		else {
			if (cparam.gsock>0) close(cparam.gsock);
			cparam.gsock = 0;
			CacheGetMode = OFF;
		}

		// REQUEST用送信IP,ポートを通知
		dat.com[0] = COM_IP_PORT_REQUEST;
		memcpy(dat.addr, ToCacheIPaddrNum, 4);
		dat.port = htons(qport);
		cc = tcp_send(csock, (char*)&dat, sizeof(tcp_com));

		// REQUEST用サーバのIP,受信ポート，パスワードを得る
		dat = recv_tcp_command(csock, 5, 0);
		if (dat.com[0]==COM_IP_PORT_REPLY && dat.port!=0) {
			if (!bincmp(dat.addr, (unsigned char*)MyIPaddrNum, 4)) memcpy(dat.addr, LocalIPNum, 4); 
			else memcpy(dat.addr, CacheServerIPNum, 4); 
			qxport = ntohs(dat.port);
			cparam.qaddr = get_sockaddr_bynum((char*)dat.addr, qxport); 

			int len = strlen((char*)dat.pass)+1;
			cparam.passwd = (char*)malloc(len);
			memcpy(cparam.passwd, dat.pass, len);
		}
		else {
			if (cparam.psock>0) close(cparam.psock);
			if (cparam.gsock>0) close(cparam.gsock);
			if (cparam.qsock>0) close(cparam.qsock);
			cparam.psock = cparam.gsock = cparam.qsock = 0;
			CachePutMode = OFF;
			CacheGetMode = OFF;
			CacheMode	 = OFF;
		}

		socket_close(csock);
	}
	else {
		CachePutMode = OFF;
		CacheGetMode = OFF;
		CacheMode	 = OFF;
	}

	//
	if (!CachePutMode && !CacheGetMode) CacheMode = OFF;
	if (CacheMode) {
		DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_CACHE: Connected Cache Server. PutPort = %d, GetPort = %d, ReqestPort = %d\n", 
																								  CrntPID, pxport, gxport, qxport);
	}
	else {
		DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_CACHE: WARNING: can not connect Cache Server!!!\n", CrntPID);
	}

	return cparam;
}

