/*    
    Second Life Relay Server: Help 

				sl_relay_help.c v1.0  by Fumi.Iseki (C)2009
*/


#include "sl_relay_help.h"



void  sl_relay_help(FILE* fp)
{
    fprintf(fp, "\n");
    fprintf(fp, " sl_relay  ");
    fprintf(fp, "[-s server_name[:port]] [-p port] [-f config_file] [-u user_name] [-i interface_address]\n");
    fprintf(fp, "           [-i interface_address] [-lm]\n");
    fprintf(fp, "           [-pid pid_file] [-l [log_file]] [-v syslog_level]\n");
    fprintf(fp, "           [-cs [cache_server:port]] [-cg] [-cp]\n");
    fprintf(fp, "           [-is [info_server:port]] [-wf]\n");
    fprintf(fp, "           [-vs [voice_relay_server:port]]\n");
    fprintf(fp, "           [-as] [-aca] [-ano]\n");
    fprintf(fp, "           [-xp [web_proxy_server:porti]] [-ip [port]] [-ipx [port]] [-mm]\n");
    fprintf(fp, "           [-ver version]\n");
    fprintf(fp, "           [-d] [-x] [-xt] [-xu] [-xuf]\n");
    fprintf(fp, "           [--version] [--help]\n");
    fprintf(fp, "\n");

    fprintf(fp, "        -s   : specify login server of Second Life. default is login.agni.lindenlab.com:443 \n");
    fprintf(fp, "        -p   : port number that Viewer connects. default is 8100. \n");
    fprintf(fp, "        -f   : configuration file. default is /usr/local/etc/sl_proxy/sl_relay.conf \n");
    fprintf(fp, "        -u   : effective user. \n");
    fprintf(fp, "        -i   : specify Viewer side network interface IP address. \n");
    fprintf(fp, "               if your server has two or more network interfaces, you need to use this option.\n");
    fprintf(fp, "        -lm  : Set to Local Mode, when Viewer and sl_relay are executed at same PC.\n");
    fprintf(fp, "               Be careful, this option is not secure!!\n");
    fprintf(fp, "\n");

    fprintf(fp, "        -pid : specify pid file. \n");
    fprintf(fp, "        -l   : specify log file. \n");
    fprintf(fp, "        -v   : level of syslog. default is LOG_INFO (7). \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -cs  : specify sl_cache cache server. default is localhost:8200 \n");
    fprintf(fp, "        -cg  : only get  cache data. do not save data. \n");
    fprintf(fp, "        -cp  : only save cache data. do not get  data. \n");
    fprintf(fp, "\n");
    fprintf(fp, "        -txf : Texture full dwonload mode with 'HTTP Get Textures' viewer mode. (Experimental option)\n");
    fprintf(fp, "\n");

    fprintf(fp, "        -is  : specify sl_info infomation server. default is localhost:8086 \n");
    fprintf(fp, "        -wf  : the access limitation to SIM by the white list is done in cooperation with sl_info. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -vs  : specify sl_voice_relay server. default is localhost:8088 \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -as  : use HTTPS between Viewer and Relay Server. \n");
    fprintf(fp, "        -aca : confirms Second Life Server by using C:\\Program Files\\SecondLife\\app_settings\\CA.pem \n");
    fprintf(fp, "        -ano : not use HTTPS but HTTP connection with Region Server. It is for OpenSim or Aurora-Sim.\n");
    fprintf(fp, "\n");

    fprintf(fp, "        -xp  : specify external web proxy server. \n");
    fprintf(fp, "        -ip  : use internal web proxy function with full access mode. port number can be specified (default is 8080). \n");
    fprintf(fp, "        -ipx : use internal web proxy function with restricted mode.  port number can be specified (default is 8080). \n");
    fprintf(fp, "        -mm  : relay MusicURL and MediaURL(High 23). If it is possible, to use web proxy function of viewer. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -ver : rewrite Viewer version. Please use this temporarily only when you cannot immediately install new Viewer. \n");
    fprintf(fp, "\n");

    fprintf(fp, "        -d   : debug mode. display debug information. \n");
    fprintf(fp, "        -x   : TCP(HTTP/HTTPS) packets are saved at working directory and UDP packet headers are printed. \n");
    fprintf(fp, "        -xh  : TCP(HTTP/HTTPS) headers are printed. \n");
    fprintf(fp, "        -xt  : TCP(HTTP/HTTPS) packets are saved at working directory. \n");
    fprintf(fp, "        -xu  : UDP packet headers are printed. \n");
    fprintf(fp, "        -xuf : UDP packet is full dumped. \n");
    fprintf(fp, "        -xa  : All debug informations are dumped or saved.\n");
    fprintf(fp, "\n");
 
    fprintf(fp, "        --version  : display Version information. \n");
    fprintf(fp, "        --help, -h : display this Help messages. \n");
    fprintf(fp, "\n");

	return;
}


