/**  
	Second Life Relay Server: Relay Server - Infomation Server I/O Program

				sl_relay_info_io.c v1.5 by Fumi.Iseki (C)2008

*/



#include "sl_relay_info_io.h"

#include "sl_relay.h"
#include "sl_command.h"
#include "sl_udp_protocol.h"



Login_Info  LoginInformation;

tList*		RegionHandleList = NULL;
tList*		SimNameList = NULL;




/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
info_param	exchange_info_with_info(void)

	機能：
		情報サーバと情報交換を行う．
		通信プロトコルは順序依存．通信開始はこちらから．

	変数：
		gport_tcp -- 情報コマンドを受信する情報収集サーバのポート番号
		tport_tcp -- リクエストコマンドを受信する情報提供サーバのポート番号
		gport_udp -- 情報コマンドを受信する情報収集サーバのポート番号
		tport_udp -- リクエストコマンドを受信する情報提供サーバのポート番号

	戻り値：
		情報サーバと交換したネットワーク接続情報
			gsock_tcp -- 情報収集サーバと通信するHTTPSリレーコントローラーのUDPソケット
			gsock_udp -- 情報収集サーバと通信する UDP リレーコントローラーのUDPソケット
			tsock_tcp -- 情報提供サーバと通信するHTTPSリレーコントローラーのUDPソケット
			tsock_udp -- 情報提供サーバと通信する UDP リレーコントローラーのUDPソケット
			g_addr    -- 情報コマンドを受信する情報収集サーバのポート情報
			t_addr    -- リクエストコマンドを受信する情報提供サーバのポート情報
*/
info_param	exchange_info_with_info(void)
{
	int  cc, csock;
	info_param  iparam;
	unsigned short gport, tport;
	unsigned short gport_tcp, gport_udp, tport_tcp, tport_udp;
	tcp_com dat;

	csock = 0;
	gport = tport = 0;
	gport_tcp = gport_udp = tport_tcp = tport_udp = 0;
	memset(&iparam, 0, sizeof(info_param));

	csock = tcp_client_socket(InfoServerIP, InfoServerPort);
	if (csock>0) {
		iparam.gsock_tcp = get_valid_udp_socket(MinUdpExPort, MaxUdpExPort, &gport_tcp);
		iparam.gsock_udp = get_valid_udp_socket(MinUdpExPort, MaxUdpExPort, &gport_udp);
		iparam.tsock_tcp = get_valid_udp_socket(MinUdpImPort, MaxUdpImPort, &tport_tcp);
		iparam.tsock_udp = get_valid_udp_socket(MinUdpImPort, MaxUdpImPort, &tport_udp);

		// 情報収集サーバへの送信IP,ポートを通知
		dat.com[0] = COM_IP_PORT_REQUEST;
		memcpy(dat.addr, ToInfoIPaddrNum, 4);
		dat.port  = htons(gport_tcp);
		dat.prtcl = htons(gport_udp);
		cc = tcp_send(csock, (char*)&dat, sizeof(tcp_com));

		// 情報収集サーバのIP,受信ポートを得る
		dat = recv_tcp_command(csock, 5, 0);
		if (dat.com[0]==COM_IP_PORT_REPLY && dat.port!=0) {
			if (!bincmp(dat.addr, (unsigned char*)MyIPaddrNum, 4)) memcpy(dat.addr, LocalIPNum, 4); 
			else memcpy(dat.addr, InfoServerIPNum, 4); 	// 情報サーバを信用しない．
			gport = ntohs(dat.port);
			iparam.gaddr = get_sockaddr_bynum((char*)dat.addr, gport); 
		}
		else {
			if (iparam.gsock_tcp>0) close(iparam.gsock_tcp);
			if (iparam.gsock_udp>0) close(iparam.gsock_udp);
			iparam.gsock_tcp = iparam.gsock_udp = 0;
			UseInfoServer = OFF;
		}

		if (UseInfoServer) {
			// 情報提供サーバへの通信用IP,ポートを通知
			dat.com[0] = COM_IP_PORT_REQUEST;
			memcpy(dat.addr, ToInfoIPaddrNum, 4);
			dat.port  = htons(tport_tcp);
			dat.prtcl = htons(tport_udp);
			tcp_send(csock, (char*)&dat, sizeof(tcp_com));

			// 情報提供サーバとの通信用IP，ポート，パスワードを得る（確認用）
			dat = recv_tcp_command(csock, 5, 0);
			if (dat.com[0]==COM_IP_PORT_REPLY && dat.port!=0) {
				if (!bincmp(dat.addr, (unsigned char*)MyIPaddrNum, 4)) memcpy(dat.addr, LocalIPNum, 4); 
				else memcpy(dat.addr, InfoServerIPNum, 4); 
				tport = ntohs(dat.port);
				iparam.taddr = get_sockaddr_bynum((char*)dat.addr, tport); 

				int len = strlen((char*)dat.pass)+1;
				iparam.passwd = (char*)malloc(len);
				memcpy(iparam.passwd, dat.pass, len);
			}
			else {
				if (iparam.tsock_tcp>0) close(iparam.tsock_tcp);
				if (iparam.tsock_udp>0) close(iparam.tsock_udp);
				iparam.tsock_tcp = iparam.tsock_udp = 0;
				UseInfoServer = OFF;
			}

			// Agent名，ViewerのIPを通知
			dat.com[0] = COM_INFO_LOGIN_NOTIFY;
			memcpy(dat.addr, VwIPaddrNum, 4);
			int len = Min(LSNAME-1, strlen(LoginInformation.full_name)+1);
			memcpy(dat.mesg, LoginInformation.full_name, len);
			tcp_send(csock, (char*)&dat, sizeof(tcp_com));
		}
		socket_close(csock);
	}

	//
	if (UseInfoServer) {
		DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_INFO: Connected Info Server. GatherPort = %d, TenderPort = %d\n", 
																								  CrntPID, gport, tport);
		DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_INFO: Infomation Server Passwd = %s\n", CrntPID, iparam.passwd); 
	}
	else {
		DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_INFO: WARNING: can not connect Infomation Server!!!\n", CrntPID);
		freeNull(iparam.passwd);
	}

	return iparam;
}



/**
Login_Info  get_login_info(tXML* vxml, tXML* sxml)

	機能：
		ViewerのログインリクエストとSIM Serverのレスポンスからログイン情報を取り出す．

	引数：
		vxml -- Viewerのログインリクエストの XML
		sxml -- SIM Serverのレスポンスの XML

	戻り値：
		Login_Info
			Agent ID
			First Name
			Last  Name
			View  IP
			Full  Name
*/
Login_Info  get_login_info(tXML* vxml, tXML* sxml)
{
	//char*  passwd;
	tXML*  node;
	Login_Info  info;

	memset(&info, 0, sizeof(Login_Info));
	if (vxml==NULL || sxml==NULL) return info;

	//
	memcpy(info.viewer_ip, VwIPaddrNum, 4);

	node = get_xml_content_bystr(sxml, AGENT_ID_TAG);
	if (node!=NULL && node->ldat.key.buf!=NULL) memcpy(info.agent.agent_id,   node->ldat.key.buf, Min(LGUID-1, node->ldat.key.vldsz));

	node = get_xml_content_bystr(vxml, FIRST_NAME_TAG);
	if (node!=NULL && node->ldat.key.buf!=NULL) memcpy(info.agent.first_name, node->ldat.key.buf, Min(LSNAME-1, node->ldat.key.vldsz));

	node = get_xml_content_bystr(vxml, LAST_NAME_TAG);
	if (node!=NULL && node->ldat.key.buf!=NULL) memcpy(info.agent.last_name,  node->ldat.key.buf, Min(LSNAME-1, node->ldat.key.vldsz));

	// Session ID
	node = get_xml_content_bystr(sxml, SESSION_ID_TAG);
	if (node!=NULL && node->ldat.key.buf!=NULL) memcpy(info.session_id, node->ldat.key.buf, Min(LGUID-1, node->ldat.key.vldsz));

	// Full Name
	int lenf = strlen(info.agent.first_name);
	memcpy(info.full_name, info.agent.first_name, Min(LSNAME-1, lenf));
	if (lenf+1<LSNAME-1) {
		memcpy(info.full_name+lenf, " ", 1);
		int lenl = strlen(info.agent.last_name);
		memcpy(info.full_name+lenf+1, info.agent.last_name, Min(LSNAME-lenf-2, lenl));
	}

	return info;
}



/**
int  send_agent_info(int sock, struct sockaddr_in addr, Login_Info info, int com, char* passwd)

	機能：
		エージェントのログイン情報をリレーコントローラ経由で情報収集サーバに送る

	引数：
		sock   -- 通信ソケット
		addr   -- 対応するコントローラの情報
		info   -- 転送する Agentのログイン情報．内容はコピーされる．
		com    -- コマンド
		passwd -- コントローラとの接続パスワード

	戻り値：
		TRUE : 転送成功
		FALSE: 転送失敗
*/
int  send_agent_info(int sock, struct sockaddr_in addr, Login_Info info, int com, char* passwd)
{
	udp_com cmnd;

	memset(&cmnd, 0, sizeof(udp_com));
	cmnd.com[0] = com;
	memcpy(cmnd.addr, info.viewer_ip, 4);
	memcpy(cmnd.uid,  info.full_name, LSNAME-1);
	memcpy(cmnd.pass, passwd, AUTH_PASSWD_LEN+1);

	if (com==COM_INFO_SET_AGENT || com==COM_INFO_UPD_AGENT) {
		memcpy(cmnd.mesg, &(info.agent), sizeof(Agent_Info));
	}
	else if (com!=COM_INFO_DEL_AGENT) return FALSE;

	udp_send(sock, (char*)&cmnd, sizeof(udp_com), &addr);

	return TRUE;
}



/**
void   send_host_info(int sock, struct sockaddr_in addr, Login_Info info, char* hostname, char* passwd)

	機能：
		HTTPS通信を行っているSIMの FQDN情報を HTTPSリレーコントローラ経由で情報収集サーバに送る

	引数：
		sock   -- 通信ソケット
		addr   -- HTTPSコントローラの情報
		info   -- 転送する Agentのログイン情報．内容はコピーされる．
		hostname  SIMの FQDN
		passwd -- コントローラとの接続パスワード

	戻り値：なし
*/
/*
void   send_host_info(int sock, struct sockaddr_in addr, Login_Info info, char* hostname, char* passwd)
{
	udp_com  cmnd;

	if (hostname==NULL) return;

	memset(&cmnd, 0, sizeof(udp_com));
	cmnd.com[0] = COM_INFO_SET_TCP_SIM_FQDN;
	memcpy(cmnd.uid,  info.full_name, LSNAME-1);
	memcpy(cmnd.pass, passwd, AUTH_PASSWD_LEN+1);
	memcpy(cmnd.mesg, hostname, Min(COM_MESG_LEN-1, strlen(hostname)));

	udp_send(sock, (char*)&cmnd, sizeof(udp_com), &addr);
	
	return;
}
*/



/**
void   send_region_info(int sock, struct sockaddr_in addr, Login_Info login_info, Region_Info region_info, char* passwd)

	機能：
		UDP通信から取り出した SIMの情報をUDPリレーコントローラ経由で情報収集サーバに送る
		現在の取り扱いプロトコルは
			UDP_REGION_HANDSHK
			UDP_AGENT_MOVE_COMP
			UDP_SIM_STATS

	引数：
		sock   -- 通信ソケット
		addr   -- UDPコントローラの情報
		info   -- 転送する Agentのログイン情報．エージェント名の確認に使用．
		ipnum  -- SIMの IP
		buf    -- UDP通信のデータ（バイナリ）
		prtcl  -- UDP通信の種別（プロトコル）
		passwd -- コントローラとの接続パスワード

	戻り値：なし
*/
void   send_region_info(int sock, struct sockaddr_in addr, Login_Info login_info, Region_Info region_info, char* passwd)
{      
	udp_com  cmnd;
	Region_Info* rinfo;
	  
	memset(&cmnd, 0, sizeof(udp_com));
	memcpy(cmnd.uid,  login_info.full_name, LSNAME-1);
	memcpy(cmnd.pass, passwd, AUTH_PASSWD_LEN+1);

	rinfo = (Region_Info*)cmnd.mesg;
	memcpy(rinfo, &region_info, sizeof(Region_Info));
	
	if (rinfo->state & HAS_REGION_POSITION) {
		rinfo->pos_X = htonl(rinfo->pos_X);
		rinfo->pos_Y = htonl(rinfo->pos_Y);
	}

	cmnd.com[0] = COM_INFO_SET_SIM;
	udp_send(sock, (char*)&cmnd, sizeof(udp_com), &addr);
}



/**
int	  pickup_region_info(Buffer buf, int prtcl, Region_Info* region_info)

	UDPパケットから SIMの情報を取り出す．

	戻り値：
		TRUE --- 情報収集サーバへ送るべき情報が得られた．
		FALSE -- 情報収集サーバへ送るべき情報は得られなかった．
*/
int	  pickup_region_info(Buffer buf, int prtcl, Region_Info* region_info)
{	 
	if (region_info==NULL) return FALSE;

	if (prtcl==UDP_REGION_HANDSHK) {
		Buffer  id;
		char*   name;

		name = get_udp_SimName_and_UUID(buf, prtcl, &id);
		if (name!=NULL && id.buf!=NULL) {
			memcpy(region_info->sim_name, name, Min(LSNAME-1, strlen(name)));

			char* guid = (char*)uuid2guid(id.buf);
			if (guid!=NULL) memcpy(region_info->guid, guid, LGUID);
			freeNull(guid);
			region_info->access |= get_udp_SimAccess(buf, prtcl);
			region_info->state  |= HAS_REGION_NAME;
		}
		free_Buffer(&id);

		if (region_info->state&HAS_REGION_NAME && region_info->state&HAS_REGION_HANDLE) return TRUE;
	}
	  
	else if (prtcl==UDP_AGENT_MOVE_CMPL) {
		char* handle = get_udp_RegionHandle(buf, prtcl); 
		if (handle!=NULL) {
			if (bincmp((unsigned char*)region_info->handle, (unsigned char*)handle, REGION_HANDLE_LEN)) {
				if (region_info->state&HAS_REGION_HANDLE){
					 print_message("[%d] PICKUP_REGION_INFO: ------------------------- mismacth Region Handle????\n", CrntPID);
				}
				memcpy(region_info->handle, handle, REGION_HANDLE_LEN);
				region_info->state |= HAS_REGION_HANDLE;
			}
			freeNull(handle);
		}
		region_info->state |= HAS_REGION_HERE;

		return TRUE;
	}

	else if (prtcl==UDP_SIM_STATS) {
		if (!(region_info->state & HAS_REGION_POSITION)) {
			get_udp_SimPosition(buf, prtcl, &region_info->pos_X, &region_info->pos_Y);
			region_info->state |= HAS_REGION_POSITION;
			return TRUE;
		}
	}

	return FALSE;
}




//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

/**
char*  get_sim_name_byhandle(int sock, struct sockaddr_in addr, char* handle, char* passwd)

	機能：

	引数：
	
	戻り値：
*/
char*  get_sim_name_byhandle(int sock, struct sockaddr_in addr, char* handle, char* passwd)
{
	unsigned int seq;
	char* sim_name = NULL;
	int   cc;
	udp_com dat;

	if (handle==NULL) return NULL;

	seq = RequestSeqNum++;
	memset(&dat, 0, sizeof(udp_com));
	dat.com[0] = COM_INFO_GET_NAME_BYHNDL;
	dat.seqnum = seq;
	memcpy(dat.mesg, handle, REGION_HANDLE_LEN);
	memcpy(dat.pass, passwd, AUTH_PASSWD_LEN+1);

	udp_send(sock, (char*)&dat, sizeof(udp_com), &addr);
	cc = udp_recv(sock, (char*)&dat, sizeof(udp_com), &addr);

	if (cc>0 && seq==dat.seqnum) {
		if (dat.com[0]==COM_INFO_GET_NAME_REPLY) {
			if (dat.com[1]==COM_OK_REPLY) {
				sim_name = (char*)malloc(strlen(dat.mesg)+1);
				memcpy(sim_name, dat.mesg, strlen(dat.mesg)+1);
			}
		}
		else DEBUG_MODE print_message("[%d] GET_SIM_NAME_BYHANDLE: But response. com = 0x%02x\n", CrntPID, dat.com[0]);
	}
	else if (seq!=dat.seqnum) {
		DEBUG_MODE print_message("[%d] GET_SIM_NAME_BYHANDLE: Sequence number mismatch. %d != %d\n", CrntPID, seq, dat.seqnum);
	}
	else {
		DEBUG_MODE print_message("[%d] GET_SIM_NAME_BYHANDLE: Not response. cc = %d\n", CrntPID, cc);
	}

	return sim_name;
}




//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//

/**
int  get_sim_white_byhandle(int sock, struct sockaddr_in addr, char* handle, char* passwd)

	機能：

	引数：
	
	戻り値：
*/
int  get_sim_white_byhandle(int sock, struct sockaddr_in addr, char* handle, char* passwd)
{
	unsigned int seq;
	int     cc;
	udp_com dat;

	if (handle==NULL) return UNKNOWN;

	seq = RequestSeqNum++;
	memset(&dat, 0, sizeof(udp_com));
	dat.com[0] = COM_INFO_GET_WHITE_BYHNDL;
	dat.seqnum = seq;
	memcpy(dat.mesg, handle, REGION_HANDLE_LEN);
	memcpy(dat.pass, passwd, AUTH_PASSWD_LEN+1);

	udp_send(sock, (char*)&dat, sizeof(udp_com), &addr);
	cc = udp_recv(sock, (char*)&dat, sizeof(udp_com), &addr);

	if (cc>0 && seq==dat.seqnum) {
		if (dat.com[0]==COM_INFO_GET_WHITE_REPLY) {
			if 		(dat.com[1]==COM_OK_REPLY) return TRUE;
			else if (dat.com[1]==COM_NG_REPLY) return FALSE;
		}
		else {
			DEBUG_MODE print_message("[%d] GET_SIM_WHITE_BYHANDLE: But response. com = 0x%02x\n", CrntPID, dat.com[0]);
		}
	}
	else if (seq!=dat.seqnum) {
		DEBUG_MODE print_message("[%d] GET_SIM_WHITE_BYHANDLE: Sequence number mismatch. %d != %d\n", CrntPID, seq, dat.seqnum);
	}
	else {
		DEBUG_MODE print_message("[%d] GET_SIM_WHITE_BYHANDLE: Not response. cc = %d\n", CrntPID, cc);
	}

	return UNKNOWN;
}



/**
int  get_sim_white_byname(int sock, struct sockaddr_in addr, char* name, char* passwd)

	機能：

	引数：
	
	戻り値：
*/
int  get_sim_white_byname(int sock, struct sockaddr_in addr, char* name, char* passwd)
{
	unsigned int seq;
	int     cc;
	udp_com dat;

	if (name==NULL) return FALSE;

	seq = RequestSeqNum++;
	memset(&dat, 0, sizeof(udp_com));
	dat.com[0] = COM_INFO_GET_WHITE_BYNAME;
	dat.seqnum = seq;
	memcpy(dat.mesg, name, Min(COM_MESG_LEN-1, strlen(name)+1));
	memcpy(dat.pass, passwd, AUTH_PASSWD_LEN+1);

	udp_send(sock, (char*)&dat, sizeof(udp_com), &addr);
	cc = udp_recv(sock, (char*)&dat, sizeof(udp_com), &addr);

	if (cc>0 && seq==dat.seqnum) {
		if (dat.com[0]==COM_INFO_GET_WHITE_REPLY) {
			if 		(dat.com[1]==COM_OK_REPLY) return TRUE;
			else if (dat.com[1]==COM_NG_REPLY) return FALSE;
		}
		else {
			DEBUG_MODE print_message("[%d] GET_SIM_WHITE_BYNAME: But response. com = 0x%02x\n", CrntPID, dat.com[0]);
		}
	}
	else if (seq!=dat.seqnum) {
		DEBUG_MODE print_message("[%d] GET_SIM_WHITE_BYNAME: Sequence number mismatch. %d != %d\n", CrntPID, seq, dat.seqnum);
		return UNKNOWN;
	}
	else {
		DEBUG_MODE print_message("[%d] GET_SIM_WHITE_BYNAME: Not response. cc = %d\n", CrntPID, cc);
	}

	return UNKNOWN;
}



/**
udp_com	  get_region_info_from_tender(int sock, struct sockaddr_in* addr, udp_com dat, char* passwd)

	機能：
		リレーコントローラによる，リレープロセスから情報提供サーバへの問い合わせの中継．
*/
udp_com	  get_region_info_from_tender(int sock, struct sockaddr_in* addr, udp_com dat, char* passwd)
{
	udp_com cmnd;

	/////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Sim Name
	//
	if (dat.com[0]==COM_INFO_GET_NAME_BYHNDL) {
		memcpy(dat.pass, passwd, AUTH_PASSWD_LEN+1);
		udp_send(sock, (char*)&dat, sizeof(udp_com), addr);
		int cc = udp_recv(sock, (char*)&cmnd, sizeof(udp_com), addr);

		if (cc<=0 || dat.seqnum!=cmnd.seqnum) {
			memset(&cmnd, 0, sizeof(udp_com));
			cmnd.com[0] = COM_INFO_GET_NAME_REPLY;
			cmnd.com[1] = COM_NG_REPLY;
			cmnd.seqnum = dat.seqnum;
		}
		return cmnd;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////
	// White List
	//
	if (RegionHandleList==NULL) RegionHandleList = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, NULL, NULL, 0);
	if (SimNameList==NULL) SimNameList = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, NULL, NULL, 0);

	if (dat.com[0]==COM_INFO_GET_WHITE_BYHNDL) {
		tList* pp = RegionHandleList->next;
		while (pp!=NULL) {
			if (!bincmp(pp->ldat.ptr, (unsigned char*)dat.mesg, REGION_HANDLE_LEN)) break;
			pp = pp->next;
		}

		if (pp!=NULL) {	// キャッシュにヒット
			DEBUG_MODE print_message("[%d] GET_SIM_INFO_FROM_TENDER: Region Handle List is Hitted.\n", CrntPID);
			memset(&cmnd, 0, sizeof(udp_com));
			cmnd.com[0] = COM_INFO_GET_WHITE_REPLY;
			cmnd.com[1] = (unsigned char)pp->ldat.lv;
			cmnd.seqnum = dat.seqnum;
			return cmnd;
		}

		// 情報サーバに問い合わせ．
		memcpy(dat.pass, passwd, AUTH_PASSWD_LEN+1);
		udp_send(sock, (char*)&dat, sizeof(udp_com), addr);
		int cc = udp_recv(sock, (char*)&cmnd, sizeof(udp_com), addr);

		if (cc>0 && dat.seqnum==cmnd.seqnum) {
			if (cmnd.com[0]==COM_INFO_GET_WHITE_REPLY && (cmnd.com[1]==COM_OK_REPLY || cmnd.com[1]==COM_NG_REPLY)) {
				tList* end_p = find_tList_end(RegionHandleList);
				add_tList_node_bystr(end_p, 0, cmnd.com[1], NULL, NULL, (void*)dat.mesg, REGION_HANDLE_LEN);
				RegionHandleList->ldat.id++;
				check_list_limitsize(RegionHandleList, FILTER_LIST_MAX, (int)(FILTER_LIST_MAX*FILTER_LIST_DEL_RATE));
				return cmnd;
			}
		}

		memset(&cmnd, 0, sizeof(udp_com));
		cmnd.com[0] = COM_INFO_GET_WHITE_REPLY;
		cmnd.com[1] = COM_UNKNOWN_REPLY;
		cmnd.seqnum = dat.seqnum;
	}

	else if (dat.com[0]==COM_INFO_GET_WHITE_BYNAME) {
		tList* pp = strncasecmp_tList(SimNameList, dat.mesg, 0, 1);

		if (pp!=NULL) {	// キャッシュにヒット
			DEBUG_MODE print_message("[%d] GET_SIM_INFO_FROM_TENDER: SIM Name List is Hitted. [%s]\n", CrntPID, dat.mesg);
			memset(&cmnd, 0, sizeof(udp_com));
			cmnd.com[0] = COM_INFO_GET_WHITE_REPLY;
			cmnd.com[1] = (unsigned char)pp->ldat.lv;
			cmnd.seqnum = dat.seqnum;
			return cmnd;
		}

		// 情報サーバに問い合わせ．
		memcpy(dat.pass, passwd, AUTH_PASSWD_LEN+1);
		udp_send(sock, (char*)&dat, sizeof(udp_com), addr);
		int cc = udp_recv(sock, (char*)&cmnd, sizeof(udp_com), addr);

		if (cc>0 && dat.seqnum==cmnd.seqnum) {
			if (cmnd.com[0]==COM_INFO_GET_WHITE_REPLY && (cmnd.com[1]==COM_OK_REPLY || cmnd.com[1]==COM_NG_REPLY)) {
				tList* end_p = find_tList_end(SimNameList);
				add_tList_node_bystr(end_p, 0, cmnd.com[1], dat.mesg, NULL, NULL, 0);
				SimNameList->ldat.id++;
				check_list_limitsize(SimNameList, FILTER_LIST_MAX, (int)(FILTER_LIST_MAX*FILTER_LIST_DEL_RATE));
				return cmnd;
			}
		}

		memset(&cmnd, 0, sizeof(udp_com));
		cmnd.com[0] = COM_INFO_GET_WHITE_REPLY;
		cmnd.com[1] = COM_UNKNOWN_REPLY;
		cmnd.seqnum = dat.seqnum;
	}

	return cmnd;
}



void	reset_simname_cache()
{
	del_tList(&SimNameList);
	SimNameList = add_tList_node_bystr(NULL, 0, 0, LIST_ANCHOR, NULL, NULL, 0);
}



