/**  
	Second Life Relay Server: Relay Server - Voice Relay Server I/O Program

				sl_relay_voice_io.c v1.0 by Fumi.Iseki (C)2010
*/



#include "sl_relay_voice_io.h"

#include "sl_relay.h"
#include "sl_tools.h"
#include "sl_command.h"





/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//

/**
voice_param	exchange_info_with_voice(void)

	機能：
		Voice Relayサーバと情報交換を行う．
		通信プロトコルは順序依存．通信開始はこちらから．

	変数：

	戻り値：
		Voice Relayサーバと交換したネットワーク接続情報
*/
voice_param	exchange_info_with_voice(void)
{
	int  cc, csock;
	voice_param vparam;
	unsigned short cport;
	tcp_com dat;

	memset(&vparam, 0, sizeof(voice_param));
	DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_VOICE: Connect to Voice Relay Server (%s:%d).\n", CrntPID, VoiceServerIP, VoiceServerPort);

	csock = tcp_client_socket(VoiceServerIP, VoiceServerPort);
	if (csock>0) {
		// 情報通知先，Vivoxアカウントサーバ中継への接続先
		dat.com[0] = COM_IP_PORT_REQUEST;
		cc = tcp_send(csock, (char*)&dat, sizeof(tcp_com));

		dat = recv_tcp_command(csock, 5, 0);
		if (dat.com[0]==COM_IP_PORT_REPLY && dat.port!=0) {
			if (!bincmp(dat.addr, (unsigned char*)MyIPaddrNum, 4)) memcpy(dat.addr, LocalIPNum, 4); 
			else memcpy(dat.addr, VoiceServerIPNum, 4); 	// Voice Relayサーバを信用しない．

			cport = ntohs(dat.port);
			vparam.iaddr = get_sockaddr_bynum((char*)dat.addr, cport);

			Buffer buf = make_Buffer_bystr(dat.mesg);
			vparam.account_url = (char*)buf.buf; 

			int len = strlen((char*)dat.pass) + 1;
			vparam.passwd = (char*)malloc(len);
			memcpy(vparam.passwd, dat.pass, len);
		}
		else {
			UseVoiceServer = OFF;
		}

		socket_close(csock);
	}
	else {
		DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_VOICE: socket open error!!\n", CrntPID); 
		UseVoiceServer = OFF;
	}

	//
	if (UseVoiceServer) {
		DEBUG_MODE {
			print_message("[%d] EXCHANGE_INFO_WITH_VOICE: Information Send Port = %d\n", CrntPID, ntohs(vparam.iaddr.sin_port));
			print_message("[%d] EXCHANGE_INFO_WITH_VOICE: Account Relay Server  = %s\n", CrntPID, vparam.account_url);
			print_message("[%d] EXCHANGE_INFO_WITH_VOICE: Voice Server Password = %s\n", CrntPID, vparam.passwd); 
		}
	}
	else {
		DEBUG_MODE print_message("[%d] EXCHANGE_INFO_WITH_VOICE: WARNING: error occurred in connect to Voice Relay Server!!!\n", CrntPID);
		freeNull(vparam.account_url);
		freeNull(vparam.passwd);
		memset(&vparam, 0, sizeof(voice_param));
	}

	return vparam;
}



int   voice_account_sip_tag(tXML* xml, tList* lac, voice_param vparam)
{
	int vsock;
	unsigned short vport;
	udp_com dat;
	Buffer  apidir;

	if (xml==NULL || xml->next==NULL || lac==NULL || lac->altp==NULL) return FALSE;

	Buffer act_srvr = dup_Buffer(lac->altp->ldat.key);
	decomp_url(act_srvr, NULL, NULL, NULL, NULL, &apidir);

	copy_s2Buffer(vparam.account_url, &(lac->altp->ldat.key));
	if (apidir.buf!=NULL) cat_Buffer(&apidir, &(lac->altp->ldat.key));
	free_Buffer(&apidir);

	vsock = get_valid_udp_socket(MinUdpExPort, MaxUdpExPort, &vport);

	memset(&dat, 0, sizeof(udp_com));
	dat.com[0] = COM_VOICE_SET_ACCNT_SVR;
	memcpy(dat.mesg, (char*)act_srvr.buf, Min(act_srvr.vldsz, COM_MESG_LEN));
	memcpy(dat.pass, vparam.passwd, strlen(vparam.passwd));
	udp_send(vsock, (char*)&dat, sizeof(udp_com), &vparam.iaddr);

	free_Buffer(&act_srvr);
	socket_close(vsock);

	return TRUE;
}



