/**
	Second Life Relay Server: TCP(HTTP/HTTPS) Transform Program Header

				sl_tcp_transform.h v1.5  by Fumi.Iseki (C)2007
*/



#ifndef  __SL_TCP_TRANSFORM_H_
#define  __SL_TCP_TRANSFORM_H_


#include "network.h"
#include "buffer.h"
#include "txml.h"

#include "sl_xml_tag.h"


extern char* MyIPaddr;


#define SL_HTTP_CLOSE			"LLAgentCommunication::closeCommunication"
#define SL_NOT_FOUND			"Not Found"


// Process
#define  RELAY_PROCESS			0		// そのまま転送．またはその場限りの書き換え
#define  LOGIN_PROCESS			1		// ログインプロセス
#define  TRANS_PROCESS			2		// パケットを書き換えた
#define  END_PROCESS			-998	// 切断命令を受信
#define  FAIL_PROCESS			-1		// 書き換えに失敗





//////////////////////////////////////////////////////////////////////////
// Functions

int 	transform_login_xml(tXML* xml, char** svrip, unsigned short* sport, unsigned short vport,
									   char** hname, unsigned short* hport, unsigned short tport, 
									   char** mname, unsigned short* mport, unsigned short nport,
									   char** aname, unsigned short* aport, unsigned short uport, char* ipaddr);

int  	transform_cap_xml(tXML* xml, char* recvfn, char* ipaddr, int tsock, struct sockaddr_in ut_addr, 
																 int usock, struct sockaddr_in uu_addr, char* passwd);

int  	seed_cap_url_multi_tag	 (tXML* xml, tList* lip, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);
int  	seed_cap_region_multi_tag(tXML* xml, tList* lip, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);
int		sim_ipport_multi_tag	 (tXML* xml, tList* lip, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);
int		sim_ip_port_b64_multi_tag(tXML* xml, tList* lip, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);
int		sim_info_ip_port_b64_multi_tag(tXML* xml, tList* lip, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);


int  	seed_cap_url_all_tag(tXML* xml, tXML*   url, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);
int  	seed_cap_url_tag	(tXML* xml, Buffer* url, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);
int  	seed_cap_region_tag	(tXML* xml, Buffer* url, Buffer* hndl, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);
int  	sim_ipport_tag		(tXML* xml, Buffer* ip,  char* ipaddr, int usock, struct sockaddr_in uu_addr, char* passwd);
int  	sim_ip_port_b64_tag (tXML* xml, Buffer* ip,  Buffer* port, Buffer* hndl, char* ipaddr, int usock, struct sockaddr_in uu_addr, char* passwd);

unsigned short  seed_cap_url_query(Buffer* url, Buffer* srvurl, char* handle, char* ipaddr, int tsock, struct sockaddr_in ut_addr, char* passwd);




#endif
