/**  
  Second Life Relay Server: Tools Program 	

				sl_tools v1.5  by Fumi.Iseki (C)2007
*/


#include "sl_tools.h"
#include "https_tool.h"




pid_t  CrntPID = 0;




//////////////////////////////////////////////////////////////////////////
//
// HTTP/HTTPS 
//

/**
tList*  make_text_contents_header(tList* pl)

	機能：
		サーバから gzip形式でファイルが送られてきた時に，ヘッダの Content-type を text/xml 
		に書き直すために使用する．
*/
tList*  make_text_contents_header(tList* pl)
{
	tList* pt=NULL;
	tList* pp;
	Buffer dat;

	dat = search_protocol_header(pl, HDLIST_FIRST_LINE_KEY, 1);
	pp  = pt = add_tList_node_str(pt, HDLIST_FIRST_LINE_KEY, (char*)dat.buf);
	free_Buffer(&dat);

	dat = search_protocol_header(pl, "Server", 1);
	pt  = add_tList_node_str(pt, "Server", (char*)dat.buf);
	free_Buffer(&dat);

	dat = search_protocol_header(pl, "Date", 1);
	pt  = add_tList_node_str(pt, "Date", (char*)dat.buf);
	free_Buffer(&dat);

	pt  = add_tList_node_str(pt, "Content-type", "text/xml");
	pt  = add_tList_node_str(pt, "Content-Length", "0");
	pt  = add_tList_node_str(pt, "Connection", "close");

	return pp;
}




///////////////////////////////////////////////////////////////////////////////////
//
// tList
//

/**
unsigned short  search_relay_tList(tList* pl, char* ip, unsigned short port)

	機能：
		SIMのIPアドレスとポート番号をキーにして，対応する中継プログラムのViewer側ポート番号を返す．
		データが存在しない場合は 0を返す．

		プロセスリストに対しても使用可能．プロセスリストの場合は プロセスIDを返す．
*/
int   search_relay_list(tList* pl, char* ip, unsigned short port)
{
	if (pl==NULL) return 0;

	pl = pl->next;
	while (pl!=NULL) {
		if (pl->ldat.id==(int)port && !strcmp((char*)pl->ldat.key.buf, ip)) {
			return pl->ldat.lv;
		}
		pl = pl->next;
	}

	return 0;
}



/**
int  del_relay_list(tList* pl, char* ip, unsigned short port)

	機能：
		SIMのIPアドレスとポート番号をキーにして，リストから削除
		戻り値は削除した中継プロセスのViewer側ポート番号

		プロセスリストに対しても使用可能．プロセスリストの場合は プロセスIDを返す．
*/
int  del_relay_list(tList* pl, char* ip, unsigned short port)
{
	int ret;
	tList* pp;

	if (pl==NULL) return 0;

	DEBUG_MODE print_message("[%d] DEL_RELAY_LIST: called with %s:%d\n", CrntPID, ip, port);

	pp = pl->next;
	while (pp!=NULL) {
		if (pp->ldat.id==(int)port && !strcmp((char*)pp->ldat.key.buf, ip)) {
			ret = pp->ldat.lv;
			del_tList_node(pp);
			pl->ldat.id--;		// 項目の数
			return ret;
		}
		pp = pp->next;
	}

	return 0;
}



/**
char* del_process_list(tList* pl, int pid, int* port)

	機能：
		プロセスIDをキーにして，リストから削除

	戻り値：
		*port -- 削除したノードの id. 通常は転送先のポート番号
		return - 削除したノードの key.buf. 通常は転送先のサーバ名
*/
char* del_process_list(tList* pl, int pid, int* port)
{
	tList* pp;
	Buffer sim;

	if (pl==NULL) return NULL;
	if (port!=NULL) *port = 0;
	sim = init_Buffer();

	DEBUG_MODE print_message("[%d] DEL_PROCESS_LIST: called with %d\n", CrntPID, pid);
	pp = pl;
	while (pp!=NULL) {
		if (pp->ldat.lv==(int)pid) {
			if (pp==pl) pp->ldat.lv = 0;	// アンカー中に入れた特別プロセス
			else {
				if (port!=NULL) {
					*port = pp->ldat.id;
					sim = dup_Buffer(pp->ldat.key);
				}
				del_tList_node(pp);
				pl->ldat.id--;				// 項目の数
			}
			break;
		}
		pp = pp->next;
	}

	//DEBUG_MODE print_message("[%d] DEL_PROCESS_LIST: delete with %s:%d [%d]\n", CrntPID, sim.buf, *port, pid);
	return (char*)sim.buf; 
}




//////////////////////////////////////////////////////////////////////////
//
// Etc
//

void   clean_work_file(char* dir, int flen)
{
	struct dirent* ent;
	DIR*   drp;
	char*  flnm;
	int	dlen;

	if (dir==NULL || flen<=0) return;

	dlen = strlen(dir);
	flnm = (char*)malloc(dlen+flen+1);
	if (flnm==NULL) return;

	memset(flnm, 0, dlen+flen+1);
	memcpy(flnm, dir, dlen);

	drp = opendir(dir);
	if(drp) {
		while((ent=readdir(drp))) {
			if ((int)strlen(ent->d_name)==flen) {
				memcpy(flnm+dlen, ent->d_name, flen);
				unlink(flnm);
			}
		}
	}
	closedir(drp);

	free(flnm);
}



void  expire_list(tList* pp, unsigned int expire)
{
	unsigned int tm;

	if (pp==NULL || expire<=0) return;

	tm = (unsigned int)time(NULL);

	if (!strcmp((char*)pp->ldat.key.buf,  LIST_ANCHOR)) pp = pp->next;		// アンカーシフト
	while (pp!=NULL) {
		if (tm-(unsigned int)pp->ldat.lv>=expire) {
			pp = del_tList_node(pp);
		}
		else pp = pp->next;
	}
}



/**
void  check_list_limitsize(tList* plist, int maxnum, int delnum)

	機能：アンカー付きリストの上限サイズのチェック
*/
void  check_list_limitsize(tList* plist, int maxnum, int delnum)
{
	if (plist==NULL) return;
	if (strncmp((char*)plist->ldat.key.buf, LIST_ANCHOR, strlen(LIST_ANCHOR))) {
		print_message("[%d] CHECK_LIST_LIMITSIZE: this tList has not LIST_ANCHOR!!", CrntPID);
		return;
	}

	if (plist->ldat.lv >= maxnum) {
		int i = 0;
		tList* pp = plist->next;

		while(pp!=NULL && i<delnum) {
			pp = del_tList_node(pp);
			i++;
		}
		plist->ldat.lv -= i;
	}

	DEBUG_MODE print_message("[%d] CHECK_LIST_LIMITSIZE: number of list = %d/%d\n", CrntPID, plist->ldat.lv, maxnum);
}



/**

*/
void   get_uint_from_RegionHandle(char* handle, unsigned int* x, unsigned int* y)
{
	if (x==NULL || y==NULL) return;

	*x = *y = 0;
	if (handle==NULL) return;
	*x = *(unsigned int*)handle;
	*x = ntohl(*x)/256;
	*y = *(unsigned int*)(handle+4);
	*y = ntohl(*y)/256;

	return;
}



/*
void  backup_temp_file(char* fmfn, char* tofn, char* ext, int tmon)

	機能：
		ファイル fmfn を tofn.ext の名前でバックアップする．
		tmon!=0 の場合は，[unix time].tofn.ext の形のファイル名になる．

	戻り値：保存ファイル名（パスを含む）から拡張子を取り除いた部分
*/
Buffer  backup_temp_file(char* fmfn, char* tofn, char* ext, int tmon)
{
	Buffer buf = init_Buffer();

	if (fmfn!=NULL) {
		Buffer bkup = make_Buffer(LNAME);

		if (tofn!=NULL) copy_s2Buffer(tofn, &bkup);
		else			copy_s2Buffer(fmfn, &bkup);

		if (tmon!=0) {
			char str[LMNAME];
			struct timeval tv;
			gettimeofday(&tv, NULL);
			snprintf(str, LMNAME-1, "%lu.%06u.", (unsigned long int)tv.tv_sec, (unsigned int)tv.tv_usec);

			char*  fnp = get_file_name((char*)bkup.buf);
			Buffer fnm = make_Buffer_bystr(fnp);
			*fnp = '\0';
			recalc_strlen_Buffer(&bkup);

			cat_s2Buffer(str, &bkup);
			cat_Buffer(&fnm, &bkup);
			free_Buffer(&fnm);
		}
		buf = dup_Buffer(bkup);

		cat_s2Buffer(".", &bkup);
		cat_s2Buffer(ext, &bkup);
		file_from_to(fmfn, (char*)bkup.buf, "w");

		DEBUG_MODE print_message("[%d] BACKUP_TEMP_FILE: saved file %s\n", CrntPID, (char*)bkup.buf);
		free_Buffer(&bkup);
	}

	return buf;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Function for HTTP/HTTPS
//

Buffer   make_relay_url(char* ip, unsigned short port, char* dir, int use_ssl)
{
	Buffer url;

	if (use_ssl) url = comp_url("https", ip, port, dir);
	else 		 url = comp_url("http",  ip, port, dir);

	return url;
}




///////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Texture
//

/**
void  set_texture_full_download(tList* pl)

	機能：
		HTTP Get Textures 機能で，テクスチャを強制的にダウンロードするように，リクエストヘッダ
		を書き換える．
*/
void  set_texture_full_download(tList* pl)
{
	Buffer buf = search_protocol_header_value(pl, HDLIST_FIRST_LINE_KEY, "GET ", 1);
	if (buf.buf!=NULL) {
		char* pos = strstrcase((const char*)buf.buf, "/?texture_id=");
		if (pos!=NULL) {
			replace_protocol_header(pl, "Range", 1, "0-599", "0-33554431");
		}
		free_Buffer(&buf);
	}
}






