/**
	Second Life Relay Server: SL UDP Header File

				sl_udp.h v1.5  by Fumi.Iseki (C)2007
*/


#ifndef  __SL_UDP_H_
#define  __SL_UDP_H_



#include  "network.h"
#include  "buffer.h"


// 転送元先の指定
#define  Send_P2V_ACK           1   // リレーサーバが Viewerへ ACKを返す
#define  Send_S2V               2
#define  Send_C2V               3
#define  Send_P2S_ACK           4   // リレーサーバが SIMへ ACKを返す
#define  Send_V2S               5
#define  Send_J2S               6
#define  Send_P2V_DISABLESIM    7
#define  Send_P2S_LOGOUTREQUEST 8



//////////////////////////////////////////////////////////////////////////
// Functions

void	udp_relay_controller(int usock, unsigned short tport, unsigned short uport, char* passwd);
void	udp_relay_controller_term(int sig);
void	udp_relay_term(int sig);

void	fork_udp_relay(char* svrip, unsigned short portn, unsigned short tport, unsigned short uport, char* handle, char* passwd,
									unsigned short* vport, unsigned short* sport, pid_t* pid);
void   	udp_relay(struct sockaddr_in sa_addr, int vsock, int ssock, unsigned short tport, unsigned short uport, char* handle, char* passwd);

void	send_udp_message_toViewer(int vsock, Buffer buf, struct sockaddr_in vw_addr, int mode);
void	send_udp_message_toServer(int vsock, Buffer buf, struct sockaddr_in vw_addr, int mode);


#endif


