/** 
	Second Life Relay Server: UDP Protocol Program Header

				sl_udp_protocol.h v1.5  by Fumi.Iseki (C)2007
*/



#ifndef  __SL_UDP_PROTOCOL_H_
#define  __SL_UDP_PROTOCOL_H_


#include "network.h"
#include "buffer.h"




// プロトコルヘッダ種別
#define  MSG_APPENDED_ACKS		0x10 
#define  MSG_RESENT				0x20 
#define  MSG_RELIABLE			0x40 
#define  MSG_ZEROCODED			0x80



// プロトコル種別
// 内容の変換処理対象のUDPプロトコルは正数にする．2octetの範囲で指定する．
#define  UDP_PACKET_ACK			1		// Fixed FB PacketAck
#define  UDP_ENABLE_SIM			2		// Low 151  EnableSimulator
#define  UDP_CROSS_REGION	   	3		// Med  7   CrossedRegion
#define  UDP_TELP_FINISH		4		// Low  69  TeleportFinish
#define  UDP_KICK_USER		  	5		// Low 163  KickUser
#define  UDP_PARCEL_PROPER	  	6 		// Low 198  ParcelPropertiesUpdate

#define  PRTCL_NOT_TREAT	  	0  
#define  UDP_NOT_TREAT		  	0  
#define  UDP_DISABLE_SIM		-1		// Low 152  DisableSimulator
#define  UDP_LOGOUT_REPLY	   	-2		// Low 253  LogoutReply
#define  UDP_SAVE_INVENT		-3		// Low 272  SaveAssetIntoInventory
#define  UDP_REGION_HANDSHK	 	-4		// Low 148  RegionHandshake
#define  UDP_AGENT_MOVE_CMPL 	-5		// Low 250  AgentMovementComplete
#define  UDP_MAP_BLOCK_REPLY 	-6		// Low 409  MapBlockReply
#define  UDP_SIM_STATS			-7		// Low 140  SimStats




//////////////////////////////////////////////////////////////////////////
// Functions

int		check_udp_relay_packet(Buffer buf, int* pos, int* alt);

Buffer 	udp_send_ack(int csock, Buffer* buf, struct sockaddr_in addr, unsigned int seq);
Buffer	udp_send_disableSim(int csock, struct sockaddr_in addr, unsigned int seq);
Buffer	udp_send_logoutRequest(int csock, Login_Info info, struct sockaddr_in addr, unsigned int seq);


char*	get_udp_SimName_and_UUID(Buffer buf, int prtcl, Buffer* id);
char*	get_udp_RegionHandle(Buffer buf, int prtcl);
unsigned char 	get_udp_SimAccess(Buffer buf, int prtcl);
void  	get_udp_SimPosition(Buffer buf, int prtcl, int* px, int* py);



////////////////////////////////////////////////
// Packet Check

int  	is_udp_append_ack(Buffer buf);
int  	is_udp_zerocoded(Buffer buf);
int  	is_udp_ack_packet(Buffer buf);
int  	is_udp_teleport_start(Buffer buf);
int  	is_udp_teleport_end(Buffer buf);
int  	is_udp_teleport_failed(Buffer buf);
int  	is_udp_texture_request(Buffer buf);
int  	is_udp_image_data_packet(Buffer buf);
int  	is_udp_update_simulator(Buffer buf);
int  	is_udp_start_ping_check(Buffer buf);
int  	is_udp_low_protocol(int n, Buffer buf);

void  	print_udp_protocol(FILE*fp, Buffer buf);


#endif

