
/** 
 	SecondL ife Relay Server: UDP Packet Transform Program

				sl_udp_transfor.h v1.5  by Fumi.Iseki (C)2007
*/


#ifndef  __SL_UDP_TRANSFORM_H_
#define  __SL_UDP_TRANSFORM_H_


#include "network.h"
#include "buffer.h"



/*
// 内容の変換処理対象のUDPプロトコルは正数にする．by sl_udp_protocol.h
#define  UDP_PACKET_ACK			1
#define  UDP_ENABLE_SIM			2
#define  UDP_CROSS_REGION		3
#define  UDP_TELP_FINISH		4
#define  UDP_KICK_USER			5
#define  UDP_PARCEL_PROPER  	6 

#define  UDP_NOT_TREAT			0  
#define  UDP_DISABLE_SIM		-1
#define  UDP_LOGOUT_REPLY		-2
#define  UDP_SAVE_INVENT		-3
#define  UDP_REGION_HANDSHK		-4
*/


#define  TRANSFORM_VALID		0x00
#define  TRANSFORM_INVALID  	0x01




//////////////////////////////////////////////////////////////////////////
// 送受信中のパケットの本来のシーケンス番号
extern unsigned int  udp_fromInject_SeqNum;
extern unsigned int  udp_fromViewer_SeqNum;
extern unsigned int  udp_fromServer_SeqNum;
extern unsigned int  udp_fromCache_SeqNum;
extern unsigned int  udp_toServer_SeqNum;
extern unsigned int  udp_toViewer_SeqNum;

// 直前に送受信したパケットの本来のシーケンス番号
extern unsigned int  udp_fromInject_SeqNum_pre;
extern unsigned int  udp_fromViewer_SeqNum_pre;
extern unsigned int  udp_fromServer_SeqNum_pre;
extern unsigned int  udp_fromCache_SeqNum_pre;
extern unsigned int  udp_toServer_SeqNum_pre;
extern unsigned int  udp_toViewer_SeqNum_pre;


// シーケンス番号の変換テーブル
//	V2S_index_V : Viewer->SIMの場合に Viewerからの SEQ No.に対する，変換後のSIMへの SEQ No.
//	V2S_index_S : Viewer->SIMの場合に SIMにへの SEQ No.に対する，変換前の Viewerからの SEQ No.
/*
extern unsigned int  V2S_index_S[LST_SZ];
extern unsigned int  V2S_index_V[LST_SZ];
extern unsigned int  S2V_index_S[LST_SZ];
extern unsigned int  S2V_index_V[LST_SZ];
extern unsigned int  C2V_index_V[LST_SZ];
extern unsigned int  C2V_index_C[LST_SZ];
extern unsigned int  J2S_index_J[LST_SZ];
extern unsigned int  J2S_index_S[LST_SZ];
*/


/*
S2V_ack_valid[udp_toServer_SeqNum] : udp_toServer_SeqNum のパケット(V->S)へのパケットの返答(S->V)が有効かどうかを設定する．

High 8 のパケットが Cache Serverと SIM宛てに分裂した場合，このパケットへの ACKはリレーサーバが返すので，
SIMから ACKが返って来た場合はリレーサーバがブロックする．sl_relay_cache_io.c で設定
*/
extern		  	char S2V_Ack_Valid[LST_SZ];


		
//////////////////////////////////////////////////////////////////////////
// Functions

int	 	transform_udp_relay_packet(Buffer* buf, int prtcl, int pos, int hpos, int tsock, struct sockaddr_in ut_addr, 
																	int usock, struct sockaddr_in uu_addr, char* passwd);
int  	transform_udp_ipport   (Buffer* buf, int prtcl, int pos, int hpos, char* ip, 
																	int usock, struct sockaddr_in uu_addr, char* passwd);
int		transform_udp_relay_url(Buffer* buf, int prtcl, int pos, int varlen, int hpos, unsigned char mode, 
																	int tsock, struct sockaddr_in ut_addr, char* passwd);

int  	transform_udp_ping(Buffer* buf, unsigned int* extable, unsigned int size);
int  	transform_udp_ack (Buffer* buf, unsigned int* extable, unsigned int size);
Buffer  transform_udp_ack_cache_divid (Buffer* buf, unsigned int* extable1, unsigned int* extable2, unsigned int size);
int  	transform_udp_append_ack(Buffer* buf, unsigned int* extable, unsigned int size);
Buffer  transform_udp_append_ack_cache_divid (Buffer* buf, unsigned int* extable1, unsigned int* extable2, unsigned int size);

int		transform_udp_v2sc_ackseq(Buffer* buf, Buffer* cack);
int		transform_udp_v2s_ackseq (Buffer* buf);
int		transform_udp_s2v_ackseq (Buffer* buf);


// 注入サーバ 開発中
Buffer  transform_udp_ack_inject_divid(Buffer* buf, unsigned int* extable1, unsigned int* extable2, unsigned int size);
Buffer  transform_udp_append_ack_inject_divid(Buffer* buf, unsigned int* extable1, unsigned int* extable2, unsigned int size);
int  	transform_udp_s2vj_ackseq(Buffer* buf, Buffer* cack);

void	update_fromInject_sequenceno(Buffer buf);
int		update_j2s_sequenceno(Buffer buf);


// tools
void   	udp_rewrite_url(Buffer* buf, Buffer url, int pos, int varlen, char* ipaddr, unsigned short port);

void	update_fromServer_sequenceno(Buffer buf);
void	update_fromViewer_sequenceno(Buffer buf);
void	update_fromCache_sequenceno (Buffer buf);

int		update_c2v_sequenceno(Buffer buf);
int		update_s2v_sequenceno(Buffer buf);
int		update_v2s_sequenceno(Buffer buf);

void	update_p2v_ack_sequenceno(void);
void	update_p2s_ack_sequenceno(void);

int		check_seqnum_rewrite_mode(void);

void	udp_packet_counter_reset(void);
void	reverse_ack_seq(unsigned char* st, int no);




#endif
