/**  
	Second Life Relay Server: WEB Proxy for SL

				sl_web_proxy.c v1.0 by Fumi.Iseki (C)2008
*/


#define DISABLE_LDAP 0


#include "http_tool.h"
#include "ipaddr_tool.h"
#include "isnet.h"

#include "sl_relay.h"
#include "sl_web_proxy.h"



int 	Pofd = 0, Xofd = 0;
pid_t 	WebProxyRootPID;




int  sl_web_proxy_start(int port, char* myip, tList* allow)
{
	int	   cdlen, dm = 0;
	tList* pxdist = NULL;
	struct sockaddr_in sv_addr;
	struct sigaction sa;

	DEBUG_MODE print_message("[%d] SL_WEB_PROXY: Start Internal WEB Proxy. Port = %d\n", CrntPID, port);

	//WebProxyRootPID = getpid();
	if (CrntPID<=0) CrntPID = getpid();
	WebProxyRootPID = CrntPID;

	// シグナルハンドリング
	sa.sa_handler = sl_web_proxy_term;
	sa.sa_flags   = SA_NOCLDSTOP;
	sigemptyset(&sa.sa_mask);
	//sigaddset(&sa.sa_mask, SIGCHLD);
	sigaction(SIGINT,  &sa, NULL);
	sigaction(SIGHUP,  &sa, NULL);
	sigaction(SIGTERM, &sa, NULL);

	// チャイルドプロセス処理
	set_sigterm_child(sl_web_proxy_term_child);

	Pofd = tcp_server_socket_setopt(port, SO_REUSEADDR, (void*)&dm, sizeof(dm));
	if (Pofd<=0) {
		//syslog(SysLogLevel, "web_proxy_start: ERROR: server socket open error. [%d]", Pofd);
		DEBUG_MODE print_message("[%d] SL_WEB_PROXY_START: ERROR: server socket open error. [%d]\n", CrntPID, Pofd);
		return Pofd;
	}
	//DEBUG_MODE print_message("[%d] SL_WEB_PROXY: Start Internal WEB Proxy. Port = %d\n", CrntPID, port);

	if (RstrctIntWebProxy) {
		pxdist = read_tList_file(Proxy_Allow_File, ON);
		add_tList_node_bystr(pxdist, 0, 0, "127.0.0.1", NULL, NULL, 0);
	}

	Loop {
		cdlen = sizeof(sv_addr);
		Xofd = accept_intr(Pofd, (struct sockaddr*)&sv_addr, (socklen_t*)&cdlen);
		if (Xofd<0) {
			//syslog(SysLogLevel, "web_proxy_start: ERROR: accept() error. [%s]", strerror(errno));
			DEBUG_MODE print_message("[%d] SL_WEB_PROXY_START: ERROR: accept() error. %s\n", CrntPID, strerror(errno));
			sl_web_proxy_term(1);
		}

		char* ipadr = get_ipaddr(sv_addr.sin_addr);
		char* ipnum = (char*)to_address_num4(ipadr, 0);

		// IP Address check
		if (allow!=NULL && !is_host_in_list(allow, (unsigned char*)ipnum, NULL)) {
			//syslog(SysLogLevel, "web_proxy_start: ERROR: not allowed access to proxy from [%s]", ipadr);
			DEBUG_MODE print_message("[%d] WEB_PROXY_START: ERROR: not allowed access to proxy from [%s]\n", CrntPID, ipadr);

			freeNull(ipadr);
			freeNull(ipnum);
			close(Xofd);
			Xofd = 0;
			continue;
		}
		freeNull(ipadr);
		freeNull(ipnum);

		if (fork()==0) {
			CrntPID = getpid();
			//simple_web_proxy(Xofd, myip, 3);
			sl_web_proxy(Xofd, myip, 3, pxdist);
			close(Xofd);
			Xofd = 0;
			exit(0);
		}

		close(Xofd);
		Xofd = 0;
	}

	// not reachable
	socket_close(Pofd);
	Pofd = 0;
	sl_web_proxy_term(0);
}



//////////////////////////////////////////////////////////////////////////
// プログラムの終了
//
void  sl_web_proxy_term(int sig)
{  
	pid_t pid;

	pid = getpid();
	DEBUG_MODE print_message("[%d] SL_WEB_PROXY_TERM: going down!!\n", CrntPID);

	// Root Process
	if (pid==WebProxyRootPID) {
		if (Pofd>0) socket_close(Pofd);
		if (Xofd>0) socket_close(Xofd);
		Pofd = Xofd = 0;
		DEBUG_MODE print_message("[%d] SL_WEB_PROXY_TERM: this process is web proxy root process.\n", CrntPID);
	}

	exit(sig);
}



/**			   
void  sl_web_proxy_term_child(int sig)
				  
	機能：child プロセス終了時の処理
*/				
void  sl_web_proxy_term_child(int signal)
{				
	pid_t pid = 0;
	int ret;

	//DEBUG_MODE print_message("[%d] SL_WEB_PROXY_TERM_CHILD: called. signal = %d\n", CrntPID, signal);
				  
	do {	// チャイルドプロセスの終了を待つ   
		pid = waitpid(-1, &ret, WNOHANG);
	} while(pid>0);
}




///////////////////////////////////////////////////////////////////////////////////////////////////
//
// HTTP Simple Proxy
//

/**
void  sl_web_proxy(int bofd, char* myip, int tmout, tList* pxdist)

	機能：簡易WEBプロキシ．WWW通信をリレーする．
		  全てのHTTPプロトコルをサポートしている訳ではない．
		  接続はできる限りの範囲でしか維持しない．

		  xLib の simple_web_proxy() に接続先制限モードを追加したもの．

	引数：bofd -- ブラウザとの通信ソケット
		  myip -- 自分のIPアドレス．
		  tmout - タイムアウト

	注意：呼び出し側でソケット bofdをクローズすること．
		  これを使用する特別の理由が無い限りは「ヤリイカ」などを使用してください．
*/
void  sl_web_proxy(int bofd, char* myip, int tmout, tList* pxdist)
{
	int  	wofd = 0;
	int  	len, cc, nd, state, allow_proxy;
	int  	btm, wtm, keep;
	char*	ipa;
	tList*	pl;

	unsigned short sport = 0;
	Buffer 	server, com;

	fd_set  mask;
	struct timeval timeout;

	//DEBUG_MODE print_message("[%d] SIMPLE_WEB_PROXY: Start Simple WEB Proxy.\n", CrntPID);

	//init_rand();
	if (tmout<0) tmout = PROXY_TIMEOUT;
	btm = wtm = tmout;
	keep = TRUE;

	do {
		timeout.tv_sec  = btm*10;
		timeout.tv_usec = 0;
		FD_ZERO(&mask); 
		FD_SET(bofd, &mask);
		nd = select(bofd+1, &mask, NULL, NULL, &timeout);
	} while (nd<0);

	while (FD_ISSET(bofd, &mask) && keep) {
		cc = recv_http_header(bofd, &pl, &len, NULL, &state);
		if (cc<=0) break;
		if (pl==NULL) break;

		/*
		DEBUG_MODE {
			print_message("[%d] --- Web Proxy Request ---\n", CrntPID);
			print_tList(stderr, pl);
			print_message("\n");
		}*/

		com = http_proxy_header_anlys(pl, &server, &sport, &btm, &keep);
		if (btm==0) btm = tmout;
		else		btm = Min(btm, 60);

		wofd = 0;
		if (server.buf!=NULL && sport!=0) {
			DEBUG_MODE print_message("[%d] SL_WEB_PROXY: connect to %s:%d\n", CrntPID, server.buf, sport);

			ipa = get_ipaddr_byname((char*)server.buf);
			if (ipa!=NULL && !strcmp(ipa, myip)) {
				free_Buffer(&server);
				server = make_Buffer_bystr("127.0.0.1");
			}
			freeNull(ipa);

			// 接続制限モード
			allow_proxy = TRUE;
			if (strncaservscmp_tList(pxdist, (char*)server.buf, -1, 1)==NULL) {
				print_message("[%d] SL_WEB_PROXY: WARNING: access from unknown node [%s]\n", CrntPID, server.buf);
				if (RstrctIntWebProxy) {
					DEBUG_MODE print_message("[%d] SL_WEB_PROXY: access from %s is denied\n", CrntPID, server.buf);
					allow_proxy = FALSE;
				}
			}

			if (allow_proxy) {
				wofd = tcp_client_socket((char*)server.buf, sport);
			}
			free_Buffer(&server);
		}

		if (wofd<=0) {
			free_Buffer(&com);
			del_tList(&pl);
			break;
		}

		// for HTTPS
		if (com.buf!=NULL && !strcasecmp((char*)com.buf, "CONNECT")) {
			cc = tcp_send(bofd, "HTTP/1.1 200 Connection established.\r\nProxy-Connection: close\r\n\r\n", 0);
			cc = tcp_relay(bofd, wofd, 5);

			del_tList(&pl);
			free_Buffer(&com);
			break;
		}
		free_Buffer(&com);

		cc = send_http_header(wofd, pl, ON);
		if (cc<len && state) {
			Buffer buf = make_Buffer(RECVBUFSZ);
			cc = recv_http_content(bofd, &buf, len-cc, wtm, NULL, &state);
			if (cc<=0) {
				del_tList(&pl);
				break;
			}

			tcp_send_Buffer(wofd, &buf);
			free_Buffer(&buf);
		}
		del_tList(&pl);

		cc = www2browser_relay(bofd, wofd, btm, wtm, keep);
		if (cc<=0) break;

		do {
			timeout.tv_sec  = btm;
			timeout.tv_usec = 0;
			FD_ZERO(&mask); 
			FD_SET(bofd, &mask);
			nd = select(bofd+1, &mask, NULL, NULL, &timeout);
		} while (nd<0);;
	}

	socket_close(wofd);

	return;
}




